/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface and inherited behavior describes the configurable properties for an converter. One
 * or more converters can be declared as part of an entity
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see org.eclipse.persistence.annotations.TypeConverter
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalTypeConverter extends ExternalConverter {

	/**
	 * The attribute name used to store and retrieve the data-type property.
	 */
	String DATA_TYPE = "data-type";

	/**
	 * The attribute name used to store and retrieve the object-type property.
	 */
	String OBJECT_TYPE = "object-type";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String TYPE_CONVERTER = "type-converter";

	/**
	 * Returns the data type name for this converter.
	 */
	String getDatatype();

	/**
	 * Returns the {@link TextRange} for the data type name value.
	 */
	TextRange getDatatypeTextRange();

	/**
	 * Returns the object type name for this converter.
	 */
	String getObjecttype();

	/**
	 * Returns the {@link TextRange} for the object type name value.
	 */
	TextRange getObjecttypeTextRange();

	/**
	 * Sets the data type name for this converter.
	 */
	void setDatatype(String datatypeName);

	/**
	 * Sets the object type name for this converter.
	 */
	void setObjecttype(String objecttypeName);
}