/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalDiscriminatorClass;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

/**
 * The external form of the discriminator class.
 *
 * @see VariableOneToOneMapping
 *
 * @version 2.6
 */
final class DiscriminatorClass extends AbstractExternalForm
                               implements ExternalDiscriminatorClass {

	/**
	 * The position of the element within the list of children with the same type owned by the parent.
	 */
	private int index;

	/**
	 * Creates a new <code>DiscriminatorClass</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned by the parent
	 */
	DiscriminatorClass(VariableOneToOneMapping parent, int index) {
		super(parent);
		this.index = index;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(DISCRIMINATOR);
		names.add(VALUE);
		return names;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void calculateInsertionIndex(Element parent, Element child, String elementName) {
		if (elementName == getElementName()) {
			index = index(parent, child, elementName);
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDiscriminator() {
		return getAttribute(DISCRIMINATOR);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getDiscriminatorTextRange() {
		return getAttributeTextRange(DISCRIMINATOR);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Element getElement() {
		return getChild(getParent(), DISCRIMINATOR_CLASS, index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return DISCRIMINATOR_CLASS;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getValue() {
		return getAttribute(VALUE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getValueTextRange() {
		return getAttributeTextRange(VALUE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void removeSelf() {
		removeChild(getParent(), getElementName(), index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDiscriminator(String discriminator) {
		setAttribute(DISCRIMINATOR, discriminator);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setValue(String value) {
		setAttribute(VALUE, value);
	}
}