/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

/**
 * The external form of an entity listener that is defined on a mapped superclass or entity.
 *
 * @see MappedSuperClassEntity
 *
 * @version 2.6
 */
final class EntityEntityListener extends AbstractEntityListener {

	/**
	 * Creates a new <code>EntityEntityListener</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned by the parent
	 */
	EntityEntityListener(MappedSuperclass parent, int index) {
		super(parent, index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Element addSelf(String elementName, List<String> elementNamesOrder) {

		Element element = getParent().getChild(ENTITY_LISTENERS);

		if (element == null) {
			element = getParent().addChild(ENTITY_LISTENERS);
		}

		return addChild(element, elementName, Collections.<String>emptyList());
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Element getElement() {

		Element parentElement = getParentElement();

		if (parentElement == null) {
			return null;
		}

		Element element = getChild(parentElement, ENTITY_LISTENERS);

		if (element == null) {
			return null;
		}

		return getChild(element, ENTITY_LISTENER, getIndex());
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void removeSelf() {

		Element parentElement = getParentElement();

		if (parentElement == null) {
			return;
		}

		Element element = getChild(parentElement, ENTITY_LISTENERS);

		if (element != null) {
			removeChild(element, ENTITY_LISTENER, getIndex());

			// Remove "entity-listeners" if it has no children
			if (!hasAnyChildren(element)) {
				remove(parentElement, element);
			}
		}
	}
}