/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

/**
 * The external form of a primary table.
 *
 * @see Entity
 *
 * @version 2.6
 */
final class PrimaryTable extends Table {

	/**
	 * Creates a new <code>EntityTable</code>.
	 *
	 * @param parent The parent of this external form
	 */
	PrimaryTable(Entity parent) {
		super(parent);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return TABLE;
	}
}