/*******************************************************************************
 * Copyright (c) 2008, 2012 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.gen.db;

/**
 * An empty implementation of {@link ConnectionProfileListener}.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.
 *
 * @version 2.6
 */
public class ConnectionProfileAdapter implements ConnectionProfileListener {

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void connectionProfileAdded(String name) {
		// do nothing
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void connectionProfileRemoved(String name) {
		// do nothing
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void connectionProfileRenamed(String oldName, String newName) {
		// do nothing
	}
}