/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.tests.dom.orm;

import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.junit.runners.Suite.SuiteClasses;

/**
 * The test suite for the unit-tests defined in the same package, which contains the tests testing
 * the ORM Configuration SPI.
 *
 * @version 2.6
 */
@SuiteClasses({

	// Root node
	ORMConfigurationTests.class,

	// Managed types
	EmbeddableTests.class,
	MappedSuperclassTests.class,
	EntityTests.class,

	// Mappings
	BasicMappingTests.class,
	BasicCollectionMappingTests.class,
	BasicMapMappingTests.class,
	ElementCollectionMappingTests.class,
	EmbeddedMappingTests.class,
	EmbeddedIdMappingTests.class,
	IdMappingTests.class,
	ManyToManyMappingTests.class,
	ManyToOneMappingTests.class,
	OneToManyMappingTests.class,
	OneToOneMappingTests.class,
	TransformationMappingTests.class,
	TransientMappingTests.class,
	VariableOneToOneMappingTests.class,
	VersionMappingTests.class,
	TransientMappingTests.class,

	// Various properties
	AccessMethodsTests.class,
//	AdditionalCriteriaTests.class, // Not supported
	CacheTests.class
//	CacheInterceptorTests.class,
//	ChangeTrackingTests.class,
//	CustomizerTests.class,
//	PersistenceUnitMetadataTests.class,
//	PersistenceUnitDefaults.class,
//	PartitioningGroupTests.class,
//	AssociationOverrideTests.class,
//	AttributeOverrideTests.class,
//	AttributesTests.class,
//	ClassExtractorTests.class,
//	CloneCopyPolicyTests.class,
//	ColumnTests.class,
//	CollectionTableMappingTests.class,
//	EclipseLinkCollectionTableMappingTests.class,
//	ConversionValueTests.class,
//	MixedConverterTests.class,
//	ConverterTestsTests.class,
////	PartitioningTests.class, // Not supported
////	HashPartitioningTests.class, // Not supported
////	RangePartitioningTests.class, // Not supported
////	RangePartitionTests.class, // Not supported
////	ValuePartitioningTests.class, // Not supported
////	RoundRobinPartitioningTests.class, // Not supported
////	ReplicationPartitioningTests.class, // Not supported
////	UnionPartitioningTests.class, // Not supported
////	PinnedPartitioningTests.class, // Not supported
//	ColumnResultTests.class,
//	ConstructorResult.class,
//	ConvertTests.class,
//	CopyPolicyTests.class,
//	DiscriminatorColumnTests.class,
//	DiscriminatorClassTests.class,
//	ArrayTests.class,
//	EntityListenerTests.class,
//	EntityListenersTests.class,
//	EntityResultTests.class,
//	EnumeratedTests.class,
//	FetchAttributeTests.class,
//	FetchGroupTests.class,
//	FetchResultTests.class,
//	ForeignKeyTests.class,
//	GeneratedValueTests.class,
//	IdClassTests.class,
//	InheritanceTests.class,
//	InstantiationCopyPolicyTests.class,
//	JoinColumnTests.class,
//	JoinTableTests.class,
//	LobTests.class,
//	MapKeyTests.class,
//	MapKeyClassTests.class,
//	MapKeyColumnTests.class,
//	MapKeyJoinColumnTests.class,
//	MultitenantTests.class,
//	NamedAttributeNodeTests.class,
//	NamedEntityGraphTests.class,
//	NamedNativeQueryTests.class,
//	NamedQueryTests.class,
//	NamedStoredProcedureQueryTests.class,
//	NamedSubgraphTests.class,
//	NamedStoredFunctionQueryTests.class,
//	NamedPlsqlStoredFunctionQueryTests.class,
//	NamedPlsqlStoredProcedureQueryTests.class,
//	OracleObjectTests.class,
//	OracleArrayTests.class,
//	PlsqlRecordTests.class,
//	PlsqlTableTests.class,
//	ObjectTypeConverterTests.class,
//	OptimisticLockingTests.class,
//	OrderByTests.class,
//	OrderColumnTests.class,
//	PostLoadTests.class,
//	PostPersistTests.class,
//	PostRemoveTests.class,
//	PostUpdateTests.class,
//	PrePersistTests.class,
//	PreRemoveTests.class,
//	PreUpdateTests.class,
//	PrimaryKeyTests.class,
//	PrimaryKeyJoinColumnTests.class,
//	PropertyTests.class,
//	QueryHintTests.class,
//	QueryRedirectorsTests.class,
//	ReadTransformerTests.class,
//	ReturnInsertTests.class,
//	SecondaryTableTests.class,
//	SequenceGeneratorTests.class,
//	SerializedObjectTests.class,
//	SqlResultSetMappingTests.class,
//	StoredProcedureParameterTests.class,
//	PlsqlParameterTests.class,
//	StructConverterTests.class,
//	StructTests.class,
//	StructureTests.class,
//	TableTests.class,
//	IndexTests.class,
//	EclipseLinkIndexTests.class,
//	CacheIndexTests.class,
//	TableGeneratorTests.class,
//	UuidGeneratorTests.class,
//	TemporalTests.class,
//	TenantDiscriminatorColumnTests.class,
//	TenantTableDiscriminatorTests.class,
//	TimeOfDayTests.class,
//	TypeConverterTests.class,
//	SerializedConverterTests.class,
//	UniqueConstraintTests.class,
//	WriteTransformerTests.class,
//	BatchFetchTests.class,
//	NoSqlTests.class,
//	FieldTests.class,
//	JoinFieldTests.class,
})
@RunWith(Suite.class)
public final class AllORMTests {

	private AllORMTests() {
		super();
	}
}