/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility;

/**
 * The exception used to be thrown when asserting.
 *
 * @see Assert
 *
 * @version 2.6
 */
public class AssertionFailedException extends RuntimeException {

	/**
	 * The serial version number of this class.
	 */
	static final long serialVersionUID = 3312027513928750865L;

	/**
	 * Creates a new <code>AssertionFailedException</code>.
	 *
	 * @param detail The detail message of the exception
	 */
	public AssertionFailedException(String detail) {
		super(detail);
	}
}