/*******************************************************************************
 * Copyright (c) 2008, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.command;

/**
 * Wrap a {@link Command} so it can be used as a {@link Runnable}.
 */
@SuppressWarnings("nls")
public class CommandRunnable
	implements Runnable
{
	protected final Command command;

	public CommandRunnable(Command command) {
		super();
		if (command == null) {
			throw new NullPointerException();
		}
		this.command = command;
	}

	@Override
	public void run() {
		this.command.execute();
	}

	@Override
	public String toString() {
		return "Runnable[" + this.command +']';
	}
}