/*******************************************************************************
 * Copyright (c) 2012, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.iterable;

import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.iterator.EmptyListIterator;

/**
 * Convenience list iterable that returns an empty iterator.
 */
public class ListIterableAdapter<E>
	implements ListIterable<E>
{
	@Override
	public ListIterator<E> iterator() {
		return EmptyListIterator.instance();
	}

	@Override
	public String toString() {
		return ObjectTools.toString(this);
	}
}