/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.mapping.conversion;

import junit.framework.TestCase;
import org.eclipse.persistence.internal.mappings.converters.AttributeNamePrefix;
import org.junit.Test;

public class AttributeNamePrefixTest
extends TestCase {
    private static final String[] NAMES = new String[AttributeNamePrefix.LENGTH];

    @Test
    public void testToValue() {
        int i;
        String[] wrongValuesFirstLetter = new String[AttributeNamePrefix.LENGTH];
        String[] wrongValuesUpperCase = new String[AttributeNamePrefix.LENGTH];
        for (i = 0; i < AttributeNamePrefix.LENGTH; ++i) {
            int length = NAMES[i].length();
            StringBuilder sbFl = new StringBuilder(NAMES.length);
            if (length > 0) {
                sbFl.append(Character.toUpperCase(NAMES[i].charAt(0)));
                if (length > 1) {
                    sbFl.append(NAMES[i].substring(1));
                }
            }
            wrongValuesFirstLetter[i] = sbFl.toString();
            wrongValuesUpperCase[i] = NAMES[i].toUpperCase();
        }
        for (i = 0; i < AttributeNamePrefix.LENGTH; ++i) {
            AttributeNamePrefix prefix = AttributeNamePrefix.toValue((String)NAMES[i]);
            AttributeNamePrefixTest.assertNotNull((String)"No attribute prefix enumeration value was found.", (Object)prefix);
        }
        for (i = 0; i < AttributeNamePrefix.LENGTH; ++i) {
            AttributeNamePrefix prefix = AttributeNamePrefix.toValue((String)wrongValuesFirstLetter[i]);
            if (i == 0) {
                AttributeNamePrefixTest.assertNotNull((String)"No attribute prefix enumeration value was found for NULL name.", (Object)prefix);
                continue;
            }
            AttributeNamePrefixTest.assertNull((String)"Attribute prefix enumeration value was found for invalid name.", (Object)prefix);
        }
        for (i = 0; i < AttributeNamePrefix.LENGTH; ++i) {
            AttributeNamePrefix prefix = AttributeNamePrefix.toValue((String)wrongValuesFirstLetter[i]);
            if (i == 0) {
                AttributeNamePrefixTest.assertNotNull((String)"No attribute prefix enumeration value was found for NULL name.", (Object)prefix);
                continue;
            }
            AttributeNamePrefixTest.assertNull((String)"Attribute prefix enumeration value was found for invalid name.", (Object)prefix);
        }
    }

    static {
        int i = 0;
        for (AttributeNamePrefix value : AttributeNamePrefix.values()) {
            AttributeNamePrefixTest.NAMES[i++] = value.getName();
        }
    }
}

