/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;
import org.eclipse.persistence.platform.server.ServerPlatformBase;
import org.eclipse.persistence.platform.server.ServerPlatformDetector;
import org.eclipse.persistence.platform.server.ServerPlatformUtils;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SessionManagerTest
extends TestCase {
    private List<ServerPlatformDetector> detectors;

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
        if (this.detectors != null) {
            Iterator<ServerPlatformDetector> i = this.detectors.iterator();
            while (i.hasNext()) {
                ServerPlatformDetector detector = i.next();
                if (!Detector.class.getName().equals(detector.getClass().getName())) continue;
                i.remove();
                break;
            }
            this.setStaticField(ServerPlatformUtils.class, "SERVER_PLATFORM_CLS", null);
        }
        this.reinitManager(false);
    }

    @Test
    public void testConcurrency() {
        this.reinitManager(true);
        SessionManager sm = SessionManager.getManager();
        Assert.assertEquals((Object)"test", (Object)this.getField(SessionManager.class, "context", sm));
        Platform platform = (Platform)((Object)this.getField(SessionManager.class, "detectedPlatform", sm));
        CountDownLatch startSignal = new CountDownLatch(1);
        CountDownLatch doneSignal = new CountDownLatch(1000);
        for (int i = 0; i < 1000; ++i) {
            new Thread(new Worker(startSignal, doneSignal, platform)).start();
        }
        ContextSwitcher cs = new ContextSwitcher(platform);
        Thread contextSwitcher = new Thread(cs);
        contextSwitcher.start();
        startSignal.countDown();
        try {
            doneSignal.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        cs.stop = true;
        try {
            contextSwitcher.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Set contexts = cs.values;
        ConcurrentMap registeredManagers = (ConcurrentMap)this.getField(SessionManager.class, "managers", null);
        for (String context : contexts) {
            if ("test".equals(context)) continue;
            platform.partitionId = context;
            SessionManager.getManager().destroy();
        }
        Assert.assertEquals((long)1L, (long)registeredManagers.size());
    }

    @Test
    public void testAllManagers() {
        Collection allManagers = SessionManager.getAllManagers();
        Assert.assertEquals((long)1L, (long)allManagers.size());
        Assert.assertNull((Object)this.getField(SessionManager.class, "context", allManagers.iterator().next()));
        this.reinitManager(true);
        allManagers = SessionManager.getAllManagers();
        Assert.assertEquals((long)1L, (long)allManagers.size());
        Assert.assertEquals((Object)"test", (Object)this.getField(SessionManager.class, "context", allManagers.iterator().next()));
    }

    @Test
    public void testCustomManager() {
        SM sm = new SM();
        SessionManager.setManager((SessionManager)sm);
        SessionManager m1 = SessionManager.getManager();
        Assert.assertNotNull((Object)m1);
        Assert.assertNull((Object)this.getField(SessionManager.class, "context", m1));
        Collection allManagers = SessionManager.getAllManagers();
        Assert.assertEquals((long)1L, (long)allManagers.size());
        Assert.assertTrue((sm == allManagers.iterator().next() ? 1 : 0) != 0);
        this.reinitManager(true);
        SessionManager.setManager((SessionManager)sm);
        m1 = SessionManager.getManager();
        Assert.assertNotNull((Object)m1);
        Assert.assertEquals((Object)"test", (Object)this.getField(SessionManager.class, "context", m1));
        allManagers = SessionManager.getAllManagers();
        Assert.assertEquals((long)1L, (long)allManagers.size());
        Assert.assertTrue((sm == allManagers.iterator().next() ? 1 : 0) != 0);
        sm.destroy();
    }

    private void reinitManager(boolean addDetector) {
        if (addDetector) {
            this.detectors = (List)this.getField(ServerPlatformUtils.class, "PLATFORMS", null);
            this.detectors.add(0, new Detector());
            this.setStaticField(ServerPlatformUtils.class, "SERVER_PLATFORM_CLS", null);
        }
        Method m = null;
        try {
            m = SessionManager.class.getDeclaredMethod("init", new Class[0]);
            m.setAccessible(true);
            m.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (m != null) {
                try {
                    m.setAccessible(false);
                }
                catch (Exception exception) {}
            }
        }
    }

    private Object getField(Class c, String field, Object o) {
        Field f = null;
        try {
            f = c.getDeclaredField(field);
            f.setAccessible(true);
            Object object = f.get(o);
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (f != null) {
                f.setAccessible(false);
            }
        }
    }

    private void setStaticField(Class c, String field, Object value) {
        Field f = null;
        try {
            f = c.getDeclaredField(field);
            this.setPrivateStaticFinalField(f, value);
        }
        catch (IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (f != null) {
                f.setAccessible(false);
            }
        }
    }

    private void setPrivateStaticFinalField(Field f, Object value) {
        Field modifiersField = null;
        int orig = 0;
        try {
            f.setAccessible(true);
            orig = f.getModifiers();
            if (Modifier.isFinal(orig)) {
                modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(f, orig & 0xFFFFFFEF);
            }
            f.set(null, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (modifiersField != null) {
                if (f != null) {
                    try {
                        modifiersField.setInt(f, orig);
                    }
                    catch (IllegalAccessException | IllegalArgumentException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                modifiersField.setAccessible(false);
            }
            if (f != null) {
                f.setAccessible(false);
            }
        }
    }

    private static final class Worker
    implements Runnable {
        private final CountDownLatch startSignal;
        private final CountDownLatch doneSignal;
        private final Platform p;

        Worker(CountDownLatch startSignal, CountDownLatch doneSignal, Platform p) {
            this.startSignal = startSignal;
            this.doneSignal = doneSignal;
            this.p = p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.startSignal.await();
                SessionManager sm = SessionManager.getManager();
                Assert.assertNotNull((Object)sm);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.doneSignal.countDown();
            }
        }
    }

    private static final class ContextSwitcher
    implements Runnable {
        private final Random r = new Random(System.currentTimeMillis());
        private volatile boolean stop = false;
        private final Platform p;
        private final Set<String> values = new HashSet<String>();

        public ContextSwitcher(Platform p) {
            this.p = p;
        }

        @Override
        public void run() {
            while (!this.stop) {
                String id = String.valueOf(this.r.nextInt(10));
                this.p.partitionId = id;
                this.values.add(id);
                try {
                    Thread.sleep(this.r.nextInt(3));
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static class Detector
    implements ServerPlatformDetector {
        private Detector() {
        }

        public String checkPlatform() {
            return Platform.class.getName();
        }
    }

    public static final class Platform
    extends ServerPlatformBase {
        private volatile String partitionId = "test";

        public Platform(DatabaseSession newDatabaseSession) {
            super(newDatabaseSession);
        }

        public Class getExternalTransactionControllerClass() {
            return null;
        }

        public boolean usesPartitions() {
            return true;
        }

        public String getPartitionID() {
            return this.partitionId;
        }
    }

    private static final class SM
    extends SessionManager {
    }
}

