/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Enumeration;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.DeleteObjectTest;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.Project;

public class DeletingFromParentSessionTest
extends DeleteObjectTest {
    public Address address;

    public DeletingFromParentSessionTest() {
        this.setDescription("This test deletes an object from a unit of work, and checks to make sure it is removed from the parent session's cache.");
    }

    protected void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.originalObject = uow.readObject(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)"John"));
        this.address = ((Employee)this.originalObject).getAddress();
        ((Employee)this.originalObject).getManagedEmployees();
        ((Employee)this.originalObject).getPhoneNumbers();
        Enumeration mgdEnum = ((Employee)this.originalObject).getManagedEmployees().elements();
        while (mgdEnum.hasMoreElements()) {
            ((Employee)mgdEnum.nextElement()).setManager(null);
        }
        Enumeration mgdProjEnum = ((Employee)this.originalObject).getProjects().elements();
        while (mgdProjEnum.hasMoreElements()) {
            ((Project)mgdProjEnum.nextElement()).setTeamLeader(null);
        }
        uow.deleteObject(this.originalObject);
        uow.commit();
    }

    public void verify() {
        Object primaryKey = this.getSession().getId(this.originalObject);
        if (this.getSession().getIdentityMapAccessor().containsObjectInIdentityMap(primaryKey, this.originalObject.getClass())) {
            throw new TestException("The object " + this.originalObject + " was deleted from the unit of work cache, but " + "not the parent session's cache.");
        }
        primaryKey = this.getSession().getId((Object)this.address);
        if (this.getSession().getIdentityMapAccessor().containsObjectInIdentityMap(primaryKey, this.address.getClass())) {
            throw new TestException("The object " + this.address + " was deleted from the unit of work cache, but " + "not the parent session's cache.");
        }
    }
}

