/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.relationshipmaintenance;

import java.util.Vector;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.relationshipmaintenance.FieldOffice;
import org.eclipse.persistence.testing.models.relationshipmaintenance.SalesPerson;

public class AddReferencedObjectTest
extends AutoVerifyTestCase {
    public FieldOffice fieldOfficeClone;
    public FieldOffice secondOfficeClone;
    public SalesPerson sales = null;

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.beginTransaction();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Vector offices = uow.readAllObjects(FieldOffice.class);
        this.fieldOfficeClone = (FieldOffice)offices.elementAt(0);
        this.secondOfficeClone = (FieldOffice)offices.elementAt(1);
        this.sales = (SalesPerson)this.fieldOfficeClone.getSalespeople().iterator().next();
        this.secondOfficeClone.getSalespeople().add(this.sales);
        uow.commit();
    }

    public void verify() {
        if (!this.secondOfficeClone.getSalespeople().contains(this.sales) || this.sales.getFieldOffice() == null || this.fieldOfficeClone.getSalespeople().contains(this.sales)) {
            throw new TestErrorException("Failed to set the backPointer information");
        }
    }
}

