/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.InterfaceDescriptorCreationException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.NewClassNameDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class CreateNewClassAction
extends AbstractEnablableFrameworkAction {
    CreateNewClassAction(WorkbenchContext context) {
        super(context);
    }

    @Override
    protected void initialize() {
        this.initializeTextAndMnemonic("CREATE_NEW_CLASS_ACTION");
        this.initializeAccelerator("CREATE_NEW_CLASS_ACTION.accelerator");
        this.initializeToolTipText("CREATE_NEW_CLASS_ACTION.toolTipText");
        this.initializeIcon("descriptor.new");
    }

    @Override
    protected void execute() {
        this.promptToCreateNewClass(this.selectedNodes()[0]);
    }

    private void promptToCreateNewClass(ApplicationNode selectedNode) {
        MWDescriptor descriptor;
        MWProject project = (MWProject)selectedNode.getProjectRoot().getValue();
        NewClassNameDialog dialog = this.buildNewClassNameDialog(project, selectedNode);
        dialog.setTitle(this.resourceRepository().getString("ADD_CLASS_DIALOG_TITLE"));
        dialog.setVisible(true);
        if (dialog.wasCanceled()) {
            return;
        }
        String typeName = dialog.className();
        this.navigatorSelectionModel().pushExpansionState();
        MWClass type = project.getClassRepository().typeNamed(typeName);
        type.addZeroArgumentConstructor();
        try {
            descriptor = project.addDescriptorForType(type);
        }
        catch (InterfaceDescriptorCreationException ex) {
            throw new RuntimeException(ex);
        }
        ((AbstractApplicationNode)selectedNode.getProjectRoot()).selectDescendantNodeForValue((Node)descriptor, this.navigatorSelectionModel());
        this.navigatorSelectionModel().popAndRestoreExpansionState();
    }

    private NewClassNameDialog buildNewClassNameDialog(MWProject project, ApplicationNode selectedNode) {
        return new NewClassNameDialog(this.buildPackageNames(project), this.buildPackageName(selectedNode), project, this.getWorkbenchContext());
    }

    private Collection buildPackageNames(MWProject project) {
        FilteringIterator packageNames = new FilteringIterator(project.packageNames()){

            protected boolean accept(Object packageName) {
                return ((String)packageName).length() > 0;
            }
        };
        return CollectionTools.collection((Iterator)packageNames);
    }

    private String buildPackageName(ApplicationNode selectedNode) {
        return ((MappingsApplicationNode)selectedNode).candidatePackageName();
    }

    @Override
    protected boolean shouldBeEnabled(ApplicationNode selectedNode) {
        return false;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.selectedNodes().length == 1);
    }
}

