/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionAdapter;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.MultipleClassChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.TitledPropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWInterfaceDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.UiCommonBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.DescriptorCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UiDescriptorBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational.UiDescriptorRelationalBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.UiQueryBundle;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;

public class InterfaceDescriptorPropertiesPage
extends TitledPropertiesPage {
    private static final Class[] REQUIRED_RESOURCE_BUNDLES = new Class[]{UiCommonBundle.class, UiQueryBundle.class, UiDescriptorBundle.class, UiDescriptorRelationalBundle.class};

    public InterfaceDescriptorPropertiesPage(WorkbenchContext context) {
        super(context);
    }

    @Override
    protected Component buildPage() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        LabelArea label = new LabelArea();
        label.setText(this.resourceRepository().getString("CHOOSE_DESCRIPTORS_THAT_IMPLEMENT_LABEL"));
        label.setFont(label.getFont().deriveFont(1));
        label.setScrollable(true);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 21;
        constraints.fill = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridheight = 1;
        constraints.gridwidth = 2;
        constraints.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)label, constraints);
        JLabel implementorsLabel = this.buildLabel("IMPLEMENTORS_LABEL");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.anchor = 23;
        constraints.fill = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.insets = new Insets(5, 5, 0, 5);
        panel.add((Component)implementorsLabel, constraints);
        AddRemoveListPanel implementorsPanel = new AddRemoveListPanel(this.getApplicationContext(), this.buildAddRemoveAdapter(), this.buildImplementorsListValueModel());
        implementorsPanel.setCellRenderer(this.buildImplementorsListCellRenderer());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.anchor = 19;
        constraints.fill = 1;
        constraints.weightx = 0.5;
        constraints.weighty = 1.0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.addHelpTopicId(implementorsPanel, this.helpTopicId() + ".implementors");
        panel.add((Component)implementorsPanel, constraints);
        JLabel queryKeysLabel = this.buildLabel("COMMON_QUERY_KEYS_LABEL");
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.anchor = 23;
        constraints.fill = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.insets = new Insets(5, 5, 0, 5);
        panel.add((Component)queryKeysLabel, constraints);
        JList queryKeyList = SwingComponentFactory.buildList(this.buildQueryKeyListModel());
        queryKeyList.setEnabled(false);
        JScrollPane queryKeyListScrollPane = new JScrollPane(queryKeyList);
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.anchor = 11;
        constraints.fill = 1;
        constraints.weightx = 0.5;
        constraints.weighty = 1.0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.addHelpTopicId(queryKeyListScrollPane, this.helpTopicId() + ".commonQueryKeys");
        panel.add((Component)queryKeyListScrollPane, constraints);
        JComponent commentPanel = SwingComponentFactory.buildCommentPanel(this.getSelectionHolder(), this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)commentPanel, constraints);
        this.addHelpTopicId(commentPanel, "descriptor.general.comment");
        this.addHelpTopicId(panel, this.helpTopicId());
        return panel;
    }

    private AddRemovePanel.Adapter buildAddRemoveAdapter() {
        return new AddRemovePanel.Adapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                ClassDescriptionRepository repository = this.buildClassDescriptionRepository();
                ClassDescriptionAdapter adapter = this.buildClassDescriptionAdapter();
                MultipleClassChooserDialog dialog = this.buildMultipleClassChooserDialog(repository, adapter);
                dialog.setTitle(InterfaceDescriptorPropertiesPage.this.resourceRepository().getString("IMPLEMENTOR_DESCRIPTOR_LIST_BROWSER_DIALOG.title"));
                dialog.show();
                if (dialog.wasConfirmed()) {
                    MWInterfaceDescriptor interfaceDescriptor = (MWInterfaceDescriptor)InterfaceDescriptorPropertiesPage.this.selection();
                    Iterator iter = dialog.selectedClassDescriptions();
                    while (iter.hasNext()) {
                        MWTableDescriptor selectedDescriptor = (MWTableDescriptor)iter.next();
                        interfaceDescriptor.addImplementor((MWDescriptor)selectedDescriptor);
                    }
                }
                dialog = null;
                MultipleClassChooserDialog.gc();
            }

            private MultipleClassChooserDialog buildMultipleClassChooserDialog(ClassDescriptionRepository repository, ClassDescriptionAdapter adapter) {
                MultipleClassChooserDialog dialog = new MultipleClassChooserDialog(InterfaceDescriptorPropertiesPage.this.getWorkbenchContext(), repository, adapter){

                    @Override
                    protected Iterator buildCustomActions() {
                        return NullIterator.instance();
                    }

                    @Override
                    protected String helpTopicId() {
                        return "dialog.chooseImplementorDescriptor";
                    }
                };
                return dialog;
            }

            private ClassDescriptionAdapter buildClassDescriptionAdapter() {
                ClassDescriptionAdapter adapter = new ClassDescriptionAdapter(){

                    @Override
                    public String additionalInfo(Object classDescription) {
                        return null;
                    }

                    @Override
                    public String className(Object classDescription) {
                        return ((MWDescriptor)classDescription).getMWClass().getName();
                    }

                    @Override
                    public String packageName(Object classDescription) {
                        return ((MWDescriptor)classDescription).packageName();
                    }

                    @Override
                    public String shortClassName(Object classDescription) {
                        return ((MWDescriptor)classDescription).shortName();
                    }
                };
                return adapter;
            }

            private ClassDescriptionRepository buildClassDescriptionRepository() {
                ClassDescriptionRepository repository = new ClassDescriptionRepository(){

                    @Override
                    public Iterator classDescriptions() {
                        ArrayList<MWDescriptor> implementors = new ArrayList<MWDescriptor>();
                        MWInterfaceDescriptor interfaceDescriptor = (MWInterfaceDescriptor)InterfaceDescriptorPropertiesPage.this.selection();
                        Iterator stream = ((MWRelationalProject)interfaceDescriptor.getProject()).descriptorsThatImplement((MWRelationalDescriptor)interfaceDescriptor);
                        while (stream.hasNext()) {
                            MWDescriptor implementor = (MWDescriptor)stream.next();
                            if (implementor.getMWClass().isInterface() || CollectionTools.contains((Iterator)interfaceDescriptor.implementors(), (Object)implementor)) continue;
                            implementors.add(implementor);
                        }
                        return implementors.iterator();
                    }

                    @Override
                    public void refreshClassDescriptions() {
                    }
                };
                return repository;
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                MWInterfaceDescriptor interfaceDescriptor = (MWInterfaceDescriptor)InterfaceDescriptorPropertiesPage.this.selection();
                Iterator selectedValues = CollectionTools.iterator((Object[])listSelectionModel.getSelectedValues());
                while (selectedValues.hasNext()) {
                    interfaceDescriptor.removeImplementor((MWDescriptor)selectedValues.next());
                }
            }
        };
    }

    private ListValueModel buildImplementorsListValueModel() {
        return new CollectionListValueModelAdapter(this.buildImplementorsCollectionModel());
    }

    private CollectionValueModel buildImplementorsCollectionModel() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "implementors"){

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWInterfaceDescriptor)this.subject).implementors();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWInterfaceDescriptor)this.subject).implementorsSize();
            }
        };
    }

    private ListCellRenderer buildImplementorsListCellRenderer() {
        return new AdaptableListCellRenderer(new DescriptorCellRendererAdapter(this.resourceRepository()));
    }

    private ListModel buildQueryKeyListModel() {
        return new ListModelAdapter(this.buildQueryNamesCollectionModel());
    }

    private CollectionValueModel buildQueryNamesCollectionModel() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "implementors"){

            @Override
            protected CollectionChangeListener buildCollectionChangeListener() {
                return new CollectionChangeListener(){

                    public void itemsAdded(CollectionChangeEvent e) {
                        this.fireCollectionChanged("value");
                    }

                    public void itemsRemoved(CollectionChangeEvent e) {
                        this.fireCollectionChanged("value");
                    }

                    public void collectionChanged(CollectionChangeEvent e) {
                        this.fireCollectionChanged("value");
                    }
                };
            }

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWInterfaceDescriptor)this.subject).allQueryKeyNames();
            }
        };
    }

    public String helpTopicId() {
        return "descriptor.interface";
    }
}

