/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.factories.model.event.SessionEventManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.ConnectionPolicyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.PoolsConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.DatabaseSessionConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.ServerSessionConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPolicyAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DataSource;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.PoolsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ReadConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatform;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.WriteConnectionPoolAdapter;

public final class ServerSessionAdapter
extends DatabaseSessionAdapter {
    private volatile PoolsAdapter pools;
    public static final String POOLS_CONFIG_COLLECTION = "pools";
    private volatile ConnectionPolicyAdapter connectionPolicy;
    public static final String USE_EXCLUSIVE_CONNECTION_PROPERTY = "useExclusiveConnection";
    public static final String LAZY_CONNECTION_PROPERTY = "lazyConnection";
    public static final String READ_CONNECTION_POOL_PROPERTY = "readConnectionPool";
    public static final String WRITE_CONNECTION_POOL_PROPERTY = "writeConnectionPool";
    public static final String SEQUENCE_CONNECTION_POOL_PROPERTY = "sequenceConnectionPool";

    ServerSessionAdapter(SCAdapter parent, ServerSessionConfig scConfig) {
        super(parent, (DatabaseSessionConfig)scConfig);
        this.initializePoolsFromModel();
    }

    protected ServerSessionAdapter(SCAdapter parent, String name, ServerPlatform sp, DataSource ds) {
        super(parent, name, sp, ds);
        this.initializePools();
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        if (this.getPools() != null) {
            children.add(this.getPools());
        }
    }

    @Override
    protected Object buildModel() {
        ServerSessionConfig session = new ServerSessionConfig();
        session.setAdditionalProjects(new Vector());
        session.setSessionEventManagerConfig(new SessionEventManagerConfig());
        return session;
    }

    private PoolsAdapter buildPools() {
        PoolsAdapter pools = new PoolsAdapter(this);
        this.serverSession().setPoolsConfig((PoolsConfig)pools.getModel());
        return pools;
    }

    public ConnectionPoolAdapter addWriteConnectionPool() {
        WriteConnectionPoolAdapter writePool = this.pools.addWriteConnectionPool();
        this.fireItemAdded(POOLS_CONFIG_COLLECTION, writePool);
        this.firePropertyChanged(WRITE_CONNECTION_POOL_PROPERTY, null, writePool);
        return writePool;
    }

    public ConnectionPoolAdapter addReadConnectionPool() {
        ReadConnectionPoolAdapter readPool = this.pools.addReadConnectionPool();
        this.fireItemAdded(POOLS_CONFIG_COLLECTION, readPool);
        this.firePropertyChanged(READ_CONNECTION_POOL_PROPERTY, null, readPool);
        return readPool;
    }

    public ConnectionPoolAdapter addSequenceConnectionPool() {
        ConnectionPoolAdapter sequencePool = this.pools.addSequenceConnectionPool();
        this.fireItemAdded(POOLS_CONFIG_COLLECTION, sequencePool);
        this.firePropertyChanged(SEQUENCE_CONNECTION_POOL_PROPERTY, null, sequencePool);
        return sequencePool;
    }

    @Override
    public void setExternalConnectionPooling(boolean value) {
        super.setExternalConnectionPooling(value);
        if (value && this.pools.getReadConnectionPool() != null) {
            this.pools.getReadConnectionPool().setExclusive(false);
        }
    }

    protected void initializePoolsFromModel() {
        this.pools = this.getPoolConfigs() == null ? this.buildPools() : (PoolsAdapter)this.adapt(this.getPoolConfigs());
    }

    protected void initializePools() {
        this.pools = this.buildPools();
    }

    @Override
    protected void initialize(Object newConfig) {
        super.initialize(newConfig);
        this.connectionPolicy = this.buildConnectionPolicy();
    }

    @Override
    protected void initializeFromModel(Object scConfig) {
        super.initializeFromModel(scConfig);
        this.connectionPolicy = (ConnectionPolicyAdapter)this.adapt(this.getConnectionPolicyConfig());
        if (this.connectionPolicy == null) {
            this.connectionPolicy = this.buildConnectionPolicy();
        }
    }

    private final ServerSessionConfig serverSession() {
        return (ServerSessionConfig)this.getModel();
    }

    private PoolsConfig getPoolConfigs() {
        return this.serverSession().getPoolsConfig();
    }

    public Iterator pools() {
        return this.pools.pools();
    }

    public int poolsSize() {
        return this.pools.poolsSize();
    }

    private PoolsAdapter getPools() {
        return this.pools;
    }

    public Iterator<String> poolNames() {
        return this.getPools().getPoolNames().iterator();
    }

    public ReadConnectionPoolAdapter getReadConnectionPool() {
        return this.pools.getReadConnectionPool();
    }

    public ConnectionPoolAdapter getWriteConnectionPool() {
        return this.pools.getWriteConnectionPool();
    }

    public ConnectionPoolAdapter getSequenceConnectionPool() {
        return this.pools.getSequenceConnectionPool();
    }

    public boolean hasReadPool() {
        return this.pools.getReadConnectionPool() != null;
    }

    public boolean hasWritePool() {
        return this.pools.getWriteConnectionPool() != null;
    }

    public boolean hasAnyConnectionPool() {
        return this.hasReadPool() || this.hasWritePool() || this.hasSequencePool() || this.poolsSize() > 0;
    }

    @Override
    public boolean isServer() {
        return true;
    }

    public boolean hasSequencePool() {
        return this.pools.getSequenceConnectionPool() != null;
    }

    public ConnectionPoolAdapter poolNamed(String name) {
        return this.pools.poolNamed(name);
    }

    public ConnectionPoolAdapter addConnectionPoolNamed(String name) {
        ConnectionPoolAdapter namedPool = this.pools.addConnectionPoolNamed(name);
        this.fireItemAdded(POOLS_CONFIG_COLLECTION, namedPool);
        return namedPool;
    }

    public void removeConnectionPoolNamed(String name) {
        ConnectionPoolAdapter namedPool = this.pools.removeConnectionPoolNamed(name);
        if (namedPool != null) {
            this.fireItemRemoved(POOLS_CONFIG_COLLECTION, namedPool);
        }
    }

    public void removeWriteConnectionPool() {
        ConnectionPoolAdapter writePool = this.pools.removeWriteConnectionPool();
        if (writePool != null) {
            this.fireItemRemoved(POOLS_CONFIG_COLLECTION, writePool);
        }
    }

    public void removeReadConnectionPool() {
        ConnectionPoolAdapter readPool = this.pools.removeReadConnectionPool();
        if (readPool != null) {
            this.fireItemRemoved(POOLS_CONFIG_COLLECTION, readPool);
        }
    }

    public void removeAllConnectionPools() {
        this.removeReadConnectionPool();
        this.removeWriteConnectionPool();
        this.removeSequenceConnectionPool();
        Iterator<String> poolNamesIter = this.poolNames();
        while (poolNamesIter.hasNext()) {
            this.removeConnectionPoolNamed(poolNamesIter.next());
        }
    }

    public void removeSequenceConnectionPool() {
        ConnectionPoolAdapter sequencePool = this.pools.removeSequenceConnectionPool();
        if (sequencePool != null) {
            this.fireItemRemoved(POOLS_CONFIG_COLLECTION, sequencePool);
        }
    }

    private ConnectionPolicyAdapter buildConnectionPolicy() {
        ConnectionPolicyAdapter policy = new ConnectionPolicyAdapter(this);
        this.serverSession().setConnectionPolicyConfig((ConnectionPolicyConfig)policy.getModel());
        return policy;
    }

    private ConnectionPolicyConfig getConnectionPolicyConfig() {
        return this.serverSession().getConnectionPolicyConfig();
    }

    private ConnectionPolicyAdapter getConnectionPolicy() {
        return this.connectionPolicy;
    }

    public boolean usesExclusiveConnection() {
        return this.getConnectionPolicy().usesExclusiveConnection();
    }

    public void setUseExclusiveConnection(boolean value) {
        boolean old = this.getConnectionPolicy().usesExclusiveConnection();
        this.getConnectionPolicy().setUseExclusiveConnection(value);
        this.firePropertyChanged(USE_EXCLUSIVE_CONNECTION_PROPERTY, old, value);
    }

    public boolean usesLazyConnection() {
        return this.getConnectionPolicy().usesLazyConnection();
    }

    public void setLazyConnection(boolean value) {
        boolean old = this.getConnectionPolicy().usesLazyConnection();
        this.getConnectionPolicy().setLazyConnection(value);
        this.firePropertyChanged(LAZY_CONNECTION_PROPERTY, old, value);
    }
}

