/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWNominative;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorCreationFailureEvent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorCreationFailureListener;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.InterfaceDescriptorCreationException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWNullTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWAggregateDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWInterfaceDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWCompositeEisDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWOXDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWRootEisDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.DefaultMWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureEvent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class MWDescriptor
extends MWModel
implements MWNominative {
    private MWClassHandle mwClassHandle;
    public static final String MW_CLASS_PROPERTY = "mwClass";
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private volatile boolean active;
    public static final String ACTIVE_PROPERTY = "active";
    protected MWTransactionalPolicy transactionalPolicy;
    protected Map legacyValuesMap;

    protected MWDescriptor() {
    }

    protected MWDescriptor(MWProject parent, MWClass type, String name) {
        super(parent);
        this.initialize(type, name);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.legacyValuesMap = new HashMap();
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.mwClassHandle = new MWClassHandle(this, this.buildMWClassScrubber());
        this.active = true;
    }

    protected void initialize(MWClass mwClass, String descriptorName) {
        this.mwClassHandle.setType(mwClass);
        this.name = descriptorName;
        this.transactionalPolicy = this.buildDefaultTransactionalPolicy();
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.mwClassHandle);
        children.add(this.transactionalPolicy);
    }

    private MWHandle.NodeReferenceScrubber buildMWClassScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWDescriptor.this.setMWClass(null);
            }

            public String toString() {
                return "MWDescriptor.buildMWClassScrubber()";
            }
        };
    }

    protected MWTransactionalPolicy buildDefaultTransactionalPolicy() {
        return new MWNullTransactionalPolicy(this);
    }

    public MWTransactionalPolicy getTransactionalPolicy() {
        return this.transactionalPolicy;
    }

    public abstract void applyAdvancedPolicyDefaults(MWProjectDefaultsPolicy var1);

    public MWClass getMWClass() {
        return this.mwClassHandle.getType();
    }

    public void setMWClass(MWClass newValue) {
        if (newValue == null) {
            throw new NullPointerException();
        }
        MWClass oldValue = this.mwClassHandle.getType();
        this.mwClassHandle.setType(newValue);
        this.firePropertyChanged(MW_CLASS_PROPERTY, oldValue, newValue);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged(NAME_PROPERTY, old, name);
        if (this.attributeValueHasChanged(old, name)) {
            this.getProject().nodeRenamed(this);
        }
    }

    public boolean isRootDescriptor() {
        return false;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isInactive() {
        return !this.active;
    }

    public void setActive(boolean newValue) {
        boolean oldValue = this.active;
        this.active = newValue;
        this.firePropertyChanged(ACTIVE_PROPERTY, oldValue, newValue);
    }

    public boolean supportsCachingPolicy() {
        return false;
    }

    public String packageName() {
        return this.getMWClass().packageName();
    }

    public String shortName() {
        return this.getMWClass().shortName();
    }

    public Iterator mappings() {
        return NullIterator.instance();
    }

    public int inheritedAttributesSize() {
        return 0;
    }

    public int mappingsSize() {
        return 0;
    }

    public MWMapping mappingNamed(String mappingName) {
        return null;
    }

    public Iterator mappingsIncludingInherited() {
        return NullIterator.instance();
    }

    protected List getMappingsIncludingInherited() {
        return new Vector();
    }

    public Collection getAllQueryKeysIncludingInherited() {
        return new ArrayList();
    }

    public Collection getAutoGeneratedQueryKeysIncludingInherited() {
        return new ArrayList();
    }

    public Collection writableMappingsForField(MWDataField field) {
        return Collections.EMPTY_LIST;
    }

    void inheritanceChanged() {
        this.transactionalPolicy.descriptorInheritanceChanged();
    }

    public void unmap() {
    }

    public abstract boolean canHaveInheritance();

    public abstract MWInheritancePolicy getInheritancePolicy();

    public abstract boolean hasDefinedInheritance();

    public abstract boolean hasActiveInstantiationPolicy();

    public Iterator inheritanceHierarchy() {
        return this.getInheritancePolicy().descriptorLineage();
    }

    public boolean usesSequencingInDescriptorHierarchy() {
        return false;
    }

    public abstract void initializeOn(MWDescriptor var1);

    protected void initializeDescriptorAfterMorphing(MWDescriptor newDescriptor) {
        this.initializeOn(newDescriptor);
        newDescriptor.setChildBackpointers();
        this.getProject().replaceDescriptor(this, newDescriptor);
    }

    protected void initializeFromMWDescriptor(MWDescriptor oldDescriptor) {
        this.setActive(oldDescriptor.isActive());
        this.setName(oldDescriptor.getName());
    }

    protected void initializeFromMWMappingDescriptor(MWMappingDescriptor oldDescriptor) {
        this.initializeFromMWDescriptor(oldDescriptor);
    }

    public void refreshClass(ExternalClassLoadFailureContainer failures, DescriptorCreationFailureListener descCreationFailureListener) {
        this.refreshClass(failures, this.buildMWClassRefreshPolicy(), descCreationFailureListener);
    }

    public void refreshClass() throws ExternalClassNotFoundException, InterfaceDescriptorCreationException {
        this.refreshClass(this.buildMWClassRefreshPolicy());
    }

    protected MWClassRefreshPolicy buildMWClassRefreshPolicy() {
        return DefaultMWClassRefreshPolicy.instance();
    }

    protected void refreshClass(ExternalClassLoadFailureContainer failures, MWClassRefreshPolicy refreshPolicy, DescriptorCreationFailureListener descCreationFailureListener) {
        try {
            this.refreshClass(refreshPolicy);
        }
        catch (ExternalClassNotFoundException e) {
            failures.externalClassLoadFailure(new ExternalClassLoadFailureEvent(this, this.getName(), e));
        }
        catch (InterfaceDescriptorCreationException e) {
            descCreationFailureListener.descriptorCreationFailure(new DescriptorCreationFailureEvent(this, this.getName(), "DESCRIPTOR_REFRESH_ERROR_MESSAGE"));
        }
    }

    protected void refreshClass(MWClassRefreshPolicy refreshPolicy) throws ExternalClassNotFoundException, InterfaceDescriptorCreationException {
        this.getMWClass().refresh(refreshPolicy);
    }

    @Override
    public boolean validateBranchInternal() {
        return this.isActive() ? super.validateBranchInternal() : this.clearAllBranchProblemsInternal();
    }

    @Override
    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        this.checkForFinalSuperClass(currentProblems);
        this.checkForPublicClass(currentProblems);
        this.getMWClass().addDescriptorProblemsTo(currentProblems);
    }

    private void checkForPublicClass(List currentProblems) {
        if (!this.getMWClass().getModifier().isPublic()) {
            currentProblems.add(this.buildProblem("0200"));
        }
    }

    private void checkForFinalSuperClass(List currentProblems) {
        MWClass superclass = this.getMWClass().getSuperclass();
        if (superclass != null && superclass.getModifier().isFinal()) {
            currentProblems.add(this.buildProblem("0201"));
        }
    }

    public final void automapInheritanceHierarchy(Collection automapDescriptors) {
        if (this.isActive() && this.canHaveInheritance() && !this.hasDefinedInheritance()) {
            this.automapInheritanceHierarchyInternal(automapDescriptors);
        }
    }

    protected void automapInheritanceHierarchyInternal(Collection automapDescriptors) {
    }

    public final boolean autoMapRequiresMetaData() {
        return this.isActive() && this.autoMapRequiresMetaDataInternal();
    }

    protected boolean autoMapRequiresMetaDataInternal() {
        return false;
    }

    public final void automap() {
        if (this.isActive()) {
            this.automapInternal();
        }
    }

    protected void automapInternal() {
    }

    public ClassDescriptor buildRuntimeDescriptor() {
        ClassDescriptor runtimeDescriptor = this.buildBasicRuntimeDescriptor();
        this.transactionalPolicy.adjustRuntimeDescriptor(runtimeDescriptor);
        return runtimeDescriptor;
    }

    protected abstract ClassDescriptor buildBasicRuntimeDescriptor();

    @Override
    public String displayString() {
        return this.getMWClass().shortName();
    }

    public String displayStringWithPackage() {
        String packageName = this.packageName();
        if (StringTools.stringIsEmpty(packageName)) {
            packageName = "default package";
        }
        return this.getMWClass().shortName() + " (" + packageName + ")";
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append(this.getName());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWDescriptor.class);
        descriptor.setDefaultRootElement("descriptor");
        InheritancePolicy ip = descriptor.getInheritancePolicy();
        ip.setClassIndicatorFieldName("@type");
        ip.addClassIndicator(MWTableDescriptor.class, (Object)"relational");
        ip.addClassIndicator(MWAggregateDescriptor.class, (Object)"aggregate");
        ip.addClassIndicator(MWInterfaceDescriptor.class, (Object)"interface");
        ip.addClassIndicator(MWRootEisDescriptor.class, (Object)"eis-root");
        ip.addClassIndicator(MWCompositeEisDescriptor.class, (Object)"eis-composite");
        ip.addClassIndicator(MWOXDescriptor.class, (Object)"o-x");
        descriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        ((XMLDirectMapping)descriptor.addDirectMapping("comment", "comment/text()")).setNullValue((Object)"");
        ((XMLDirectMapping)descriptor.addDirectMapping(ACTIVE_PROPERTY, "active/text()")).setNullValue((Object)Boolean.TRUE);
        XMLCompositeObjectMapping mwClassHandleMapping = new XMLCompositeObjectMapping();
        mwClassHandleMapping.setAttributeName("mwClassHandle");
        mwClassHandleMapping.setGetMethodName("getMWClassHandleForTopLink");
        mwClassHandleMapping.setSetMethodName("setMWClassHandleForTopLink");
        mwClassHandleMapping.setReferenceClass(MWClassHandle.class);
        mwClassHandleMapping.setXPath("class-handle");
        descriptor.addMapping((DatabaseMapping)mwClassHandleMapping);
        XMLCompositeObjectMapping transactionalPolicyMapping = new XMLCompositeObjectMapping();
        transactionalPolicyMapping.setAttributeName("transactionalPolicy");
        transactionalPolicyMapping.setGetMethodName("getTransactionalPolicyForTopLink");
        transactionalPolicyMapping.setSetMethodName("setTransactionalPolicyForTopLink");
        transactionalPolicyMapping.setReferenceClass(MWAbstractTransactionalPolicy.class);
        transactionalPolicyMapping.setXPath("transactional-policy");
        descriptor.addMapping((DatabaseMapping)transactionalPolicyMapping);
        return descriptor;
    }

    private MWClassHandle getMWClassHandleForTopLink() {
        return this.mwClassHandle.getType() == null ? null : this.mwClassHandle;
    }

    private void setMWClassHandleForTopLink(MWClassHandle mwClassHandle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildMWClassScrubber();
        this.mwClassHandle = mwClassHandle == null ? new MWClassHandle(this, scrubber) : mwClassHandle.setScrubber(scrubber);
    }

    private MWAbstractTransactionalPolicy getTransactionalPolicyForTopLink() {
        return this.transactionalPolicy.getValueForTopLink();
    }

    private void setTransactionalPolicyForTopLink(MWAbstractTransactionalPolicy transactionalPolicy) {
        this.transactionalPolicy = transactionalPolicy == null ? new MWNullTransactionalPolicy(this) : transactionalPolicy;
    }
}

