/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.handles;

import java.util.StringTokenizer;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWMethodHandle
extends MWHandle {
    private volatile MWMethod method;
    private volatile String methodDeclaringTypeName;
    private volatile String methodSignature;

    private MWMethodHandle() {
    }

    public MWMethodHandle(MWModel parent, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
    }

    public MWMethodHandle(MWModel parent, MWMethod method, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
        this.method = method;
    }

    public MWMethod getMethod() {
        return this.method;
    }

    public void setMethod(MWMethod method) {
        this.method = method;
    }

    @Override
    protected Node node() {
        return this.getMethod();
    }

    public MWMethodHandle setScrubber(MWHandle.NodeReferenceScrubber scrubber) {
        this.setScrubberInternal(scrubber);
        return this;
    }

    @Override
    public void resolveMethodHandles() {
        super.resolveMethodHandles();
        if (this.methodDeclaringTypeName != null && this.methodSignature != null) {
            this.method = this.typeNamed(this.methodDeclaringTypeName).methodWithSignature(this.methodSignature);
        }
        this.methodDeclaringTypeName = null;
        this.methodSignature = null;
    }

    private String removeArrayTypesFromSignature(String methodSignature) {
        if (methodSignature == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(methodSignature.substring(0, methodSignature.indexOf(40) + 1));
        String parameters = methodSignature.substring(methodSignature.indexOf(40) + 1, methodSignature.length() - 1);
        StringTokenizer tokenizer = new StringTokenizer(parameters, ",");
        while (tokenizer.hasMoreTokens()) {
            String parameterType = tokenizer.nextToken();
            buffer.append(ClassTools.elementTypeNameForClassNamed(parameterType));
            int arrayDepth = ClassTools.arrayDepthForClassNamed(parameterType);
            for (int i = 0; i < arrayDepth; ++i) {
                buffer.append("[]");
            }
            if (!tokenizer.hasMoreTokens()) continue;
            buffer.append(",");
        }
        buffer.append(")");
        return buffer.toString();
    }

    public int compareTo(Object o) {
        return this.method.compareTo(((MWMethodHandle)o).method);
    }

    @Override
    public void toString(StringBuffer sb) {
        if (this.method == null) {
            sb.append("null");
        } else {
            this.method.toString(sb);
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWMethodHandle.class);
        descriptor.addDirectMapping("methodDeclaringTypeName", "getMethodDeclaringTypeNameForTopLink", "setMethodDeclaringTypeNameForTopLink", "method-declaring-type-name/text()");
        descriptor.addDirectMapping("methodSignature", "getMethodSignatureForTopLink", "setMethodSignatureForTopLink", "method-signature/text()");
        return descriptor;
    }

    public static XMLDescriptor legacy60BuildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWMethodHandle.class);
        descriptor.addDirectMapping("methodDeclaringTypeName", "getMethodDeclaringTypeNameForTopLink", "setMethodDeclaringTypeNameForTopLink", "method-declaring-type-name/text()");
        descriptor.addDirectMapping("methodSignature", "getMethodSignatureForTopLink", "legacySetMethodSignatureForTopLink", "method-signature/text()");
        return descriptor;
    }

    private String getMethodDeclaringTypeNameForTopLink() {
        return this.method == null ? null : this.method.getDeclaringType().getName();
    }

    private void setMethodDeclaringTypeNameForTopLink(String methodDeclaringTypeName) {
        this.methodDeclaringTypeName = methodDeclaringTypeName;
    }

    private String getMethodSignatureForTopLink() {
        return this.method == null ? null : this.method.signature();
    }

    private void setMethodSignatureForTopLink(String methodSignature) {
        this.methodSignature = methodSignature;
    }

    private void legacySetMethodSignatureForTopLink(String legacyMethodSignature) {
        this.methodSignature = this.removeArrayTypesFromSignature(MWModel.legacyReplaceToplinkDepracatedClassReferencesFromSignature(legacyMethodSignature));
    }
}

