/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWXmlDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWDescriptorHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWNamedSchemaComponentHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWReferenceObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWAttributeContainerAccessor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWContainerAccessor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWMethodContainerAccessor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWNullContainerAccessor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlElementTypeableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXpathedMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWAbstractCompositeMapping
extends MWMapping
implements MWReferenceObjectMapping,
MWXmlMapping,
MWXpathedMapping,
MWXpathContext,
MWXmlElementTypeableMapping {
    private MWDescriptorHandle referenceDescriptorHandle;
    public static final String REFERENCE_DESCRIPTOR_PROPERTY = "referenceDescriptor";
    private MWXmlField xmlField;
    private MWNamedSchemaComponentHandle elementTypeHandle;
    public static final String ELEMENT_TYPE_PROPERTY = "elementType";
    private MWContainerAccessor containerAccessor;
    public static final String CONTAINER_ACCESSOR_PROPERTY = "containerAccessor";
    private Boolean usesContainerAccessor;
    public static final String USES_CONTAINER_ACCESSOR_PROPERTY = "usesContainerAccessor";

    protected MWAbstractCompositeMapping() {
    }

    protected MWAbstractCompositeMapping(MWXmlDescriptor descriptor, MWClassAttribute attribute, String name) {
        super(descriptor, attribute, name);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.referenceDescriptorHandle = new MWDescriptorHandle(this, this.buildReferenceDescriptorScrubber());
        this.xmlField = new MWXmlField(this);
        this.elementTypeHandle = new MWNamedSchemaComponentHandle(this, this.buildElementTypeScrubber());
        this.containerAccessor = new MWNullContainerAccessor(this);
        this.usesContainerAccessor = new Boolean(false);
    }

    private MWHandle.NodeReferenceScrubber buildElementTypeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWAbstractCompositeMapping.this.setElementType(null);
            }

            public String toString() {
                return "MWAbstractCompositeMapping.buildElementTypeScrubber()";
            }
        };
    }

    @Override
    public MWDescriptor getReferenceDescriptor() {
        return this.referenceDescriptorHandle.getDescriptor();
    }

    @Override
    public void setReferenceDescriptor(MWDescriptor newReferenceDescriptor) {
        MWDescriptor oldReferenceDescriptor = this.referenceDescriptorHandle.getDescriptor();
        this.referenceDescriptorHandle.setDescriptor(newReferenceDescriptor);
        this.firePropertyChanged(REFERENCE_DESCRIPTOR_PROPERTY, oldReferenceDescriptor, newReferenceDescriptor);
    }

    @Override
    public boolean descriptorIsValidReferenceDescriptor(MWDescriptor descriptor) {
        return true;
    }

    @Override
    public MWComplexTypeDefinition getElementType() {
        return (MWComplexTypeDefinition)this.elementTypeHandle.getComponent();
    }

    @Override
    public void setElementType(MWComplexTypeDefinition newElementType) {
        MWComplexTypeDefinition oldElementType = this.getElementType();
        this.elementTypeHandle.setComponent(newElementType);
        this.firePropertyChanged(ELEMENT_TYPE_PROPERTY, oldElementType, newElementType);
    }

    public Boolean usesContainerAccessor() {
        return this.usesContainerAccessor;
    }

    public void setUsesContainerAccessor(Boolean use) {
        boolean oldValue = this.usesContainerAccessor();
        this.usesContainerAccessor = use;
        this.firePropertyChanged(USES_CONTAINER_ACCESSOR_PROPERTY, oldValue, use);
    }

    public MWContainerAccessor getContainerAccessor() {
        return this.containerAccessor;
    }

    public void setContainerAccessor(MWContainerAccessor newAccessor) {
        MWContainerAccessor oldValue = this.getContainerAccessor();
        this.containerAccessor = newAccessor;
        this.firePropertyChanged(CONTAINER_ACCESSOR_PROPERTY, oldValue, newAccessor);
    }

    public void setContainerAccessorGetMethod(MWMethod getMethod) {
        if (this.getContainerAccessor().isNull() || this.getContainerAccessor().isAttribute()) {
            this.setContainerAccessor(new MWMethodContainerAccessor(this, getMethod, null));
        } else {
            ((MWMethodContainerAccessor)this.getContainerAccessor()).setAccessorGetMethod(getMethod);
        }
    }

    public void setContainerAccessorSetMethod(MWMethod setMethod) {
        if (this.getContainerAccessor().isNull() || this.getContainerAccessor().isAttribute()) {
            this.setContainerAccessor(new MWMethodContainerAccessor(this, null, setMethod));
        } else {
            ((MWMethodContainerAccessor)this.getContainerAccessor()).setAccessorSetMethod(setMethod);
        }
    }

    public void setContainerAccessorAttribute(MWClassAttribute attribute) {
        this.setContainerAccessor(new MWAttributeContainerAccessor(this, attribute));
    }

    public Iterator candidateAccessorMethods() {
        if (this.getReferenceDescriptor() != null) {
            return this.getReferenceDescriptor().getMWClass().allInstanceMethods();
        }
        return NullIterator.instance();
    }

    public Iterator candidateAccessorAttributes() {
        if (this.getReferenceDescriptor() != null) {
            return this.getReferenceDescriptor().getMWClass().allInstanceVariables();
        }
        return NullIterator.instance();
    }

    @Override
    public MWXmlField getXmlField() {
        return this.xmlField;
    }

    @Override
    public MWSchemaContextComponent schemaContext() {
        return this.xmlDescriptor().getSchemaContext();
    }

    @Override
    public MWXmlField firstMappedXmlField() {
        return this.getXmlField().isResolved() ? this.getXmlField() : null;
    }

    @Override
    public void addWrittenFieldsTo(Collection writtenFields) {
        if (!this.isReadOnly() && !this.getXmlField().getXpath().equals("")) {
            writtenFields.add(this.getXmlField());
        }
    }

    @Override
    public MWSchemaContextComponent schemaContext(MWXmlField xmlField) {
        return this.xmlDescriptor().getSchemaContext();
    }

    @Override
    public MWXpathSpec xpathSpec(MWXmlField xmlField) {
        return this.buildXpathSpec();
    }

    protected MWXpathSpec buildXpathSpec() {
        return new MWXpathSpec(){

            @Override
            public boolean mayUseCollectionData() {
                return MWAbstractCompositeMapping.this.mayUseCollectionData();
            }

            @Override
            public boolean mayUseComplexData() {
                return true;
            }

            @Override
            public boolean mayUseSimpleData() {
                return false;
            }
        };
    }

    protected abstract boolean mayUseCollectionData();

    protected MWXmlDescriptor xmlDescriptor() {
        return (MWXmlDescriptor)this.getParent();
    }

    @Override
    protected void initializeFromMWXpathedMapping(MWXpathedMapping oldMapping) {
        super.initializeFromMWXpathedMapping(oldMapping);
        this.getXmlField().setXpath(oldMapping.getXmlField().getXpath());
    }

    @Override
    protected void initializeFromMWReferenceObjectMapping(MWReferenceObjectMapping oldMapping) {
        super.initializeFromMWReferenceObjectMapping(oldMapping);
        this.setReferenceDescriptor(oldMapping.getReferenceDescriptor());
    }

    @Override
    protected void addProblemsTo(List newProblems) {
        this.addXmlFieldProblemsTo(newProblems);
        this.addReferenceDescriptorNotSpecifiedProblemTo(newProblems);
        this.addReferenceDescriptorInactiveProblemTo(newProblems);
        this.addContainerAccessorNotSpecifiedProblemTo(newProblems);
        super.addProblemsTo(newProblems);
    }

    protected void addContainerAccessorNotSpecifiedProblemTo(List newProblems) {
        if (this.usesContainerAccessor().booleanValue() && this.containerAccessor.isNull()) {
            newProblems.add(this.buildProblem("0630"));
        }
    }

    protected void addXmlFieldProblemsTo(List newProblems) {
        this.addXpathNotSpecifiedProblemTo(newProblems);
    }

    private void addXpathNotSpecifiedProblemTo(List newProblems) {
        if (!this.getXmlField().isSpecified()) {
            newProblems.add(this.buildProblem("0810"));
        }
    }

    private void addReferenceDescriptorNotSpecifiedProblemTo(List newProblems) {
        if (this.xmlDescriptor().isEisDescriptor() && this.getReferenceDescriptor() == null) {
            newProblems.add(this.buildProblem("0450"));
        }
    }

    private void addReferenceDescriptorInactiveProblemTo(List newProblems) {
        if (this.getReferenceDescriptor() != null && !this.getReferenceDescriptor().isActive()) {
            newProblems.add(this.buildProblem("0451", this.getInstanceVariable().getName(), this.getReferenceDescriptor().getMWClass().shortName()));
        }
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.referenceDescriptorHandle);
        children.add(this.xmlField);
        children.add(this.elementTypeHandle);
        children.add(this.containerAccessor);
    }

    private MWHandle.NodeReferenceScrubber buildReferenceDescriptorScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWAbstractCompositeMapping.this.setReferenceDescriptor(null);
            }

            public String toString() {
                return "MWAbstractCompositeMapping.buildReferenceDescriptorScrubber()";
            }
        };
    }

    @Override
    public void descriptorReplaced(MWDescriptor oldDescriptor, MWDescriptor newDescriptor) {
        super.descriptorReplaced(oldDescriptor, newDescriptor);
    }

    @Override
    public void resolveXpaths() {
        this.xmlField.resolveXpaths();
    }

    @Override
    public void schemaChanged(SchemaChange change) {
        this.xmlField.schemaChanged(change);
    }

    @Override
    public DatabaseMapping runtimeMapping() {
        AggregateMapping runtimeMapping = (AggregateMapping)super.runtimeMapping();
        if (this.getReferenceDescriptor() != null) {
            runtimeMapping.setReferenceClassName(this.getReferenceDescriptor().getMWClass().getName());
        }
        if (this.getElementType() != null && runtimeMapping.getField() != null) {
            ((XMLField)runtimeMapping.getField()).setLeafElementType(new QName(this.getElementType().qName()));
        }
        return runtimeMapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWAbstractCompositeMapping.class);
        descriptor.descriptorIsAggregate();
        descriptor.getInheritancePolicy().setParentClass(MWMapping.class);
        descriptor.addDirectMapping(USES_CONTAINER_ACCESSOR_PROPERTY, "getUsesContainerAccessorForTopLink", "setUsesContainerAccessorForTopLink", "uses-container-accessor");
        XMLCompositeObjectMapping referenceDescriptorMapping = new XMLCompositeObjectMapping();
        referenceDescriptorMapping.setAttributeName("referenceDescriptorHandle");
        referenceDescriptorMapping.setGetMethodName("getReferenceDescriptorHandleForTopLink");
        referenceDescriptorMapping.setSetMethodName("setReferenceDescriptorHandleForTopLink");
        referenceDescriptorMapping.setXPath("reference-descriptor-handle");
        referenceDescriptorMapping.setReferenceClass(MWDescriptorHandle.class);
        descriptor.addMapping((DatabaseMapping)referenceDescriptorMapping);
        XMLCompositeObjectMapping xmlFieldMapping = new XMLCompositeObjectMapping();
        xmlFieldMapping.setReferenceClass(MWXmlField.class);
        xmlFieldMapping.setAttributeName("xmlField");
        xmlFieldMapping.setGetMethodName("getXmlFieldForTopLink");
        xmlFieldMapping.setSetMethodName("setXmlFieldForTopLink");
        xmlFieldMapping.setXPath("xpath");
        descriptor.addMapping((DatabaseMapping)xmlFieldMapping);
        XMLCompositeObjectMapping elementTypeHandleMapping = new XMLCompositeObjectMapping();
        elementTypeHandleMapping.setAttributeName("elementTypeHandle");
        elementTypeHandleMapping.setGetMethodName("getElementTypeHandleForTopLink");
        elementTypeHandleMapping.setSetMethodName("setElementTypeHandleForTopLink");
        elementTypeHandleMapping.setReferenceClass(MWNamedSchemaComponentHandle.class);
        elementTypeHandleMapping.setXPath("element-type-handle");
        descriptor.addMapping((DatabaseMapping)elementTypeHandleMapping);
        XMLCompositeObjectMapping containerAccessorMapping = new XMLCompositeObjectMapping();
        containerAccessorMapping.setAttributeName(CONTAINER_ACCESSOR_PROPERTY);
        containerAccessorMapping.setGetMethodName("getContainerAccessorForTopLink");
        containerAccessorMapping.setSetMethodName("setContainerAccessorForTopLink");
        containerAccessorMapping.setReferenceClass(MWContainerAccessor.class);
        containerAccessorMapping.setXPath("container-accessor");
        descriptor.addMapping((DatabaseMapping)containerAccessorMapping);
        return descriptor;
    }

    public static XMLDescriptor legacy60BuildDescriptor() {
        XMLDescriptor descriptor = MWModel.legacy60BuildStandardDescriptor();
        descriptor.setJavaClass(MWAbstractCompositeMapping.class);
        descriptor.descriptorIsAggregate();
        descriptor.getInheritancePolicy().setParentClass(MWMapping.class);
        XMLCompositeObjectMapping referenceDescriptorMapping = new XMLCompositeObjectMapping();
        referenceDescriptorMapping.setAttributeName("referenceDescriptorHandle");
        referenceDescriptorMapping.setGetMethodName("getReferenceDescriptorHandleForTopLink");
        referenceDescriptorMapping.setSetMethodName("setReferenceDescriptorHandleForTopLink");
        referenceDescriptorMapping.setXPath("reference-descriptor-handle");
        referenceDescriptorMapping.setReferenceClass(MWDescriptorHandle.class);
        descriptor.addMapping((DatabaseMapping)referenceDescriptorMapping);
        XMLCompositeObjectMapping xmlFieldMapping = new XMLCompositeObjectMapping();
        xmlFieldMapping.setReferenceClass(MWXmlField.class);
        xmlFieldMapping.setAttributeName("xmlField");
        xmlFieldMapping.setGetMethodName("getXmlFieldForTopLink");
        xmlFieldMapping.setSetMethodName("setXmlFieldForTopLink");
        xmlFieldMapping.setXPath("xpath");
        descriptor.addMapping((DatabaseMapping)xmlFieldMapping);
        XMLCompositeObjectMapping elementTypeHandleMapping = new XMLCompositeObjectMapping();
        elementTypeHandleMapping.setAttributeName("elementTypeHandle");
        elementTypeHandleMapping.setGetMethodName("getElementTypeHandleForTopLink");
        elementTypeHandleMapping.setSetMethodName("setElementTypeHandleForTopLink");
        elementTypeHandleMapping.setReferenceClass(MWNamedSchemaComponentHandle.class);
        elementTypeHandleMapping.setXPath("element-type-handle");
        descriptor.addMapping((DatabaseMapping)elementTypeHandleMapping);
        return descriptor;
    }

    private Boolean getUsesContainerAccessorForTopLink() {
        return this.usesContainerAccessor;
    }

    private void setUsesContainerAccessorForTopLink(Boolean value) {
        this.usesContainerAccessor = value == null ? Boolean.FALSE : value;
    }

    private MWContainerAccessor getContainerAccessorForTopLink() {
        return this.containerAccessor.valueForTopLink();
    }

    private void setContainerAccessorForTopLink(MWContainerAccessor newAccessor) {
        this.containerAccessor = MWContainerAccessor.buildAccessorForTopLink(newAccessor);
    }

    private MWDescriptorHandle getReferenceDescriptorHandleForTopLink() {
        return this.referenceDescriptorHandle.getDescriptor() == null ? null : this.referenceDescriptorHandle;
    }

    private void setReferenceDescriptorHandleForTopLink(MWDescriptorHandle referenceDescriptorHandle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildReferenceDescriptorScrubber();
        this.referenceDescriptorHandle = referenceDescriptorHandle == null ? new MWDescriptorHandle(this, scrubber) : referenceDescriptorHandle.setScrubber(scrubber);
    }

    private MWXmlField getXmlFieldForTopLink() {
        return this.xmlField.isSpecified() ? this.xmlField : null;
    }

    private void setXmlFieldForTopLink(MWXmlField xmlField) {
        this.xmlField = xmlField == null ? new MWXmlField(this) : xmlField;
    }

    private MWNamedSchemaComponentHandle getElementTypeHandleForTopLink() {
        return this.elementTypeHandle.getComponent() == null ? null : this.elementTypeHandle;
    }

    private void setElementTypeHandleForTopLink(MWNamedSchemaComponentHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildElementTypeScrubber();
        this.elementTypeHandle = handle == null ? new MWNamedSchemaComponentHandle(this, scrubber) : handle.setScrubber(scrubber);
    }
}

