/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.meta;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.internal.codegen.NonreflectiveMethodDefinition;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWAttributeHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethodCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethodParameter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWModifiable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWModifier;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalConstructor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalMethod;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWMethod
extends MWModel
implements MWModifiable {
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private MWModifier modifier;
    public static final String SIGNATURE_PROPERTY = "signature";
    private MWTypeDeclaration returnTypeDeclaration;
    public static final String RETURN_TYPE_PROPERTY = "returnType";
    public static final String RETURN_TYPE_DIMENSIONALITY_PROPERTY = "returnTypeDimensionality";
    private List methodParameters;
    public static final String METHOD_PARAMETERS_LIST = "methodParameters";
    private Collection exceptionTypeHandles;
    public static final String EXCEPTION_TYPES_COLLECTION = "exceptionTypes";
    private MWHandle.NodeReferenceScrubber exceptionTypeScrubber;
    private volatile boolean constructor;
    public static final String CONSTRUCTOR_PROPERTY = "constructor";
    private MWAttributeHandle accessedAttributeHandle;
    private static final MWClass[] EMPTY_TYPE_ARRAY = new MWClass[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final int ALLOWED_MODIFIERS_FLAGS = 3386;

    private MWMethod() {
    }

    MWMethod(MWClass declaringType, String name) {
        super(declaringType);
        this.name = name;
        this.setConstructor(name.equals(this.getDeclaringType().shortName()));
    }

    MWMethod(MWClass declaringType, String name, MWClass returnType) {
        this(declaringType, name);
        this.setReturnType(returnType);
    }

    MWMethod(MWClass declaringType, String name, MWClass returnType, int dimensionality) {
        this(declaringType, name);
        this.setReturnTypeDeclaration(returnType, dimensionality);
    }

    MWMethod(MWClass declaringType, ExternalConstructor externalConstructor) {
        this(declaringType, MWMethod.shortNameFor(externalConstructor));
        this.setConstructor(true);
        this.initializeParameterTypeDeclarations(externalConstructor.getParameterTypes());
        this.refresh(externalConstructor);
    }

    MWMethod(MWClass declaringType, ExternalMethod externalMethod) {
        this(declaringType, externalMethod.getName());
        this.setConstructor(false);
        this.initializeParameterTypeDeclarations(externalMethod.getParameterTypes());
        this.refresh(externalMethod);
    }

    private static String shortNameFor(ExternalConstructor externalConstructor) {
        return ClassTools.shortNameForClassNamed(externalConstructor.getName());
    }

    static MWMethod buildZeroArgumentConstructor(MWClass declaringType) {
        MWMethod ctor = new MWMethod(declaringType, declaringType.shortName());
        ctor.setConstructor(true);
        return ctor;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.modifier = new MWModifier(this);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.returnTypeDeclaration = this.buildDefaultReturnTypeDeclaration();
        this.methodParameters = new Vector();
        this.exceptionTypeHandles = new Vector();
        this.accessedAttributeHandle = new MWAttributeHandle(this, this.buildAccessedAttributeScrubber());
    }

    private void initializeParameterTypeDeclarations(ExternalClassDescription[] externalParameters) {
        int len = externalParameters.length;
        for (int i = 0; i < len; ++i) {
            this.methodParameters.add(this.buildMethodParameter(externalParameters[i]));
        }
    }

    public MWClass getDeclaringType() {
        return (MWClass)this.getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged(NAME_PROPERTY, old, name);
        if (this.attributeValueHasChanged(old, name)) {
            this.setConstructor(name.equals(this.getDeclaringType().shortName()));
            this.getProject().nodeRenamed(this);
            this.firePropertyChanged(SIGNATURE_PROPERTY, NAME_PROPERTY);
        }
    }

    @Override
    public MWModifier getModifier() {
        return this.modifier;
    }

    MWTypeDeclaration getReturnTypeDeclaration() {
        return this.returnTypeDeclaration;
    }

    public MWClass getReturnType() {
        if (this.isConstructor()) {
            throw new IllegalStateException("A constructor \"" + this + "\" does not have a return type.");
        }
        return this.returnTypeDeclaration.getType();
    }

    public int getReturnTypeDimensionality() {
        if (this.isConstructor()) {
            throw new IllegalStateException("A constructor \"" + this + "\" does not have a return type.");
        }
        return this.returnTypeDeclaration.getDimensionality();
    }

    private void setReturnTypeDeclaration(MWTypeDeclaration returnTypeDeclaration) {
        this.returnTypeDeclaration = returnTypeDeclaration;
    }

    public void setReturnType(MWClass returnType) {
        MWClass old = this.getReturnType();
        this.returnTypeDeclaration.setType(returnType);
        this.firePropertyChanged(RETURN_TYPE_PROPERTY, old, returnType);
        if (this.attributeValueHasChanged(old, returnType)) {
            if (returnType.isVoid()) {
                this.setReturnTypeDimensionality(0);
            }
            this.firePropertyChanged(SIGNATURE_PROPERTY, RETURN_TYPE_PROPERTY);
        }
    }

    private void setReturnTypeDeclaration(MWClass returnType, int dimensionality) {
        this.setReturnType(returnType);
        this.setReturnTypeDimensionality(dimensionality);
    }

    public void setReturnTypeDimensionality(int dimensionality) {
        int old = this.getReturnTypeDimensionality();
        this.returnTypeDeclaration.setDimensionality(dimensionality);
        this.firePropertyChanged(RETURN_TYPE_DIMENSIONALITY_PROPERTY, old, dimensionality);
        if (old != dimensionality) {
            this.firePropertyChanged(SIGNATURE_PROPERTY, RETURN_TYPE_DIMENSIONALITY_PROPERTY);
        }
    }

    public ListIterator methodParameters() {
        return new CloneListIterator(this.methodParameters){

            @Override
            protected void remove(int index) {
                MWMethod.this.removeMethodParameter(index);
            }

            @Override
            public String toString() {
                return "MWMethod.methodParameters()";
            }
        };
    }

    public int methodParametersSize() {
        return this.methodParameters.size();
    }

    public MWMethodParameter getMethodParameter(int index) {
        return (MWMethodParameter)this.methodParameters.get(index);
    }

    public MWMethodParameter getMethodParameter() {
        if (this.methodParametersSize() != 1) {
            throw new IllegalStateException("This method \"" + this + "\" contains more than one parameter type declaration.");
        }
        return this.getMethodParameter(0);
    }

    public MWMethodParameter addMethodParameter(MWClass parameterType) {
        return this.addMethodParameter(parameterType, 0);
    }

    public MWMethodParameter addMethodParameter(MWClass parameterType, int parameterDimensionality) {
        return this.addMethodParameter(this.buildMethodParameter(parameterType, parameterDimensionality));
    }

    private MWMethodParameter addMethodParameter(MWMethodParameter methodParameter) {
        if (methodParameter.getType().isVoid()) {
            throw new IllegalArgumentException("Cannot add a parameter with type void");
        }
        this.addItemToList(methodParameter, this.methodParameters, METHOD_PARAMETERS_LIST);
        this.parameterChanged();
        return methodParameter;
    }

    public void removeMethodParameter(int index) {
        this.removeMethodParameter(this.getMethodParameter(index));
    }

    public void removeMethodParameter(MWMethodParameter methodParameter) {
        this.removeItemFromList(methodParameter, this.methodParameters, METHOD_PARAMETERS_LIST);
        this.parameterChanged();
    }

    public void removeMethodParameters(Iterator params) {
        while (params.hasNext()) {
            this.removeMethodParameter((MWMethodParameter)params.next());
        }
    }

    public void removeMethodParameters(Collection params) {
        this.removeMethodParameters(params.iterator());
    }

    public void clearMethodParameters() {
        this.removeMethodParameters(this.methodParameters());
    }

    void parameterChanged() {
        this.getProject().nodeRenamed(this);
        this.firePropertyChanged(SIGNATURE_PROPERTY, METHOD_PARAMETERS_LIST);
    }

    private Iterator exceptionTypeHandles() {
        return new CloneIterator(this.exceptionTypeHandles){

            @Override
            protected void remove(Object current) {
                MWMethod.this.removeExceptionTypeHandle((MWClassHandle)current);
            }

            @Override
            public String toString() {
                return "MWMethod.exceptionTypeHandles()";
            }
        };
    }

    void removeExceptionTypeHandle(MWClassHandle handle) {
        this.exceptionTypeHandles.remove(handle);
        this.fireItemRemoved(EXCEPTION_TYPES_COLLECTION, handle.getType());
    }

    public Iterator exceptionTypes() {
        return new TransformationIterator(this.exceptionTypeHandles()){

            @Override
            protected Object transform(Object next) {
                return ((MWClassHandle)next).getType();
            }

            @Override
            public String toString() {
                return "MWMethod.exceptionTypes()";
            }
        };
    }

    public int exceptionTypesSize() {
        return this.exceptionTypeHandles.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsExceptionType(MWClass exceptionType) {
        Collection collection = this.exceptionTypeHandles;
        synchronized (collection) {
            Iterator stream = this.exceptionTypeHandles.iterator();
            while (stream.hasNext()) {
                if (((MWClassHandle)stream.next()).getType() != exceptionType) continue;
                return true;
            }
            return false;
        }
    }

    public void addExceptionType(MWClass exceptionType) {
        if (!this.containsExceptionType(exceptionType)) {
            this.exceptionTypeHandles.add(new MWClassHandle(this, exceptionType, this.exceptionTypeScrubber()));
            this.fireItemAdded(EXCEPTION_TYPES_COLLECTION, exceptionType);
        }
    }

    public void addExceptionTypes(Collection exceptionTypes) {
        this.addExceptionTypes(exceptionTypes.iterator());
    }

    public void addExceptionTypes(Iterator exceptionTypes) {
        while (exceptionTypes.hasNext()) {
            this.addExceptionType((MWClass)exceptionTypes.next());
        }
    }

    public void removeExceptionType(MWClass exceptionType) {
        Iterator stream = this.exceptionTypes();
        while (stream.hasNext()) {
            if (stream.next() != exceptionType) continue;
            stream.remove();
            return;
        }
        throw new IllegalArgumentException(exceptionType.toString());
    }

    public void removeExceptionTypes(Collection exceptionTypes) {
        this.removeExceptionTypes(exceptionTypes.iterator());
    }

    public void removeExceptionTypes(Iterator exceptionTypes) {
        while (exceptionTypes.hasNext()) {
            this.removeExceptionType((MWClass)exceptionTypes.next());
        }
    }

    public void clearExceptionTypes() {
        Iterator stream = this.exceptionTypeHandles();
        while (stream.hasNext()) {
            stream.next();
            stream.remove();
        }
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    public void setConstructor(boolean constructor) {
        boolean old = this.constructor;
        this.constructor = constructor;
        this.firePropertyChanged(CONSTRUCTOR_PROPERTY, old, constructor);
        if (old != constructor) {
            if (constructor) {
                this.setReturnTypeDeclaration(null);
                this.getModifier().setAbstract(false);
                this.getModifier().setFinal(false);
                this.getModifier().setSynchronized(false);
                this.getModifier().setStatic(false);
                this.getModifier().setNative(false);
            } else {
                this.setReturnTypeDeclaration(this.buildDefaultReturnTypeDeclaration());
            }
            this.allowedModifiersChanged();
            this.firePropertyChanged(SIGNATURE_PROPERTY, CONSTRUCTOR_PROPERTY);
        }
    }

    MWClassAttribute getAccessedAttribute() {
        return this.accessedAttributeHandle.getAttribute();
    }

    void setAccessedAttribute(MWClassAttribute attribute) {
        if (this.getAccessedAttribute() != null) {
            this.getAccessedAttribute().removeAccessorMethod(this);
        }
        this.accessedAttributeHandle.setAttribute(attribute);
    }

    @Override
    public boolean supportsAbstract() {
        return true;
    }

    @Override
    public boolean canBeSetAbstract() {
        if (this.isConstructor()) {
            return false;
        }
        if (this.getModifier().isPrivate()) {
            return false;
        }
        if (this.getModifier().isStatic()) {
            return false;
        }
        if (this.isFinal()) {
            return false;
        }
        if (this.getModifier().isNative()) {
            return false;
        }
        if (this.isStrict()) {
            return false;
        }
        if (this.getModifier().isSynchronized()) {
            return false;
        }
        return this.getDeclaringType().isAbstract();
    }

    @Override
    public boolean canBeSetFinal() {
        if (this.isConstructor()) {
            return false;
        }
        return !this.isAbstract();
    }

    @Override
    public boolean supportsInterface() {
        return false;
    }

    @Override
    public boolean canBeSetInterface() {
        return false;
    }

    @Override
    public boolean supportsNative() {
        return true;
    }

    @Override
    public boolean canBeSetNative() {
        if (this.isConstructor()) {
            return false;
        }
        if (this.isAbstract()) {
            return false;
        }
        return !this.isStrict();
    }

    @Override
    public boolean canBeSetPackage() {
        return true;
    }

    @Override
    public boolean canBeSetPrivate() {
        return !this.isAbstract();
    }

    @Override
    public boolean canBeSetProtected() {
        return true;
    }

    @Override
    public boolean canBeSetPublic() {
        return true;
    }

    @Override
    public boolean canBeSetStatic() {
        if (this.isConstructor()) {
            return false;
        }
        return !this.isAbstract();
    }

    @Override
    public boolean supportsStrict() {
        return true;
    }

    @Override
    public boolean canBeSetStrict() {
        if (this.isConstructor()) {
            return false;
        }
        if (this.isAbstract()) {
            return false;
        }
        return !this.getModifier().isNative();
    }

    @Override
    public boolean supportsSynchronized() {
        return true;
    }

    @Override
    public boolean canBeSetSynchronized() {
        if (this.isConstructor()) {
            return false;
        }
        return !this.isAbstract();
    }

    @Override
    public boolean supportsTransient() {
        return false;
    }

    @Override
    public boolean canBeSetTransient() {
        return false;
    }

    @Override
    public boolean supportsVolatile() {
        return false;
    }

    @Override
    public boolean canBeSetVolatile() {
        return false;
    }

    @Override
    public void modifierChanged(int oldCode, int newCode) {
        this.firePropertyChanged("modifierCode", oldCode, newCode);
        this.firePropertyChanged(SIGNATURE_PROPERTY, "modifier");
        if (MWModifier.anyFlagsAreDifferent(3386, oldCode, newCode)) {
            this.allowedModifiersChanged();
        }
    }

    void allowedModifiersChanged() {
        this.modifier.allowedModifiersChanged();
    }

    @Override
    public void accessLevelChanged(String oldValue, String newValue) {
        this.firePropertyChanged("modifierAccessLevel", oldValue, newValue);
    }

    boolean hasSameSignatureAs(ExternalConstructor externalConstructor) {
        if (!this.isConstructor()) {
            return false;
        }
        String javaName = MWMethod.shortNameFor(externalConstructor);
        return this.hasSameSignatureAs(javaName, externalConstructor.getParameterTypes());
    }

    boolean hasSameSignatureAs(ExternalMethod externalMethod) {
        if (this.isConstructor()) {
            return false;
        }
        return this.hasSameSignatureAs(externalMethod.getName(), externalMethod.getParameterTypes());
    }

    private boolean hasSameSignatureAs(String javaName, ExternalClassDescription[] externalParameters) {
        if (!this.getName().equals(javaName)) {
            return false;
        }
        int externalParametersLength = externalParameters.length;
        if (this.methodParametersSize() != externalParametersLength) {
            return false;
        }
        for (int i = 0; i < externalParametersLength; ++i) {
            if (this.getMethodParameter(i).hasSameSignatureAs(externalParameters[i])) continue;
            return false;
        }
        return true;
    }

    public boolean hasSameSignatureAs(MWMethod method) {
        if (!this.getName().equals(method.getName())) {
            return false;
        }
        int methodParametersSize = method.methodParametersSize();
        if (this.methodParametersSize() != methodParametersSize) {
            return false;
        }
        for (int i = 0; i < methodParametersSize; ++i) {
            if (this.getMethodParameter(i).hasSameSignatureAs(method.getMethodParameter(i))) continue;
            return false;
        }
        return true;
    }

    boolean hasSignature(String methodName) {
        return this.hasSignature(methodName, EMPTY_TYPE_ARRAY, EMPTY_INT_ARRAY);
    }

    boolean hasSignature(String methodName, MWClass type, int dimensionality) {
        return this.hasSignature(methodName, new MWClass[]{type}, new int[]{dimensionality});
    }

    boolean hasSignature(String methodName, MWClass type1, int dimensionality1, MWClass type2, int dimensionality2) {
        return this.hasSignature(methodName, new MWClass[]{type1, type2}, new int[]{dimensionality1, dimensionality2});
    }

    boolean hasSignature(String methodName, MWClass[] types, int[] dimensionalities) {
        if (types.length != dimensionalities.length) {
            throw new IllegalArgumentException("arrays are different lengths: " + types.length + " vs. " + dimensionalities.length);
        }
        if (!this.getName().equals(methodName)) {
            return false;
        }
        if (this.methodParametersSize() != types.length) {
            return false;
        }
        int i = types.length;
        while (i-- > 0) {
            MWMethodParameter parm = this.getMethodParameter(i);
            if (parm.getType() != types[i]) {
                return false;
            }
            if (parm.getDimensionality() == dimensionalities[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isAbstract() {
        return this.getModifier().isAbstract() || this.getDeclaringType().isInterface();
    }

    public boolean isStatic() {
        return this.getModifier().isStatic();
    }

    public boolean isFinal() {
        return this.getModifier().isFinal() || this.getModifier().isPrivate() || this.getDeclaringType().getModifier().isFinal();
    }

    public boolean isStrict() {
        return this.getModifier().isStrict() || this.getDeclaringType().isStrict();
    }

    public boolean isInstanceMethod() {
        return !this.isConstructor() && !this.isStatic();
    }

    public boolean returnTypeIsVoid() {
        return this.returnTypeDeclaration.isVoid();
    }

    public boolean returnTypeIsArray() {
        return this.returnTypeDeclaration.isArray();
    }

    public boolean throwsException(MWClass exceptionType) {
        return this.containsExceptionType(exceptionType);
    }

    private boolean looksLikeAGetMethod() {
        return this.isInstanceMethod() && !this.returnTypeIsVoid() && this.methodParametersSize() == 0 && this.getName().startsWith("get");
    }

    public boolean isEjb20GetMethod() {
        return this.looksLikeAGetMethod() && this.isAbstract();
    }

    private boolean looksLikeASetMethod() {
        return this.isInstanceMethod() && this.returnTypeIsVoid() && this.methodParametersSize() == 1 && this.getName().startsWith("set");
    }

    boolean isEjb20SetMethodFor(MWMethod ejb20GetMethod) {
        return this.looksLikeASetMethod() && this.isAbstract() && this.getName().endsWith(ejb20GetMethod.getName().substring(3)) && this.methodParametersSize() == 1 && this.getMethodParameter(0).matches(ejb20GetMethod.returnTypeDeclaration);
    }

    public boolean isAccessor() {
        return this.getAccessedAttribute() != null;
    }

    public boolean isZeroArgumentConstructor() {
        return this.isConstructor() && this.methodParametersSize() == 0;
    }

    boolean isCandidateTopLinkGetMethod() {
        return this.isInstanceMethod() && this.methodParametersSize() == 0 && !this.returnTypeDeclaration.isVoid();
    }

    boolean isCandidateTopLinkSetMethod() {
        return this.isInstanceMethod() && this.methodParametersSize() == 1;
    }

    boolean isCandidateGetMethodFor(MWClassAttribute attribute) {
        return this.isCandidateGetMethodFor(attribute.getType(), attribute.getDimensionality());
    }

    boolean isCandidateGetMethodFor(MWClass attributeType) {
        return this.isCandidateGetMethodFor(attributeType, 0);
    }

    boolean isCandidateGetMethodFor(MWClass attributeType, int attributeDimensionality) {
        return this.isZeroArgumentInstanceMethodWithCompatibleReturnType(attributeType, attributeDimensionality);
    }

    private boolean isZeroArgumentInstanceMethodWithCompatibleReturnType(MWClass type, int dimensionality) {
        return this.isInstanceMethod() && this.methodParametersSize() == 0 && this.returnTypeDeclaration.mightBeAssignableFrom(type, dimensionality);
    }

    boolean isCandidateSetMethodFor(MWClassAttribute attribute) {
        return this.isCandidateSetMethodFor(attribute.getType(), attribute.getDimensionality());
    }

    boolean isCandidateSetMethodFor(MWClass attributeType) {
        return this.isCandidateSetMethodFor(attributeType, 0);
    }

    boolean isCandidateSetMethodFor(MWClass attributeType, int attributeDimensionality) {
        return this.isInstanceMethodWithCompatibleArgument(attributeType, attributeDimensionality);
    }

    private boolean isInstanceMethodWithCompatibleArgument(MWClass type, int dimensionality) {
        return this.isInstanceMethod() && this.methodParametersSize() == 1 && this.getMethodParameter().mightBeAssignableFrom(type, dimensionality);
    }

    boolean isCandidateAddMethodFor(MWClass itemType) {
        return this.isInstanceMethodWithCompatibleArgument(itemType, 0);
    }

    boolean isCandidateAddMethodFor(MWClass keyType, MWClass itemType) {
        return this.isInstanceMethod() && this.methodParametersSize() == 2 && this.getMethodParameter(0).mightBeAssignableFrom(keyType, 0) && this.getMethodParameter(1).mightBeAssignableFrom(itemType, 0);
    }

    boolean isCandidateRemoveMethodFor(MWClass itemOrKeyType) {
        return this.isInstanceMethodWithCompatibleArgument(itemOrKeyType, 0);
    }

    public boolean isCandidateMapContainerPolicyKeyMethod() {
        return this.isInstanceMethod() && this.methodParametersSize() == 0 && !this.returnTypeDeclaration.isVoid();
    }

    public boolean isCandidateClassExtractionMethod() {
        return this.isStatic() && this.methodParametersSize() == 1 && this.getMethodParameter().getDimensionality() == 0 && this.getMethodParameter().getType() == this.typeFor(Record.class) && this.returnTypeDeclaration.isAssignableFrom(this.typeFor(Class.class));
    }

    public boolean isCandidateCloneMethod() {
        return this.isInstanceMethod() && this.methodParametersSize() == 0 && this.returnTypeDeclaration.mightBeAssignableFrom(this.getDeclaringType());
    }

    public boolean isCandidateDescriptorEventMethod() {
        return this.isInstanceMethod() && this.methodParametersSize() == 1 && (this.getMethodParameter().getType() == this.typeFor(DescriptorEvent.class) || this.getMethodParameter().getType() == this.typeFor(Session.class));
    }

    public boolean isCandidateFactoryMethod() {
        return this.isCandidateInstantiationMethod();
    }

    public boolean isCandidateInstantiationMethod() {
        return this.isCandidateInstantiationMethodFor(this.getDeclaringType());
    }

    private boolean isCandidateInstantiationMethodFor(MWClass type) {
        return this.isStatic() && this.isCandidateFactoryInstantiationMethodFor(type);
    }

    public boolean isCandidateFactoryInstantiationMethodFor(MWClass type) {
        return !this.isConstructor() && this.methodParametersSize() == 0 && this.returnTypeDeclaration.mightBeAssignableFrom(type);
    }

    public boolean isCandidateDescriptorAfterLoadMethod() {
        return this.isStatic() && this.methodParametersSize() == 1 && this.getMethodParameter().getDimensionality() == 0 && this.getMethodParameter().getType() == this.typeFor(ClassDescriptor.class);
    }

    public boolean isCandidateAttributeTransformerMethod() {
        if (this.isConstructor()) {
            return false;
        }
        if (this.getReturnType().isVoid()) {
            return false;
        }
        if (this.methodParametersSize() == 1) {
            MWMethodParameter parm = this.getMethodParameter(0);
            if (parm.getDimensionality() == 0) {
                return parm.getType().isAssignableTo(this.typeFor(Record.class));
            }
            return false;
        }
        if (this.methodParametersSize() == 2) {
            MWMethodParameter parm1 = this.getMethodParameter(0);
            MWMethodParameter parm2 = this.getMethodParameter(1);
            if (parm1.getDimensionality() == 0 && parm2.getDimensionality() == 0) {
                return parm1.getType().isAssignableTo(this.typeFor(Record.class)) && parm2.getType() == this.typeFor(Session.class);
            }
            return false;
        }
        return false;
    }

    public boolean isCandidateFieldTransformerMethod() {
        if (this.isConstructor()) {
            return false;
        }
        if (this.getReturnType().isVoid()) {
            return false;
        }
        if (this.methodParametersSize() == 0) {
            return true;
        }
        if (this.methodParametersSize() == 1) {
            MWMethodParameter parm = this.getMethodParameter(0);
            if (parm.getDimensionality() == 0) {
                return parm.getType() == this.typeFor(Session.class);
            }
            return false;
        }
        return false;
    }

    NonreflectiveMethodDefinition methodDefinition(MWMethodCodeGenPolicy codeGenPolicy) {
        NonreflectiveMethodDefinition def = new NonreflectiveMethodDefinition();
        def.setAccessLevel(this.getModifier().accessLevel());
        def.setIsConstructor(this.isConstructor());
        def.setIsAbstract(this.isAbstract());
        if (!this.isConstructor()) {
            def.setReturnType(this.returnTypeDeclaration.declaration());
        }
        def.setName(this.getName());
        codeGenPolicy.insertArguments(def);
        Iterator stream = this.exceptionTypes();
        while (stream.hasNext()) {
            def.addException(((MWClass)stream.next()).getName());
        }
        codeGenPolicy.insertMethodBody(def);
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.modifier);
        if (!this.isConstructor()) {
            children.add(this.returnTypeDeclaration);
        }
        Collection collection = this.methodParameters;
        synchronized (collection) {
            children.addAll(this.methodParameters);
        }
        children.add(this.accessedAttributeHandle);
        collection = this.exceptionTypeHandles;
        synchronized (collection) {
            children.addAll(this.exceptionTypeHandles);
        }
    }

    private MWHandle.NodeReferenceScrubber buildAccessedAttributeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWMethod.this.setAccessedAttribute(null);
            }

            public String toString() {
                return "MWMethod.buildAccessedAttributeScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber exceptionTypeScrubber() {
        if (this.exceptionTypeScrubber == null) {
            this.exceptionTypeScrubber = this.buildExceptionTypeScrubber();
        }
        return this.exceptionTypeScrubber;
    }

    private MWHandle.NodeReferenceScrubber buildExceptionTypeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWMethod.this.removeExceptionTypeHandle((MWClassHandle)handle);
            }

            public String toString() {
                return "MWMethod.buildExceptionTypeScrubber()";
            }
        };
    }

    @Override
    public void nodeRenamed(Node node) {
        super.nodeRenamed(node);
        if (this.isConstructor()) {
            if (this.getDeclaringType() == node) {
                this.setName(this.getDeclaringType().shortName());
            }
        } else if (this.getReturnType() == node) {
            this.firePropertyChanged(SIGNATURE_PROPERTY, RETURN_TYPE_PROPERTY);
        }
    }

    void refresh(ExternalConstructor externalConstructor) {
        if (!this.hasSameSignatureAs(externalConstructor)) {
            throw new IllegalArgumentException(externalConstructor.toString());
        }
        this.getModifier().refresh(externalConstructor.getModifiers());
        this.refreshExceptionTypes(externalConstructor.getExceptionTypes());
    }

    void refresh(ExternalMethod externalMethod) {
        if (!this.hasSameSignatureAs(externalMethod)) {
            throw new IllegalArgumentException(externalMethod.toString());
        }
        this.getModifier().refresh(externalMethod.getModifiers());
        this.returnTypeDeclaration.refresh(externalMethod.getReturnType());
        this.refreshExceptionTypes(externalMethod.getExceptionTypes());
    }

    private void refreshExceptionTypes(ExternalClassDescription[] externalExceptions) {
        Collection removedExceptionTypes = CollectionTools.collection(this.exceptionTypes());
        int i = externalExceptions.length;
        while (i-- > 0) {
            if (removedExceptionTypes.remove(this.typeNamed(externalExceptions[i].getName()))) continue;
            this.addExceptionType(this.typeNamed(externalExceptions[i].getName()));
        }
        this.removeExceptionTypes(removedExceptionTypes);
    }

    private MWMethodParameter buildMethodParameter(ExternalClassDescription externalClassDescription) {
        return new MWMethodParameter(this, externalClassDescription);
    }

    private MWMethodParameter buildMethodParameter(MWClass type, int dimensionality) {
        return new MWMethodParameter(this, type, dimensionality);
    }

    private MWTypeDeclaration buildDefaultReturnTypeDeclaration() {
        return new MWTypeDeclaration((MWModel)this, this.typeFor(Void.TYPE));
    }

    @Override
    public int compareTo(Object object) {
        MWMethod otherMethod = null;
        try {
            otherMethod = (MWMethod)object;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Object \"" + object + "\" must be an instance of MWMethod.");
        }
        if (this.isConstructor() && !otherMethod.isConstructor()) {
            return -1;
        }
        if (!this.isConstructor() && otherMethod.isConstructor()) {
            return 1;
        }
        return super.compareTo(object);
    }

    @Override
    public String displayString() {
        return this.signature();
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append(this.shortSignature());
    }

    public String signature() {
        StringBuffer sb = new StringBuffer(200);
        this.printSignatureOn(sb);
        return sb.toString();
    }

    public String signatureWithReturnType() {
        StringBuffer sb = new StringBuffer(200);
        this.printSignatureWithReturnTypeOn(sb);
        return sb.toString();
    }

    public String shortSignature() {
        StringBuffer sb = new StringBuffer(200);
        this.printShortSignatureOn(sb);
        return sb.toString();
    }

    public String shortSignatureWithReturnType() {
        StringBuffer sb = new StringBuffer(200);
        this.printShortSignatureWithReturnTypeOn(sb);
        return sb.toString();
    }

    public void printSignatureWithReturnTypeOn(StringBuffer sb) {
        this.printSignatureOn(sb);
        this.printReturnTypeOn(sb, true);
    }

    public void printSignatureOn(StringBuffer sb) {
        this.printSignatureOn(sb, true);
    }

    public void printShortSignatureWithReturnTypeOn(StringBuffer sb) {
        this.printShortSignatureOn(sb);
        this.printReturnTypeOn(sb, false);
    }

    public void printShortSignatureOn(StringBuffer sb) {
        this.printSignatureOn(sb, false);
    }

    private void printReturnTypeOn(StringBuffer sb, boolean printFullyQualifiedTypeNames) {
        if (!this.isConstructor()) {
            sb.append(" : ");
            if (printFullyQualifiedTypeNames) {
                this.returnTypeDeclaration.printSignatureOn(sb);
            } else {
                this.returnTypeDeclaration.printShortSignatureOn(sb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printSignatureOn(StringBuffer sb, boolean printFullyQualifiedTypeNames) {
        sb.append(this.name);
        sb.append('(');
        List list = this.methodParameters;
        synchronized (list) {
            Iterator stream = this.methodParameters.iterator();
            while (stream.hasNext()) {
                MWMethodParameter methodParameter = (MWMethodParameter)stream.next();
                if (printFullyQualifiedTypeNames) {
                    methodParameter.printSignatureOn(sb);
                } else {
                    methodParameter.printShortSignatureOn(sb);
                }
                if (!stream.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append(')');
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWMethod.class);
        descriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        XMLDirectMapping constructorMapping = (XMLDirectMapping)descriptor.addDirectMapping(CONSTRUCTOR_PROPERTY, "constructor/text()");
        constructorMapping.setNullValue((Object)Boolean.FALSE);
        XMLDirectMapping modifierMapping = (XMLDirectMapping)descriptor.addDirectMapping("modifier", "getModifierForTopLink", "setModifierForTopLink", "modifier/text()");
        modifierMapping.setNullValue((Object)new Integer(0));
        XMLCompositeObjectMapping returnTypeDeclarationMapping = new XMLCompositeObjectMapping();
        returnTypeDeclarationMapping.setAttributeName("returnTypeDeclaration");
        returnTypeDeclarationMapping.setReferenceClass(MWTypeDeclaration.class);
        returnTypeDeclarationMapping.setXPath("return-type-declaration");
        descriptor.addMapping((DatabaseMapping)returnTypeDeclarationMapping);
        XMLCompositeCollectionMapping parameterTypeDeclarationsMapping = new XMLCompositeCollectionMapping();
        parameterTypeDeclarationsMapping.setAttributeName(METHOD_PARAMETERS_LIST);
        parameterTypeDeclarationsMapping.setReferenceClass(MWMethodParameter.class);
        parameterTypeDeclarationsMapping.setXPath("method-parameters/method-parameter");
        descriptor.addMapping((DatabaseMapping)parameterTypeDeclarationsMapping);
        XMLCompositeCollectionMapping exceptionTypeHandlesMapping = new XMLCompositeCollectionMapping();
        exceptionTypeHandlesMapping.setAttributeName("exceptionTypeHandles");
        exceptionTypeHandlesMapping.setGetMethodName("getExceptionTypeHandlesForTopLink");
        exceptionTypeHandlesMapping.setSetMethodName("setExceptionTypeHandlesForTopLink");
        exceptionTypeHandlesMapping.setReferenceClass(MWClassHandle.class);
        exceptionTypeHandlesMapping.setXPath("exception-type-handles/class-handle");
        descriptor.addMapping((DatabaseMapping)exceptionTypeHandlesMapping);
        XMLCompositeObjectMapping accessedAttributeHandleMapping = new XMLCompositeObjectMapping();
        accessedAttributeHandleMapping.setAttributeName("accessedAttributeHandle");
        accessedAttributeHandleMapping.setGetMethodName("getAccessedAttributeHandleForTopLink");
        accessedAttributeHandleMapping.setSetMethodName("setAccessedAttributeHandleForTopLink");
        accessedAttributeHandleMapping.setReferenceClass(MWAttributeHandle.class);
        accessedAttributeHandleMapping.setXPath("accessed-attribute-handle");
        descriptor.addMapping((DatabaseMapping)accessedAttributeHandleMapping);
        return descriptor;
    }

    private int getModifierForTopLink() {
        return this.modifier.getCode();
    }

    private void setModifierForTopLink(int code) {
        this.modifier.setCodeForTopLink(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getExceptionTypeHandlesForTopLink() {
        Collection collection = this.exceptionTypeHandles;
        synchronized (collection) {
            return new TreeSet(this.exceptionTypeHandles);
        }
    }

    private void setExceptionTypeHandlesForTopLink(Collection handles) {
        Iterator stream = handles.iterator();
        while (stream.hasNext()) {
            ((MWClassHandle)stream.next()).setScrubber(this.exceptionTypeScrubber());
        }
        this.exceptionTypeHandles = handles;
    }

    private MWAttributeHandle getAccessedAttributeHandleForTopLink() {
        return this.accessedAttributeHandle.getAttribute() == null ? null : this.accessedAttributeHandle;
    }

    private void setAccessedAttributeHandleForTopLink(MWAttributeHandle accessedAttributeHandle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildAccessedAttributeScrubber();
        this.accessedAttributeHandle = accessedAttributeHandle == null ? new MWAttributeHandle(this, scrubber) : accessedAttributeHandle.setScrubber(scrubber);
    }
}

