/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.ModelExamples;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.tests.jpa.CMP3TestModel;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class EMModifyAndMergeTest
extends EntityContainerTestBase {
    public Integer[] empIDs = new Integer[2];
    public Integer[] projIDs = new Integer[3];
    Employee employee;
    Project project;

    public EMModifyAndMergeTest() {
        this.setDescription("Test modify and merge in EntityManager");
    }

    @Override
    public void setup() {
        super.setup();
        this.employee = ModelExamples.employeeExample1();
        this.project = ModelExamples.projectExample1();
        try {
            this.beginTransaction();
            this.getEntityManager().persist((Object)this.employee);
            this.getEntityManager().persist((Object)this.project);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            ex.printStackTrace();
            throw new TestErrorException("Exception thrown durring persist and flush" + ex);
        }
        this.empIDs[0] = this.employee.getId();
        this.projIDs[0] = this.project.getId();
    }

    public void test() {
        this.employee.setFirstName("Ivy");
        this.employee.setSalary(30000);
        this.project.setDescription("To change the plan completely");
        this.project.setName("Refactory");
        try {
            CMP3TestModel.createEntityManager();
            this.beginTransaction();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
            emp.setFirstName("Tobin");
            emp.setSalary(20000);
            this.getEntityManager().merge((Object)this.employee);
            Project proj = (Project)this.getEntityManager().find(Project.class, (Object)this.projIDs[0]);
            proj.setDescription("To reevaluate the plan");
            proj.setName("Reassessment");
            this.getEntityManager().merge((Object)this.project);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            ex.printStackTrace();
            throw new TestErrorException("Exception thrown durring persist and flush" + ex);
        }
    }

    public void verify() {
        this.employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
        if (!this.employee.getFirstName().equals("Ivy")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " first name was not merged");
        }
        if (this.employee.getSalary() != 30000) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " salary was not merge");
        }
        this.project = (Project)this.getEntityManager().find(Project.class, (Object)this.projIDs[0]);
        if (!this.project.getDescription().equals("To change the plan completely")) {
            throw new TestErrorException("Project ID :" + this.projIDs[0] + " description was not merged");
        }
        if (!this.project.getName().equals("Refactory")) {
            throw new TestErrorException("Project ID :" + this.projIDs[0] + " name was not merged");
        }
        ((JpaEntityManager)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
        if (!this.employee.getFirstName().equals("Ivy")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " first name was not merged");
        }
        if (this.employee.getSalary() != 30000) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " salary was not merge");
        }
        this.project = (Project)this.getEntityManager().find(Project.class, (Object)this.projIDs[0]);
        if (!this.project.getDescription().equals("To change the plan completely")) {
            throw new TestErrorException("Project ID :" + this.projIDs[0] + " description was not merged");
        }
        if (!this.project.getName().equals("Refactory")) {
            throw new TestErrorException("Project ID :" + this.projIDs[0] + " name was not merged");
        }
    }
}

