/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.interfaces;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.interfaces.Contact;
import org.eclipse.persistence.testing.models.interfaces.Email;
import org.eclipse.persistence.testing.models.interfaces.Phone;

public class ReadAllConformInUowTest
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        Vector result;
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Email email = new Email();
        Email emailClone = (Email)uow.registerObject((Object)email);
        emailClone.setAddress("info@Conform.com");
        Phone phone = new Phone();
        Phone phoneClone = (Phone)uow.registerObject((Object)phone);
        phoneClone.setNumber("123 456-7890");
        uow.assignSequenceNumbers();
        Number emailId = emailClone.getId();
        Number phoneId = phoneClone.getId();
        Vector<Number> ids = new Vector<Number>(2);
        ids.add(emailId);
        ids.add(phoneId);
        ReadAllQuery query = new ReadAllQuery(Contact.class);
        Expression exp = query.getExpressionBuilder().get("id").in(ids);
        query.setSelectionCriteria(exp);
        query.conformResultsInUnitOfWork();
        try {
            result = (Vector)uow.executeQuery((DatabaseQuery)query);
        }
        finally {
            uow.release();
        }
        String errorMsg = "";
        if (!result.contains(emailClone)) {
            errorMsg = errorMsg + "The result doesn't contain Email; ";
        }
        if (!result.contains(phoneClone)) {
            errorMsg = errorMsg + "The result doesn't contain Phone.";
        }
        if (errorMsg.length() > 0) {
            throw new TestErrorException(errorMsg);
        }
    }
}

