/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class MultipleOrderByWithSameFieldNameNullsFirstTest
extends AutoVerifyTestCase {
    public MultipleOrderByWithSameFieldNameNullsFirstTest() {
        this.setDescription("This test verifies the ordering feature works properly with multiple orderings with the same field name.");
    }

    public void setup() {
        if (!this.getSession().getPlatform().isOracle()) {
            this.throwWarning("NULLS FIRST only supported on Oracle.");
        }
    }

    public void test() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression orderExpr1 = builder.get("address").get("street").ascending().nullsFirst();
        Expression orderExpr2 = builder.get("manager").get("address").get("street").ascending().nullsLast();
        Expression expr = builder.anyOf("projects").get("id").equal(2193);
        ReadAllQuery query = new ReadAllQuery(Employee.class, expr);
        query.addOrdering(orderExpr1);
        query.addOrdering(orderExpr2);
        this.getSession().executeQuery((DatabaseQuery)query);
    }
}

