/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.history;

import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;

public class HistoricalDatabaseTable
extends DatabaseTable {
    protected String historicalName;
    protected String historicalNameDelimited;

    public HistoricalDatabaseTable() {
    }

    public HistoricalDatabaseTable(String name, String qualifier) {
        super(name, qualifier);
    }

    public HistoricalDatabaseTable(String possiblyQualifiedName) {
        super(possiblyQualifiedName);
    }

    public HistoricalDatabaseTable(DatabaseTable source, DatabaseTable mirroring, DatasourcePlatform platform) {
        super(source.getName(), source.getTableQualifier());
        this.historicalName = mirroring.getQualifiedName();
        if (mirroring.shouldUseDelimiters()) {
            this.historicalNameDelimited = mirroring.getQualifiedNameDelimited(platform);
        }
    }

    public void setHistoricalName(String name) {
        if (name.startsWith(Helper.getDefaultStartDatabaseDelimiter()) && name.endsWith(Helper.getDefaultEndDatabaseDelimiter())) {
            this.historicalNameDelimited = name;
            this.historicalName = this.historicalNameDelimited.replaceAll(Helper.getDefaultStartDatabaseDelimiter(), "");
            this.historicalName = this.historicalName.replaceAll(Helper.getDefaultEndDatabaseDelimiter(), "");
        } else {
            this.historicalName = name;
        }
    }

    @Override
    public String getQualifiedName() {
        if (this.historicalName != null) {
            return this.historicalName;
        }
        return super.getQualifiedName();
    }

    @Override
    public String getQualifiedNameDelimited(DatasourcePlatform platform) {
        if (this.historicalNameDelimited != null) {
            return this.historicalNameDelimited;
        }
        if (this.historicalName != null) {
            return this.historicalName;
        }
        return super.getQualifiedNameDelimited(platform);
    }
}

