/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.sql.Date;
import java.sql.Time;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class DeepRefreshTest
extends TestCase {
    protected Employee employeeObject;
    protected String city;
    protected String managerName;
    protected int projectSize;
    protected int phoneSize;
    protected Time startTime;
    protected Date endDate;

    public DeepRefreshTest() {
        this.setDescription("This test verifies the deep refresh feature works properly");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.employeeObject = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)"Charles"));
    }

    public void test() throws Exception {
        this.city = this.employeeObject.getAddress().getCity();
        this.employeeObject.getAddress().setCity("Chelmsford");
        this.startTime = this.employeeObject.getStartTime();
        this.employeeObject.setStartTime(null);
        this.endDate = this.employeeObject.getPeriod().getEndDate();
        this.employeeObject.getPeriod().setEndDate(null);
        this.managerName = this.employeeObject.getManager().getFirstName();
        this.employeeObject.getManager().setFirstName("Karl");
        this.phoneSize = this.employeeObject.getPhoneNumbers().size();
        this.employeeObject.getPhoneNumbers().removeAllElements();
        this.projectSize = this.employeeObject.getProjects().size();
        this.employeeObject.getProjects().removeAllElements();
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSelectionObject((Object)this.employeeObject);
        query.refreshIdentityMapResult();
        query.cascadeAllParts();
        this.getSession().executeQuery((DatabaseQuery)query);
    }

    protected void verify() throws Exception {
        if (!this.employeeObject.getAddress().getCity().equals(this.city)) {
            throw new TestErrorException("The refresh test failed, city not refreshed:" + this.city + ":" + this.employeeObject.getAddress().getCity());
        }
        if (!this.employeeObject.getPeriod().getEndDate().equals(this.endDate)) {
            throw new TestErrorException("The refresh test failed, end-date not refreshed:" + this.endDate + ":" + this.employeeObject.getPeriod().getEndDate());
        }
        if (!this.employeeObject.getStartTime().equals(this.startTime)) {
            throw new TestErrorException("The refresh test failed, start-time not refreshed:" + this.startTime + ":" + this.employeeObject.getStartTime());
        }
        if (this.employeeObject.getManager().getFirstName().equals("Karl")) {
            throw new TestErrorException("The refresh test failed, first-name not refreshed:Karl:" + this.employeeObject.getManager().getFirstName());
        }
        if (this.employeeObject.getPhoneNumbers().size() != this.phoneSize) {
            throw new TestErrorException("The refresh test failed, phones not refreshed:" + this.phoneSize + ":" + this.employeeObject.getPhoneNumbers());
        }
        if (this.employeeObject.getProjects().size() != this.projectSize) {
            throw new TestErrorException("The refresh test failed, projects not refreshed:" + this.projectSize + ":" + this.employeeObject.getProjects());
        }
    }
}

