/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;

final class AboutDialog
extends JDialog {
    private Action okAction;

    AboutDialog(WorkbenchContext context) {
        super((Frame)context.getCurrentWindow());
        this.initialize(context);
    }

    private void initialize(WorkbenchContext context) {
        this.setTitle(context.getApplicationContext().getResourceRepository().getString("about", context.getApplicationContext().getApplication().getProductName()));
        this.setName("About");
        this.setModal(true);
        this.setResizable(false);
        this.okAction = this.buildOKAction(context);
        this.initializeDefaultKeyboardActions();
        this.initializeContentPane(context.getApplicationContext());
    }

    protected AbstractFrameworkAction buildOKAction(WorkbenchContext context) {
        return new AbstractFrameworkAction(context){

            @Override
            protected void initialize() {
                this.initializeText("DIALOG.OK_BUTTON_TEXT");
            }

            @Override
            protected void execute() {
                AboutDialog.this.dispose();
            }
        };
    }

    protected void initializeDefaultKeyboardActions() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", this.okAction);
    }

    void initializeContentPane(ApplicationContext context) {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 11;
        constraints.insets = new Insets(10, 5, 0, 5);
        this.getContentPane().add((Component)this.buildMainPanel(context), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 11;
        constraints.insets = new Insets(10, 5, 10, 5);
        this.getContentPane().add((Component)new JSeparator(), constraints);
        JPanel buttonPanel = this.buildButtonPanel();
        buttonPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 11;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)buttonPanel, constraints);
    }

    private JPanel buildMainPanel(ApplicationContext context) {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JLabel logoLabel = new JLabel(context.getResourceRepository().getIcon("mw.about"));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 3;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 19;
        constraints.fill = 2;
        constraints.insets = new Insets(20, 30, 0, 0);
        mainPanel.add((Component)logoLabel, constraints);
        JLabel toplinkLabel = new JLabel(context.getApplication().getProductName());
        toplinkLabel.setHorizontalAlignment(0);
        Font font = toplinkLabel.getFont();
        toplinkLabel.setFont(new Font(font.getName(), 1, font.getSize() + 5));
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 10;
        constraints.fill = 2;
        constraints.insets = new Insets(20, 10, 0, 50);
        mainPanel.add((Component)toplinkLabel, constraints);
        JLabel versionLabel = new JLabel(context.getResourceRepository().getString("VERSION", context.getApplication().getVersionNumber()));
        versionLabel.setHorizontalAlignment(0);
        font = versionLabel.getFont();
        versionLabel.setFont(new Font(font.getName(), 1, font.getSize()));
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 10;
        constraints.fill = 2;
        constraints.insets = new Insets(5, 10, 0, 50);
        mainPanel.add((Component)versionLabel, constraints);
        JLabel buildLabel = new JLabel(context.getResourceRepository().getString("BUILD", context.getApplication().getBuildNumber()));
        buildLabel.setHorizontalAlignment(0);
        font = buildLabel.getFont();
        buildLabel.setFont(new Font(font.getName(), 1, font.getSize()));
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 10;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 10, 0, 50);
        mainPanel.add((Component)buildLabel, constraints);
        LabelArea copyrightLabel = new LabelArea(context.getResourceRepository().getString("COPYRIGHT"));
        copyrightLabel.setHorizontalAlignment(0);
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.anchor = 19;
        constraints.fill = 2;
        constraints.insets = new Insets(30, 50, 0, 50);
        mainPanel.add((Component)copyrightLabel, constraints);
        return mainPanel;
    }

    JPanel buildButtonPanel() {
        JPanel panel = new JPanel();
        JButton okButton = new JButton(this.okAction);
        panel.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        return panel;
    }

    @Override
    public void show() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        super.show();
    }
}

