/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.eclipse.persistence.tools.workbench.framework.Application;
import org.eclipse.persistence.tools.workbench.framework.NodeManager;
import org.eclipse.persistence.tools.workbench.framework.action.ActionRepository;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.AbstractApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.AbstractWorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkApplication;
import org.eclipse.persistence.tools.workbench.framework.internal.WorkbenchWindow;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.TextAreaDialog;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

final class FrameworkLogHandlerDialog
extends AbstractDialog {
    private LogRecord logRecord;
    private Formatter logFormatter;

    private static WorkbenchWindow findWindow() {
        WorkbenchWindow anyWindow = null;
        WorkbenchWindow focusWindow = null;
        Frame[] frames = Frame.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            Frame frame = frames[i];
            if (!(frame instanceof WorkbenchWindow)) continue;
            WorkbenchWindow ww = (WorkbenchWindow)frame;
            if (ww.isFocusOwner()) {
                focusWindow = ww;
                break;
            }
            if (anyWindow != null) continue;
            anyWindow = ww;
        }
        return focusWindow == null ? anyWindow : focusWindow;
    }

    private static WorkbenchContext buildContext(FrameworkApplication application) {
        return new LocalWorkbenchContext(application, FrameworkLogHandlerDialog.findWindow());
    }

    public FrameworkLogHandlerDialog(FrameworkApplication application, LogRecord logRecord) {
        super(FrameworkLogHandlerDialog.buildContext(application), application.getResourceRepository().getString("UNEXPECTED_ERROR"));
        this.logRecord = logRecord;
        this.logFormatter = new SimpleFormatter();
    }

    @Override
    protected Component buildMainPanel() {
        JPanel mainPanel = new JPanel(new GridLayout(0, 1));
        JLabel messageLabel = new JLabel();
        messageLabel.setText(this.logFormatter.formatMessage(this.logRecord));
        messageLabel.setIcon(this.resourceRepository().getIcon("error"));
        messageLabel.setHorizontalAlignment(0);
        mainPanel.add(messageLabel);
        if (this.logRecord.getThrown() != null) {
            JTextArea textArea = new JTextArea(this.logRecord.getThrown().toString());
            textArea.setFont(messageLabel.getFont());
            textArea.setTabSize(2);
            mainPanel.add(new JScrollPane(textArea));
        }
        mainPanel.setPreferredSize(new Dimension(350, Math.min(mainPanel.getPreferredSize().height + 50, 150)));
        return mainPanel;
    }

    @Override
    protected String helpTopicId() {
        return "dialog.unexpectedError";
    }

    @Override
    protected boolean cancelButtonIsVisible() {
        return false;
    }

    @Override
    protected Iterator buildCustomActions() {
        if (this.logRecord.getThrown() == null) {
            return super.buildCustomActions();
        }
        Action stackTraceAction = this.buildStackTraceAction();
        return new SingleElementIterator((Object)stackTraceAction);
    }

    private Action buildStackTraceAction() {
        return new AbstractAction(this.buildStackTraceText()){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameworkLogHandlerDialog.this.displayStackTrace();
            }
        };
    }

    protected String buildStackTraceText() {
        return this.resourceRepository().getString("STACK_TRACE");
    }

    protected void displayStackTrace() {
        TextAreaDialog dialog = new TextAreaDialog(this.logRecord.getThrown(), this.helpTopicId(), this.getWorkbenchContext(), (Dialog)this);
        dialog.setTitle(this.buildStackTraceText());
        dialog.show();
    }

    private static class LocalWorkbenchContext
    extends AbstractWorkbenchContext {
        FrameworkApplication application;
        private WorkbenchWindow window;
        private ApplicationContext applicationContext;

        LocalWorkbenchContext(FrameworkApplication application, WorkbenchWindow window) {
            this.application = application;
            this.window = window;
            this.applicationContext = this.buildApplicationContext();
        }

        private ApplicationContext buildApplicationContext() {
            return new AbstractApplicationContext(){

                @Override
                public Application getApplication() {
                    return LocalWorkbenchContext.this.application;
                }

                @Override
                public HelpManager getHelpManager() {
                    return LocalWorkbenchContext.this.application.getHelpManager();
                }

                @Override
                public NodeManager getNodeManager() {
                    return LocalWorkbenchContext.this.application.getNodeManager();
                }

                @Override
                public Preferences getPreferences() {
                    return LocalWorkbenchContext.this.application.getRootPreferences();
                }

                @Override
                public ResourceRepository getResourceRepository() {
                    return LocalWorkbenchContext.this.application.getResourceRepository();
                }
            };
        }

        public Application getApplication() {
            return this.application;
        }

        public HelpManager getHelpManager() {
            return this.application.getHelpManager();
        }

        public NodeManager getNodeManager() {
            return this.application.getNodeManager();
        }

        public Preferences getPreferences() {
            return this.application.getRootPreferences();
        }

        public ResourceRepository getResourceRepository() {
            return this.application.getResourceRepository();
        }

        @Override
        public ApplicationContext getApplicationContext() {
            return this.applicationContext;
        }

        @Override
        public ActionRepository getActionRepository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Window getCurrentWindow() {
            return this.window;
        }

        @Override
        public NavigatorSelectionModel getNavigatorSelectionModel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Component getPropertiesPage() {
            throw new UnsupportedOperationException();
        }
    }
}

