/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.FileChooser;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPlugin;
import org.eclipse.persistence.tools.workbench.uitools.CancelException;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class ProjectDeploymentXmlGenerationCoordinator {
    private WorkbenchContext context;

    public ProjectDeploymentXmlGenerationCoordinator(WorkbenchContext context) {
        this.context = context;
    }

    public boolean exportProjectDeploymentXml(MWProject project) {
        try {
            this.configureProjectDeploymentXMLFile(project);
            this.checkProjectProblems(project);
        }
        catch (CancelException ex) {
            return false;
        }
        if (project.deploymentXMLFile().isDirectory()) {
            this.showInvalidFileDialog(project);
            return false;
        }
        try {
            project.exportDeploymentXML();
        }
        catch (NoClassDefFoundError error) {
            if (error.getMessage().startsWith("oracle.xdb")) {
                this.showMissingXdbJarDialog();
                return false;
            }
            throw error;
        }
        this.showSuccessDialog(project);
        return true;
    }

    private void configureProjectDeploymentXMLFile(MWProject project) {
        if (!StringTools.stringIsEmpty((String)project.getDeploymentXMLFileName())) {
            return;
        }
        File directory = MappingsPlugin.buildExportDirectory(project, "", this.preferences());
        File initialFile = new File(directory, project.getName() + ".xml");
        LocalFileChooser chooser = new LocalFileChooser(this.context, directory, project.getSaveDirectory());
        chooser.setDialogTitle(this.resourceRepository().getString("PROJECT_XML_SAVE_AS_DIALOG_TITLE"));
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setSelectedFile(initialFile);
        chooser.setFileFilter(this.buildXMLFileFilter());
        int result = chooser.showSaveDialog(this.context.getCurrentWindow());
        if (result == 1) {
            throw new CancelException();
        }
        File selectedFile = chooser.getSelectedFile();
        project.setDeploymentXMLFileName(selectedFile.getPath());
        File selectedDir = selectedFile.getParentFile();
        if (selectedDir != null && selectedDir.isAbsolute() && !selectedDir.equals(project.getSaveDirectory())) {
            this.preferences().put("export location", selectedDir.getPath());
        }
    }

    private Preferences preferences() {
        return this.context.getApplicationContext().getPreferences();
    }

    private FileFilter buildXMLFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || ".xml".equals(FileTools.extension((File)file).toLowerCase());
            }

            @Override
            public String getDescription() {
                return ProjectDeploymentXmlGenerationCoordinator.this.resourceRepository().getString("PROJECT_XML_SAVE_AS_DIALOG_XML_DESCRIPTION");
            }
        };
    }

    private void checkProjectProblems(MWProject project) {
        if (!project.hasBranchProblems()) {
            return;
        }
        int response = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), new LabelArea(this.resourceRepository().getString("PROJECT_XML_PROJECT_PROBLEMS_DIALOG.message", StringTools.CR)), this.resourceRepository().getString("PROJECT_XML_PROJECT_PROBLEMS_DIALOG.title", project.getName()), 0, 2);
        if (response != 0) {
            throw new CancelException();
        }
    }

    private void showInvalidFileDialog(MWProject project) {
        JOptionPane.showMessageDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("GENERATE_PROJECT_XML_INVALID_FILE_DIALOG.message", project.deploymentXMLFile()), this.resourceRepository().getString("GENERATE_PROJECT_XML_INVALID_FILE_DIALOG.title", project.getName()), 0);
    }

    private void showMissingXdbJarDialog() {
        JOptionPane.showMessageDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("GENERATE_PROJECT_XML_MISSING_XDB_JAR.message", StringTools.CR), this.resourceRepository().getString("GENERATE_PROJECT_XML_MISSING_XDB_JAR.title"), 0);
    }

    private void showSuccessDialog(MWProject project) {
        JOptionPane.showMessageDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("GENERATE_PROJECT_XML_SUCCESS_DIALOG.message"), this.resourceRepository().getString("GENERATE_PROJECT_XML_SUCCESS_DIALOG.title", project.getName()), 1);
    }

    ResourceRepository resourceRepository() {
        return this.context.getApplicationContext().getResourceRepository();
    }

    private class LocalFileChooser
    extends FileChooser {
        private final WorkbenchContext workbenchContext;
        private static final long serialVersionUID = 1L;

        private LocalFileChooser(WorkbenchContext workbenchContext, File currentDirectory, File rootFile) {
            super(currentDirectory, rootFile);
            this.workbenchContext = workbenchContext;
        }

        @Override
        public void approveSelection() {
            int result = this.canReplaceExistingFile();
            if (result == 0) {
                super.approveSelection();
            } else if (result == 2) {
                this.cancelSelection();
            }
        }

        private int canReplaceExistingFile() {
            File file = this.getSelectedFile();
            if (file.exists() && !file.canWrite()) {
                String message = ProjectDeploymentXmlGenerationCoordinator.this.resourceRepository().getString("PROJECT_XML_SAVE_AS_DIALOG_CANT_SAVE", file);
                LabelArea label = new LabelArea(message);
                JOptionPane.showMessageDialog(this.workbenchContext.getCurrentWindow(), label, ProjectDeploymentXmlGenerationCoordinator.this.resourceRepository().getString("PROJECT_XML_SAVE_AS_DIALOG_CANT_SAVE_TITLE"), 2);
                return 1;
            }
            if (file.exists()) {
                String message = ProjectDeploymentXmlGenerationCoordinator.this.resourceRepository().getString("PROJECT_XML_SAVE_AS_DIALOG_REPLACE", this.getSelectedFile().getPath());
                LabelArea label = new LabelArea(message);
                return JOptionPane.showConfirmDialog(this.workbenchContext.getCurrentWindow(), label, ProjectDeploymentXmlGenerationCoordinator.this.resourceRepository().getString("PROJECT_XML_SAVE_AS_DIALOG_REPLACE_TITLE"), 1);
            }
            return 0;
        }
    }
}

