/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.action.ToggleFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ActiveIconBuilder;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.IconBuilder;
import org.eclipse.persistence.tools.workbench.framework.app.MenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsplugin.AutomappableNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.RemovableNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.RemoveAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.ActivateDescriptorAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.AdvancedPolicyAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorPackageNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MoveDescriptorAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.RenameDescriptorAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UnmappablePackageNode;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

public abstract class DescriptorNode
extends MappingsApplicationNode
implements UnmappablePackageNode,
AutomappableNode,
RemovableNode {
    protected static final String[] DESCRIPTOR_DISPLAY_STRING_PROPERTY_NAMES = new String[]{"name"};
    protected static final String[] DESCRIPTOR_ICON_PROPERTY_NAMES = new String[]{"hasBranchProblems", "active"};

    protected DescriptorNode(MWDescriptor descriptor, DescriptorPackageNode parentNode) {
        super((MWModel)descriptor, (TreeNodeValueModel)parentNode, parentNode.getPlugin(), parentNode.getApplicationContext());
    }

    private ToggleFrameworkAction getActivateDescriptorAction(WorkbenchContext context) {
        return new ActivateDescriptorAction(context);
    }

    protected FrameworkAction getRemoveDescriptorAction(WorkbenchContext context) {
        return new RemoveAction(context, "descriptor.remove");
    }

    protected FrameworkAction getRenameDescriptorAction(WorkbenchContext context) {
        return new RenameDescriptorAction(context);
    }

    protected FrameworkAction getMoveDescriptorAction(WorkbenchContext context) {
        return new MoveDescriptorAction(context);
    }

    @Override
    public String accessibleName() {
        return this.resourceRepository().getString(this.accessibleNameKey(), this.displayString());
    }

    @Override
    protected abstract String accessibleNameKey();

    @Override
    protected String[] displayStringPropertyNames() {
        return DESCRIPTOR_DISPLAY_STRING_PROPERTY_NAMES;
    }

    @Override
    protected String[] iconPropertyNames() {
        return DESCRIPTOR_ICON_PROPERTY_NAMES;
    }

    @Override
    protected IconBuilder buildIconBuilder() {
        return new ActiveIconBuilder(super.buildIconBuilder(), this.getDescriptor().isActive());
    }

    @Override
    public String candidatePackageName() {
        return this.getDescriptor().packageName();
    }

    @Override
    public boolean isAutoMappable() {
        return true;
    }

    public Iterator descriptors() {
        return new SingleElementIterator((Object)this.getDescriptor());
    }

    @Override
    public void addDescriptorsTo(Collection descriptors) {
        descriptors.add(this.getDescriptor());
    }

    @Override
    public String getAutomapSuccessfulStringKey() {
        return "AUTOMAP_DESCRIPTOR_SUCCESSFUL";
    }

    @Override
    public void unmapEntirePackage() {
        this.getPackageNode().unmap();
    }

    protected DescriptorPackageNode getPackageNode() {
        return (DescriptorPackageNode)this.getParent();
    }

    public void unmap() {
        this.getDescriptor().unmap();
    }

    @Override
    public String getName() {
        return this.getDescriptor().getName();
    }

    @Override
    public void remove() {
        this.getDescriptor().getProject().removeDescriptor(this.getDescriptor());
    }

    public MWDescriptor getDescriptor() {
        return (MWDescriptor)this.getValue();
    }

    public MWClass type() {
        return this.getDescriptor().getMWClass();
    }

    protected MWTransactionalPolicy transactionalPolicy() {
        return this.getDescriptor().getTransactionalPolicy();
    }

    @Override
    public GroupContainerDescription buildMenuDescription(WorkbenchContext context) {
        context = this.buildLocalWorkbenchContext(context);
        RootMenuDescription desc = new RootMenuDescription();
        MenuGroupDescription groupDesc = new MenuGroupDescription();
        groupDesc.add(this.getActivateDescriptorAction(context));
        if (this.supportsDescriptorMorphing()) {
            groupDesc.add(this.buildDescriptorTypeMenuDescription(context));
        }
        if (this.supportsAdvancedProperties()) {
            groupDesc.add(this.getAdvancedPolicyAction(context));
        }
        desc.add(groupDesc);
        return desc;
    }

    protected MenuDescription buildDescriptorTypeMenuDescription(WorkbenchContext workbenchContext) {
        MenuDescription menuDesc = new MenuDescription(this.resourceRepository().getString("DESCRIPTOR_TYPE_MENU_ITEM"), this.resourceRepository().getString("DESCRIPTOR_TYPE_MENU_ITEM"), this.resourceRepository().getMnemonic("DESCRIPTOR_TYPE_MENU_ITEM"), EMPTY_ICON);
        menuDesc.add(this.buildDescriptorTypeMenuGroupDescription(workbenchContext));
        return menuDesc;
    }

    protected abstract boolean supportsAdvancedProperties();

    protected FrameworkAction getAdvancedPolicyAction(WorkbenchContext context) {
        return new AdvancedPolicyAction(context);
    }

    protected abstract boolean supportsDescriptorMorphing();

    protected MenuGroupDescription buildDescriptorTypeMenuGroupDescription(WorkbenchContext workbenchContext) {
        throw new UnsupportedOperationException("This descriptor does not support morphing");
    }

    public boolean isActive() {
        return this.getDescriptor().isActive();
    }

    public boolean supportsEventsPolicy() {
        return true;
    }

    public boolean supportsInterfaceAliasPolicy() {
        return false;
    }

    public boolean supportsTransactionalDescriptorProperties() {
        return false;
    }

    public boolean isAggregateDescriptor() {
        return false;
    }

    public boolean isTableDescriptor() {
        return false;
    }
}

