/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;

public final class PackageNameDialog
extends AbstractDialog {
    protected CollectionValueModel packageNameCollectionModel;
    private PropertyValueModel packageNameHolder;
    private JComboBox packageComboBox;

    PackageNameDialog(WorkbenchContext context) {
        this(context, new SimpleCollectionValueModel());
    }

    PackageNameDialog(WorkbenchContext context, CollectionValueModel packageNameCollectionModel) {
        this(context, packageNameCollectionModel, new SimplePropertyValueModel(""));
    }

    PackageNameDialog(WorkbenchContext context, CollectionValueModel packageNameCollectionModel, PropertyValueModel packageNameHolder) {
        super(context);
        this.packageNameCollectionModel = packageNameCollectionModel;
        this.packageNameHolder = packageNameHolder;
    }

    @Override
    protected String helpTopicId() {
        return "dialog.createNewClass";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("MOVE_DESCRIPTOR_DIALOG.title"));
    }

    @Override
    protected Component buildMainPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel packageLabel = SwingComponentFactory.buildLabel("MOVE_DESCRIPTOR_DIALOG_PACKAGE", this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 0, 0);
        panel.add((Component)packageLabel, constraints);
        JComboBox packageComboBox = this.buildPackageComboBox();
        packageLabel.setLabelFor(packageComboBox);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        panel.add((Component)packageComboBox, constraints);
        return panel;
    }

    private JComboBox buildPackageComboBox() {
        JComboBox comboBox = new JComboBox();
        comboBox.setEditable(true);
        comboBox.setModel(new ComboBoxModelAdapter(this.packageNameCollectionModel, this.packageNameHolder));
        this.updatePackageComboBoxEditor(comboBox);
        return comboBox;
    }

    private void updatePackageComboBoxEditor(JComboBox comboBox) {
        ((JTextField)comboBox.getEditor().getEditorComponent()).setDocument(new RegexpDocument(1));
    }

    @Override
    protected Component initialFocusComponent() {
        return this.packageComboBox;
    }

    public String getPackageName() {
        return (String)this.packageNameHolder.getValue();
    }
}

