/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBasicExpression;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWLiteralArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWNullArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryParameterArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgument;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ArgumentPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.LiteralArgumentPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ParameterArgumentPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableArgumentPanel;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;

final class SecondArgumentPanel
extends AbstractPanel {
    private PropertyValueModel argumentHolder;
    private PropertyValueModel basicExpressionHolder;
    private PropertyValueModel argumentTypeHolder;
    private JRadioButton literalRadioButton;
    private JRadioButton queryKeyRadioButton;
    private JRadioButton parameterRadioButton;
    private JPanel emptyPanel;
    private ArgumentPanel activeArgumentPanel;
    private ParameterArgumentPanel parameterArgumentPanel;
    private QueryableArgumentPanel queryKeyArgumentPanel;
    private LiteralArgumentPanel literalArgumentPanel;
    private Map argumentTypeRadioButtonMap;
    private Map argumentTypeArgumentPanelMap;

    SecondArgumentPanel(PropertyValueModel argumentHolder, PropertyValueModel basicExpressionHolder, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.argumentHolder = argumentHolder;
        this.basicExpressionHolder = basicExpressionHolder;
        this.argumentTypeHolder = this.buildArgumentTypeHolder();
        this.initializeLayout();
        this.initializeMaps();
    }

    private void initializeMaps() {
        this.argumentTypeRadioButtonMap = new Hashtable();
        this.argumentTypeRadioButtonMap.put(MWQueryableArgument.class, this.queryKeyRadioButton);
        this.argumentTypeRadioButtonMap.put(MWLiteralArgument.class, this.literalRadioButton);
        this.argumentTypeRadioButtonMap.put(MWQueryParameterArgument.class, this.parameterRadioButton);
        this.argumentTypeArgumentPanelMap = new Hashtable();
        this.argumentTypeArgumentPanelMap.put(MWQueryableArgument.class, this.queryKeyArgumentPanel);
        this.argumentTypeArgumentPanelMap.put(MWLiteralArgument.class, this.literalArgumentPanel);
        this.argumentTypeArgumentPanelMap.put(MWNullArgument.class, this.literalArgumentPanel);
        this.argumentTypeArgumentPanelMap.put(MWQueryParameterArgument.class, this.parameterArgumentPanel);
    }

    private MWArgument getArgument() {
        return (MWArgument)this.argumentHolder.getValue();
    }

    private ValueModel buildNullArgumentBooleanHolder() {
        return new PropertyAspectAdapter(this.argumentHolder){

            @Override
            protected Object getValueFromSubject() {
                return !(this.subject instanceof MWNullArgument);
            }
        };
    }

    private void initializeLayout() {
        this.argumentHolder.addPropertyChangeListener("value", this.buildArgumentListener());
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        ArrayList<JRadioButton> enablingComponents = new ArrayList<JRadioButton>();
        AccessibleTitledPanel radioButtonPanel = new AccessibleTitledPanel(new GridBagLayout());
        int gridY = 0;
        this.literalRadioButton = this.buildRadioButton("LITERAL_RADIO_BUTTON_ON_SECOND_ARGUMENT_PANEL", this.buildRadioButtonModelAdapter("literal", true));
        enablingComponents.add(this.literalRadioButton);
        constraints.gridx = 0;
        constraints.gridy = gridY++;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 5, 0, 5);
        radioButtonPanel.add((Component)this.literalRadioButton, constraints);
        this.queryKeyRadioButton = this.buildRadioButton("QUERY_KEY_RADIO_BUTTON_ON_SECOND_ARGUMENT_PANEL", this.buildRadioButtonModelAdapter("queryKey", false));
        enablingComponents.add(this.queryKeyRadioButton);
        constraints.gridx = 0;
        constraints.gridy = gridY++;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 5, 0, 5);
        radioButtonPanel.add((Component)this.queryKeyRadioButton, constraints);
        this.parameterRadioButton = this.buildRadioButton("PARAMETER_RADIO_BUTTON_ON_SECOND_ARGUMENT_PANEL", this.buildRadioButtonModelAdapter("parameter", false));
        enablingComponents.add(this.parameterRadioButton);
        constraints.gridx = 0;
        constraints.gridy = gridY++;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 5, 0, 5);
        radioButtonPanel.add((Component)this.parameterRadioButton, constraints);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)radioButtonPanel, constraints);
        this.emptyPanel = new JPanel();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.emptyPanel, constraints);
        this.parameterArgumentPanel = new ParameterArgumentPanel(this.argumentHolder, this.getWorkbenchContextHolder(), enablingComponents);
        this.literalArgumentPanel = new LiteralArgumentPanel(this.argumentHolder, this.getWorkbenchContextHolder(), enablingComponents);
        this.queryKeyArgumentPanel = new QueryableArgumentPanel(this.argumentHolder, this.getWorkbenchContextHolder(), enablingComponents);
        this.setActiveArgumentPanel(this.literalArgumentPanel);
        new ComponentEnabler(this.buildNullArgumentBooleanHolder(), enablingComponents);
    }

    private void setActiveArgumentPanel(ArgumentPanel newArgumentPanel) {
        ArgumentPanel oldActiveArgumentPanel = this.activeArgumentPanel;
        if (newArgumentPanel == oldActiveArgumentPanel) {
            return;
        }
        this.activeArgumentPanel = newArgumentPanel;
        if (oldActiveArgumentPanel != null) {
            this.emptyPanel.remove(oldActiveArgumentPanel);
        }
        GridBagConstraints constraints = new GridBagConstraints();
        this.emptyPanel.setLayout(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 5, 0, 5);
        this.emptyPanel.add((Component)this.activeArgumentPanel, constraints);
        this.revalidate();
        this.repaint();
    }

    private PropertyChangeListener buildArgumentListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SecondArgumentPanel.this.updateActiveArgumentPanel();
            }
        };
    }

    private void updateActiveArgumentPanel() {
        MWArgument argument = this.getArgument();
        if (argument != null) {
            this.setActiveArgumentPanel((ArgumentPanel)this.argumentTypeArgumentPanelMap.get(argument.getClass()));
        } else {
            this.setActiveArgumentPanel(this.literalArgumentPanel);
        }
    }

    private ButtonModel buildRadioButtonModelAdapter(String argumentType, boolean defaultValue) {
        return new RadioButtonModelAdapter(this.argumentTypeHolder, argumentType, defaultValue);
    }

    private PropertyValueModel buildArgumentTypeHolder() {
        PropertyAspectAdapter adapter = new PropertyAspectAdapter(this.basicExpressionHolder, "secondArgument"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWBasicExpression)this.subject).getSecondArgument();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                if (value == "literal") {
                    ((MWBasicExpression)this.subject).setSecondArgumentToLiteral();
                } else if (value == "queryKey") {
                    ((MWBasicExpression)this.subject).setSecondArgumentToQueryable();
                } else if (value == "parameter") {
                    ((MWBasicExpression)this.subject).setSecondArgumentToParameter();
                }
            }
        };
        return new TransformationPropertyValueModel(adapter){

            @Override
            protected Object transform(Object value) {
                if (value == null) {
                    return null;
                }
                return ((MWArgument)value).getType();
            }
        };
    }
}

