/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.WaitDialog;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceSpecification;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.UiSchemaResourceBundle;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class SchemaDialogUtilities {
    private static ResourceRepository resourceRepository;

    SchemaDialogUtilities() {
    }

    private static ResourceRepository resourceRepository() {
        if (resourceRepository == null) {
            resourceRepository = SchemaDialogUtilities.buildResourceRepository();
        }
        return resourceRepository;
    }

    private static ResourceRepository buildResourceRepository() {
        return new DefaultResourceRepository(UiSchemaResourceBundle.class);
    }

    static void showUrlLoadFailure(Component parentComponent, String schemaName, ResourceException re, ResourceSpecification rs) {
        SchemaDialogUtilities.showUrlLoadFailure(parentComponent, schemaName, re, rs.getSourceKey(), rs.getLocation());
    }

    static void showUrlLoadFailure(Component parentComponent, String schemaName, ResourceException re, String resourceType, String resourceName) {
        String errorTitle = SchemaDialogUtilities.resourceRepository().getString("URL_LOAD_ERROR.TITLE");
        String errorCode = re.getCode();
        String errorMessage = SchemaDialogUtilities.resourceRepository().getString("URL_LOAD_ERROR.MESSAGE", schemaName);
        errorMessage = errorMessage + StringTools.CR;
        errorMessage = errorMessage + SchemaDialogUtilities.resourceRepository().getString("URL_LOAD_ERROR." + resourceType + "." + errorCode, new Object[]{resourceName});
        JOptionPane.showMessageDialog(parentComponent, errorMessage, errorTitle, 2);
    }

    static void showSchemaLoadFailure(Component parentComponent, String schemaName) {
        SchemaDialogUtilities.showSchemaLoadFailure(parentComponent, schemaName, null);
    }

    static void showSchemaLoadFailure(Component parentComponent, String schemaName, RuntimeException ex) {
        SchemaDialogUtilities.showSchemaLoadFailure(parentComponent, schemaName, (Exception)ex);
    }

    private static void showSchemaLoadFailure(Component parentComponent, String schemaName, Exception ex) {
        String errorTitle = SchemaDialogUtilities.resourceRepository().getString("SCHEMA_LOAD_ERROR.TITLE");
        String exceptionMessage = ex.getLocalizedMessage();
        String errorMessage = SchemaDialogUtilities.resourceRepository().getString("SCHEMA_LOAD_ERROR.MESSAGE", StringTools.CR, schemaName, exceptionMessage);
        LabelArea label = new LabelArea(errorMessage);
        JOptionPane.showMessageDialog(parentComponent, label, errorTitle, 2);
    }

    static void reloadSchemas(WorkbenchContext context, Iterator schemasIterator) {
        Thread thread = new Thread((Runnable)new ReloadAllSchemasRunnable(context, schemasIterator), "XML Schema  Importation");
        thread.setPriority(3);
        thread.start();
    }

    private static class ReloadAllSchemasRunnable
    implements Runnable {
        private WorkbenchContext context;
        private WaitDialog waitDialog;
        private Iterator schemasIterator;
        private MWXmlSchema[] currentSchema;

        ReloadAllSchemasRunnable(WorkbenchContext context, Iterator schemasIterator) {
            this.initialize(context, schemasIterator);
        }

        private void initialize(WorkbenchContext context, Iterator schemasIterator) {
            this.currentSchema = new MWXmlSchema[1];
            this.context = context;
            this.schemasIterator = schemasIterator;
            this.waitDialog = new WaitDialog((Frame)context.getCurrentWindow(), context.getApplicationContext().getResourceRepository().getIcon("file.xml.large"), SchemaDialogUtilities.resourceRepository().getString("IMPORT_SCHEMA_DIALOG.WAIT_DIALOG.TITLE"), SchemaDialogUtilities.resourceRepository().getString("IMPORT_SCHEMA_DIALOG.WAIT_DIALOG.DESCRIPTION", ""));
        }

        private void showWaitCursor() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReloadAllSchemasRunnable.this.context.getCurrentWindow().setCursor(Cursor.getPredefinedCursor(3));
                }
            });
        }

        private void hideWaitCursor() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReloadAllSchemasRunnable.this.context.getCurrentWindow().setCursor(Cursor.getDefaultCursor());
                }
            });
        }

        private void updateMessage() throws InvocationTargetException, InterruptedException {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    String text = SchemaDialogUtilities.resourceRepository().getString("IMPORT_SCHEMA_DIALOG.WAIT_DIALOG.DESCRIPTION", ReloadAllSchemasRunnable.this.currentSchema[0].getName());
                    ReloadAllSchemasRunnable.this.waitDialog.setMessage(text);
                }
            });
        }

        private Runnable buildWaitDialogLauncher() {
            return new Runnable(){

                @Override
                public void run() {
                    ReloadAllSchemasRunnable.this.waitDialog.setVisible(true);
                }
            };
        }

        @Override
        public void run() {
            try {
                if (this.currentSchema[0] == null) {
                    this.showWaitCursor();
                }
                EventQueue.invokeLater(this.buildWaitDialogLauncher());
                while (this.schemasIterator.hasNext()) {
                    this.currentSchema[0] = (MWXmlSchema)this.schemasIterator.next();
                    this.updateMessage();
                    this.currentSchema[0].reload();
                }
                this.waitDialog.dispose();
            }
            catch (InvocationTargetException exception) {
                this.waitDialog.dispose();
                throw new RuntimeException(exception);
            }
            catch (InterruptedException exception) {
                this.waitDialog.dispose();
                throw new RuntimeException(exception);
            }
            catch (ResourceException re) {
                this.waitDialog.dispose();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SchemaDialogUtilities.showUrlLoadFailure(ReloadAllSchemasRunnable.this.context.getCurrentWindow(), ReloadAllSchemasRunnable.this.currentSchema[0].getName(), re, ReloadAllSchemasRunnable.this.currentSchema[0].getSchemaSource());
                    }
                });
                this.run();
            }
            catch (RuntimeException re) {
                this.waitDialog.dispose();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SchemaDialogUtilities.showSchemaLoadFailure((Component)ReloadAllSchemasRunnable.this.context.getCurrentWindow(), ReloadAllSchemasRunnable.this.currentSchema[0].getName(), re);
                    }
                });
                this.run();
            }
            this.hideWaitCursor();
        }
    }
}

