/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.node;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.persistence.tools.workbench.utility.SynchronizedBoolean;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public class RunnableValidation
implements Runnable {
    private Node node;
    private SynchronizedBoolean validateFlag;
    private SynchronizedBoolean continueFlag;
    private Logger exceptionLogger;
    private Level exceptionLevel;
    private String exceptionMessage;

    public RunnableValidation(Node node, SynchronizedBoolean validateFlag, SynchronizedBoolean continueFlag, Logger exceptionLogger, Level exceptionLevel, String exceptionMessage) {
        this.node = node;
        this.validateFlag = validateFlag;
        this.continueFlag = continueFlag;
        this.exceptionLogger = exceptionLogger;
        this.exceptionLevel = exceptionLevel;
        this.exceptionMessage = exceptionMessage;
    }

    @Override
    public void run() {
        while (this.continueFlag.isTrue()) {
            try {
                this.validateFlag.waitToSetFalse();
            }
            catch (InterruptedException ex) {
                return;
            }
            this.validateNode();
        }
    }

    private void validateNode() {
        try {
            this.node.validateBranch();
        }
        catch (Throwable ex) {
            this.logException(ex);
        }
    }

    private void logException(Throwable ex) {
        LogRecord logRecord = new LogRecord(this.exceptionLevel, this.exceptionMessage);
        logRecord.setParameters(new Object[]{this.node.displayString()});
        logRecord.setThrown(ex);
        logRecord.setLoggerName(this.exceptionLogger.getName());
        logRecord.setResourceBundle(this.exceptionLogger.getResourceBundle());
        this.exceptionLogger.log(logRecord);
    }
}

