/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.optimizer;

import java.util.Arrays;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.Handle;

class Constant {
    char type;
    int intVal;
    long longVal;
    float floatVal;
    double doubleVal;
    String strVal1;
    String strVal2;
    Object objVal3;
    Object[] objVals;
    int hashCode;

    Constant() {
    }

    Constant(Constant constant) {
        this.type = constant.type;
        this.intVal = constant.intVal;
        this.longVal = constant.longVal;
        this.floatVal = constant.floatVal;
        this.doubleVal = constant.doubleVal;
        this.strVal1 = constant.strVal1;
        this.strVal2 = constant.strVal2;
        this.objVal3 = constant.objVal3;
        this.objVals = constant.objVals;
        this.hashCode = constant.hashCode;
    }

    void set(int n) {
        this.type = (char)73;
        this.intVal = n;
        this.hashCode = Integer.MAX_VALUE & this.type + n;
    }

    void set(long l) {
        this.type = (char)74;
        this.longVal = l;
        this.hashCode = Integer.MAX_VALUE & this.type + (int)l;
    }

    void set(float f) {
        this.type = (char)70;
        this.floatVal = f;
        this.hashCode = Integer.MAX_VALUE & this.type + (int)f;
    }

    void set(double d) {
        this.type = (char)68;
        this.doubleVal = d;
        this.hashCode = Integer.MAX_VALUE & this.type + (int)d;
    }

    void set(char c, String string, String string2, String string3) {
        this.type = c;
        this.strVal1 = string;
        this.strVal2 = string2;
        this.objVal3 = string3;
        switch (c) {
            case 'C': 
            case 'S': 
            case 's': 
            case 't': {
                this.hashCode = Integer.MAX_VALUE & c + string.hashCode();
                return;
            }
            case 'T': {
                this.hashCode = Integer.MAX_VALUE & c + string.hashCode() * string2.hashCode();
                return;
            }
        }
        this.hashCode = Integer.MAX_VALUE & c + string.hashCode() * string2.hashCode() * string3.hashCode();
    }

    void set(String string, String string2, Handle handle, Object[] objectArray) {
        this.type = (char)121;
        this.strVal1 = string;
        this.strVal2 = string2;
        this.objVal3 = handle;
        this.objVals = objectArray;
        int n = 121 + string.hashCode() * string2.hashCode() * handle.hashCode();
        for (int i = 0; i < objectArray.length; ++i) {
            n *= objectArray[i].hashCode();
        }
        this.hashCode = Integer.MAX_VALUE & n;
    }

    void write(ClassWriter classWriter) {
        switch (this.type) {
            case 'I': {
                classWriter.newConst(this.intVal);
                break;
            }
            case 'J': {
                classWriter.newConst(this.longVal);
                break;
            }
            case 'F': {
                classWriter.newConst(Float.valueOf(this.floatVal));
                break;
            }
            case 'D': {
                classWriter.newConst(this.doubleVal);
                break;
            }
            case 'S': {
                classWriter.newConst(this.strVal1);
                break;
            }
            case 's': {
                classWriter.newUTF8(this.strVal1);
                break;
            }
            case 'C': {
                classWriter.newClass(this.strVal1);
                break;
            }
            case 'T': {
                classWriter.newNameType(this.strVal1, this.strVal2);
                break;
            }
            case 'G': {
                classWriter.newField(this.strVal1, this.strVal2, (String)this.objVal3);
                break;
            }
            case 'M': {
                classWriter.newMethod(this.strVal1, this.strVal2, (String)this.objVal3, false);
                break;
            }
            case 'N': {
                classWriter.newMethod(this.strVal1, this.strVal2, (String)this.objVal3, true);
                break;
            }
            case 'y': {
                classWriter.newInvokeDynamic(this.strVal1, this.strVal2, (Handle)this.objVal3, this.objVals);
                break;
            }
            case 't': {
                classWriter.newMethodType(this.strVal1);
                break;
            }
            default: {
                classWriter.newHandle(this.type - 104 + 1 - (this.type >= 'q' ? 4 : 0), this.strVal1, this.strVal2, (String)this.objVal3, this.type >= 'p');
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Constant)) {
            return false;
        }
        Constant constant = (Constant)object;
        if (constant.type == this.type) {
            switch (this.type) {
                case 'I': {
                    return constant.intVal == this.intVal;
                }
                case 'J': {
                    return constant.longVal == this.longVal;
                }
                case 'F': {
                    return Float.compare(constant.floatVal, this.floatVal) == 0;
                }
                case 'D': {
                    return Double.compare(constant.doubleVal, this.doubleVal) == 0;
                }
                case 'C': 
                case 'S': 
                case 's': 
                case 't': {
                    return constant.strVal1.equals(this.strVal1);
                }
                case 'T': {
                    return constant.strVal1.equals(this.strVal1) && constant.strVal2.equals(this.strVal2);
                }
                case 'y': {
                    return constant.strVal1.equals(this.strVal1) && constant.strVal2.equals(this.strVal2) && constant.objVal3.equals(this.objVal3) && Arrays.equals(constant.objVals, this.objVals);
                }
            }
            return constant.strVal1.equals(this.strVal1) && constant.strVal2.equals(this.strVal2) && constant.objVal3.equals(this.objVal3);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

