/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.optimizer;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.persistence.internal.libraries.asm.Type;

public class NameMapping {
    public final Properties mapping = new Properties();
    public final Set<Object> unused;

    public NameMapping(String string) throws IOException {
        try (InputStream inputStream = null;){
            inputStream = new BufferedInputStream(new FileInputStream(string));
            this.mapping.load(inputStream);
            this.unused = new HashSet<Object>(this.mapping.keySet());
        }
    }

    public String map(String string) {
        String string2 = (String)this.mapping.get(string);
        if (string2 == null) {
            int n;
            int n2 = string.indexOf(46);
            string2 = n2 == -1 ? string : ((n = string.indexOf(40)) == -1 ? string.substring(n2 + 1) : string.substring(n2 + 1, n));
        } else {
            this.unused.remove(string);
        }
        return string2;
    }

    public String fix(String string) {
        if (string.startsWith("(")) {
            Type[] typeArray = Type.getArgumentTypes(string);
            Type type = Type.getReturnType(string);
            for (int i = 0; i < typeArray.length; ++i) {
                typeArray[i] = this.fix(typeArray[i]);
            }
            type = this.fix(type);
            return Type.getMethodDescriptor(type, typeArray);
        }
        return this.fix(Type.getType(string)).getDescriptor();
    }

    private Type fix(Type type) {
        if (type.getSort() == 10) {
            return Type.getObjectType(this.map(type.getInternalName()));
        }
        if (type.getSort() == 9) {
            String string = this.fix(type.getElementType()).getDescriptor();
            for (int i = 0; i < type.getDimensions(); ++i) {
                string = '[' + string;
            }
            return Type.getType(string);
        }
        return type;
    }
}

