/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.partitioning;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;

public class RangePartition {
    protected String endValueName;
    protected String startValueName;
    protected String partitionValueTypeName;
    protected String connectionPool;
    protected Class partitionValueType;
    protected Comparable startValue;
    protected Comparable endValue;

    public RangePartition() {
    }

    public RangePartition(String connectionPool, String partitionValueTypeName, String startValueName, String endValueName) {
        this.connectionPool = connectionPool;
        this.endValue = null;
        this.endValueName = endValueName;
        this.startValue = null;
        this.startValueName = startValueName;
        this.partitionValueTypeName = partitionValueTypeName;
    }

    public RangePartition(String connectionPool, Comparable startValue, Comparable endValue) {
        this.connectionPool = connectionPool;
        this.startValue = startValue;
        this.endValue = endValue;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        block9: {
            if (this.partitionValueType == null && this.partitionValueTypeName != null) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            this.partitionValueType = AccessController.doPrivileged(new PrivilegedClassForName(this.partitionValueTypeName, true, classLoader));
                            break block9;
                        }
                        catch (PrivilegedActionException e) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.partitionValueTypeName, e.getException());
                        }
                    }
                    this.partitionValueType = PrivilegedAccessHelper.getClassForName(this.partitionValueTypeName, true, classLoader);
                }
                catch (Exception exception) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.partitionValueTypeName, exception);
                }
            }
        }
        if (this.partitionValueType != null) {
            if (this.startValueName != null) {
                this.startValue = (Comparable)this.initObject(this.partitionValueType, this.startValueName);
            }
            if (this.endValueName != null) {
                this.endValue = (Comparable)this.initObject(this.partitionValueType, this.endValueName);
            }
        }
    }

    public Comparable getStartValue() {
        return this.startValue;
    }

    protected Object initObject(Class type, String value) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                Constructor constructor = AccessController.doPrivileged(new PrivilegedGetConstructorFor(type, new Class[]{String.class}, false));
                return AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[]{value}));
            }
            catch (PrivilegedActionException privilegedActionException) {}
        } else {
            try {
                Constructor constructor = PrivilegedAccessHelper.getConstructorFor(type, new Class[]{String.class}, false);
                return PrivilegedAccessHelper.invokeConstructor(constructor, new Object[]{value});
            }
            catch (Exception exception) {}
        }
        return value;
    }

    public void setStartValue(Comparable startValue) {
        this.startValue = startValue;
    }

    public Comparable getEndValue() {
        return this.endValue;
    }

    public void setEndValue(Comparable endValue) {
        this.endValue = endValue;
    }

    public String getConnectionPool() {
        return this.connectionPool;
    }

    public void setConnectionPool(String connectionPool) {
        this.connectionPool = connectionPool;
    }

    public boolean isInRange(Object value) {
        if (this.startValue != null && this.startValue.compareTo(value) > 0) {
            return false;
        }
        return this.endValue == null || this.endValue.compareTo(value) >= 0;
    }
}

