/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced.multitenant;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.MultitenantPolicy;
import org.eclipse.persistence.descriptors.SchemaPerMultitenantPolicy;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCaseHelper;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Customer;
import org.eclipse.persistence.testing.tests.feature.TestDataSource;

public class AdvancedMultiTenantSchemaJunitTest
extends JUnitTestCase {
    private static boolean skipTest = false;
    private static Properties emfProperties;
    private static ProxyDS proxyDataSource;
    private static String schema1;
    private static String schema2;
    private EntityManagerFactory emf;

    public AdvancedMultiTenantSchemaJunitTest() {
    }

    public AdvancedMultiTenantSchemaJunitTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("AdvancedMultiTenantSchemaJunitTest");
        suite.addTest((Test)new AdvancedMultiTenantSchemaJunitTest("testSetup"));
        suite.addTest((Test)new AdvancedMultiTenantSchemaJunitTest("testPolicyConfigurationDefault"));
        suite.addTest((Test)new AdvancedMultiTenantSchemaJunitTest("testPolicyConfigurationCustom"));
        suite.addTest((Test)new AdvancedMultiTenantSchemaJunitTest("testSequencing"));
        suite.addTest((Test)new AdvancedMultiTenantSchemaJunitTest("testCleanup"));
        return suite;
    }

    public String getPersistenceUnitName() {
        return "multi-tenant-schema-per-tenant";
    }

    public void tearDown() {
        if (this.emf != null && this.emf.isOpen()) {
            this.emf.close();
        }
        if (schema1 != null) {
            try {
                this.getDatabaseSession().executeNonSelectingSQL("use " + schema1 + ";");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetup() {
        if (!this.getPlatform().isMySQL()) {
            AdvancedMultiTenantSchemaJunitTest.warning((String)"this test is supported on MySQL only");
            return;
        }
        DatabaseSessionImpl databaseSession = this.getDatabaseSession();
        DatabaseLogin login = this.getDatabaseSession().getLogin();
        schema1 = login.getConnectionString().substring(login.getConnectionString().lastIndexOf(47) + 1);
        schema2 = schema1 + "_MT";
        AdvancedMultiTenantSchemaJunitTest.assertNotNull((Object)schema1);
        AdvancedMultiTenantSchemaJunitTest.assertNotNull((Object)schema2);
        databaseSession.executeNonSelectingSQL("use " + schema1 + ";");
        try {
            databaseSession.executeNonSelectingSQL("drop schema " + schema2 + ";");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            databaseSession.executeNonSelectingSQL("create schema " + schema2 + ";");
        }
        catch (Throwable t) {
            skipTest = true;
            AdvancedMultiTenantSchemaJunitTest.warning((String)"Cannot create additional schema to run related tests.");
            databaseSession.logThrowable(6, "connection", t);
            return;
        }
        finally {
            databaseSession.logout();
        }
        Map currentProps = JUnitTestCaseHelper.getDatabaseProperties((String)this.getPersistenceUnitName());
        TestDataSource ds1 = new TestDataSource(login.getDriverClassName(), login.getConnectionString(), (Properties)login.getProperties().clone());
        TestDataSource ds2 = new TestDataSource(login.getDriverClassName(), login.getConnectionString() + "_MT", (Properties)login.getProperties().clone());
        proxyDataSource = new ProxyDS((DatabaseSession)databaseSession, (String)currentProps.get("javax.persistence.jdbc.user"), (String)currentProps.get("javax.persistence.jdbc.password"));
        proxyDataSource.add(schema1, ds1);
        proxyDataSource.add(schema2, ds2);
        emfProperties = new Properties();
        emfProperties.putAll((Map<?, ?>)currentProps);
        emfProperties.remove("javax.persistence.jdbc.driver");
        emfProperties.remove("javax.persistence.jdbc.user");
        emfProperties.remove("javax.persistence.jdbc.url");
        emfProperties.remove("javax.persistence.jdbc.password");
        emfProperties.put("javax.persistence.nonJtaDataSource", proxyDataSource);
        emfProperties.put("eclipselink.ddl-generation", "none");
        emfProperties.put("eclipselink.multitenant.strategy", "external");
        proxyDataSource.setCurrentDS(schema1);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)emfProperties);
        AdvancedMultiTenantSchemaJunitTest.assertNotNull((Object)emf);
        new AdvancedTableCreator().replaceTables((DatabaseSession)((EntityManagerFactoryImpl)emf).getServerSession());
        emf.close();
        proxyDataSource.setCurrentDS(schema2);
        emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)emfProperties);
        AdvancedMultiTenantSchemaJunitTest.assertNotNull((Object)emf);
        new AdvancedTableCreator().replaceTables((DatabaseSession)((EntityManagerFactoryImpl)emf).getServerSession());
        emf.close();
    }

    public void testPolicyConfigurationDefault() {
        if (!this.getPlatform().isMySQL()) {
            AdvancedMultiTenantSchemaJunitTest.warning((String)"this test is supported on MySQL only");
            return;
        }
        if (skipTest) {
            AdvancedMultiTenantSchemaJunitTest.warning((String)"this test requires DB schema created in testSetup to be available.");
            return;
        }
        this.emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)emfProperties);
        ServerSession session = ((EntityManagerFactoryImpl)this.emf).getServerSession();
        MultitenantPolicy policy = session.getProject().getMultitenantPolicy();
        AdvancedMultiTenantSchemaJunitTest.assertNotNull((String)"project MultitenantPolicy is null", (Object)policy);
        AdvancedMultiTenantSchemaJunitTest.assertTrue((String)"not SchemaPerMultitenantPolicy", (boolean)policy.isSchemaPerMultitenantPolicy());
        AdvancedMultiTenantSchemaJunitTest.assertTrue((String)"not shared EMF", (boolean)((SchemaPerMultitenantPolicy)policy).shouldUseSharedEMF());
        AdvancedMultiTenantSchemaJunitTest.assertFalse((String)"shared cache", (boolean)((SchemaPerMultitenantPolicy)policy).shouldUseSharedCache());
        AdvancedMultiTenantSchemaJunitTest.assertEquals((String)"eclipselink.tenant-schema-id", (String)((SchemaPerMultitenantPolicy)policy).getContextProperty());
        AdvancedMultiTenantSchemaJunitTest.assertEquals((String)"eclipselink.tenant-schema-id", (String)((SchemaPerMultitenantPolicy)policy).getContextProperty());
        AdvancedMultiTenantSchemaJunitTest.assertTrue((String)"unknown context property", (boolean)session.getMultitenantContextProperties().contains("eclipselink.tenant-schema-id"));
    }

    public void testPolicyConfigurationCustom() {
        if (!this.getPlatform().isMySQL()) {
            AdvancedMultiTenantSchemaJunitTest.warning((String)"this test is supported on MySQL only");
            return;
        }
        if (skipTest) {
            AdvancedMultiTenantSchemaJunitTest.warning((String)"this test requires DB schema created in testSetup to be available.");
            return;
        }
        Properties emfP = new Properties();
        emfP.putAll((Map<?, ?>)emfProperties);
        emfP.put("eclipselink.tenant-schema-id", "not-shared");
        emfP.put("eclipselink.multitenant.tenants-share-emf", "false");
        emfP.put("eclipselink.multitenant.tenants-share-cache", "true");
        this.emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)emfP);
        ServerSession session = ((EntityManagerFactoryImpl)this.emf).getServerSession();
        MultitenantPolicy policy = session.getProject().getMultitenantPolicy();
        AdvancedMultiTenantSchemaJunitTest.assertNotNull((String)"project MultitenantPolicy is null", (Object)policy);
        AdvancedMultiTenantSchemaJunitTest.assertTrue((String)"not SchemaPerMultitenantPolicy", (boolean)policy.isSchemaPerMultitenantPolicy());
        AdvancedMultiTenantSchemaJunitTest.assertFalse((String)"shared EMF", (boolean)((SchemaPerMultitenantPolicy)policy).shouldUseSharedEMF());
        AdvancedMultiTenantSchemaJunitTest.assertTrue((String)"not shared cache", (boolean)((SchemaPerMultitenantPolicy)policy).shouldUseSharedCache());
        AdvancedMultiTenantSchemaJunitTest.assertEquals((String)"eclipselink.tenant-schema-id", (String)((SchemaPerMultitenantPolicy)policy).getContextProperty());
        AdvancedMultiTenantSchemaJunitTest.assertEquals((String)"eclipselink.tenant-schema-id", (String)((SchemaPerMultitenantPolicy)policy).getContextProperty());
        AdvancedMultiTenantSchemaJunitTest.assertTrue((String)"unknown context property", (boolean)session.getMultitenantContextProperties().contains("eclipselink.tenant-schema-id"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSequencing() {
        if (!this.getPlatform().isMySQL()) {
            AdvancedMultiTenantSchemaJunitTest.warning((String)"this test is supported on MySQL only");
            return;
        }
        if (skipTest) {
            AdvancedMultiTenantSchemaJunitTest.warning((String)"this test requires DB schema created in testSetup to be available.");
            return;
        }
        this.emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)emfProperties);
        Customer customer1 = new Customer();
        customer1.setLastName("Simpson");
        customer1.setFirstName("Bart");
        Customer customer1a = new Customer();
        customer1a.setLastName("Simpson");
        customer1a.setFirstName("Homer");
        proxyDataSource.setCurrentDS(schema1);
        Properties props1 = new Properties();
        props1.put("eclipselink.tenant-schema-id", "Simpsons");
        em1.getTransaction().begin();
        try (EntityManager em1 = this.emf.createEntityManager((Map)props1);){
            em1.persist((Object)customer1);
            em1.persist((Object)customer1a);
            em1.getTransaction().commit();
        }
        int id1 = customer1.getId();
        int id1a = customer1a.getId();
        Customer customer2 = new Customer();
        customer2.setLastName("Cooper");
        customer2.setFirstName("Sheldon");
        Customer customer2a = new Customer();
        customer2a.setLastName("Hofstadter");
        customer2a.setFirstName("Leonard");
        proxyDataSource.setCurrentDS(schema2);
        Properties props2 = new Properties();
        props2.put("eclipselink.tenant-schema-id", "TBBT");
        em2.getTransaction().begin();
        try (EntityManager em2 = this.emf.createEntityManager((Map)props2);){
            em2.persist((Object)customer2);
            em2.persist((Object)customer2a);
            em2.getTransaction().commit();
        }
        int id2 = customer2.getId();
        int id2a = customer2a.getId();
        AdvancedMultiTenantSchemaJunitTest.assertEquals((int)50, (int)id2);
        AdvancedMultiTenantSchemaJunitTest.assertEquals((int)51, (int)id2a);
        AdvancedMultiTenantSchemaJunitTest.assertEquals((String)"IDs should grow by 1", (int)(id1 + 1), (int)id1a);
        AdvancedMultiTenantSchemaJunitTest.assertEquals((String)"IDs should grow by 1", (int)(id2 + 1), (int)id2a);
    }

    public void testCleanup() {
        try {
            AdvancedMultiTenantSchemaJunitTest.getDatabaseSession((String)this.getPersistenceUnitName()).executeNonSelectingSQL("drop schema " + schema2 + ";");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static final class ProxyDS
    implements DataSource {
        private final Map<String, TestDataSource> datasources = new HashMap<String, TestDataSource>();
        private DataSource currentDS;
        private DatabaseSession session;
        private final String userName;
        private final String pwd;

        public ProxyDS(DatabaseSession session, String userName, String pwd) {
            this.session = session;
            this.userName = userName;
            this.pwd = pwd;
        }

        public void add(String key, TestDataSource ds) {
            this.datasources.put(key, ds);
            this.currentDS = ds;
        }

        public void setCurrentDS(String key) {
            this.session.executeNonSelectingSQL("use " + key + "");
            this.currentDS = (DataSource)this.datasources.get(key);
        }

        public DataSource getCurrentDS() {
            return this.currentDS;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.getConnection(this.userName, this.pwd);
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return this.currentDS.getConnection(username, password);
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.currentDS.getLogWriter();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.currentDS.setLogWriter(out);
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.currentDS.setLoginTimeout(seconds);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.currentDS.getLoginTimeout();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return this.currentDS.getParentLogger();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.currentDS.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.currentDS.isWrapperFor(iface);
        }
    }
}

