/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.prefs.Preferences;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.Application;
import org.eclipse.persistence.tools.workbench.framework.NodeManager;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.DefaultWorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.context.PreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.ComponentAligner;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;

public abstract class AbstractPanel
extends AccessibleTitledPanel {
    private ComponentAligner alignLeftGroup;
    private ComponentAligner alignRightGroup;
    private WorkbenchContextHolder workbenchContextHolder;

    protected AbstractPanel(ApplicationContext context) {
        this((LayoutManager)new GridBagLayout(), context);
    }

    protected AbstractPanel(LayoutManager layoutManager, ApplicationContext context) {
        this(layoutManager, new DefaultWorkbenchContextHolder(context));
    }

    protected AbstractPanel(WorkbenchContextHolder contextHolder) {
        this((LayoutManager)new GridBagLayout(), contextHolder);
    }

    protected AbstractPanel(LayoutManager layoutManager, WorkbenchContextHolder contextHolder) {
        super(layoutManager);
        this.workbenchContextHolder = contextHolder;
    }

    protected final void addAlignLeft(ComponentAligner group) {
        this.getAlignLeftGroup().add(group);
    }

    protected final void addAlignLeft(JComponent component) {
        this.getAlignLeftGroup().add(component);
    }

    protected final void addAlignRight(ComponentAligner group) {
        this.getAlignRightGroup().add(group);
    }

    protected final void addAlignRight(JComponent component) {
        this.getAlignRightGroup().add(component);
    }

    protected final void addHelpTopicId(Component component, String topicId) {
        this.helpManager().addTopicID(component, topicId);
    }

    protected final void addPaneForAlignLeft(AbstractPanel page) {
        this.getAlignLeftGroup().add(page.getAlignLeftGroup());
    }

    protected final void addPaneForAlignment(AbstractPanel panel) {
        this.addPaneForAlignLeft(panel);
        this.addPaneForAlignRight(panel);
    }

    protected final void addPaneForAlignRight(AbstractPanel page) {
        this.getAlignRightGroup().add(page.getAlignRightGroup());
    }

    protected final JButton buildButton(String key) {
        return SwingComponentFactory.buildButton(key, this.resourceRepository());
    }

    protected final JButton buildBrowseButton(String key, Accessible labeler) {
        return SwingComponentFactory.buildBrowseButton(key, this.resourceRepository(), labeler);
    }

    protected final JCheckBox buildCheckBox(String key, ButtonModel buttonModel) {
        return SwingComponentFactory.buildCheckBox(key, buttonModel, this.resourceRepository());
    }

    protected final JLabel buildLabel(String key) {
        return SwingComponentFactory.buildLabel(key, this.resourceRepository());
    }

    protected final JComponent buildLabeledComboBox(String key, ComboBoxModel model) {
        return this.buildLabeledComboBoxImp(key, model, null, false);
    }

    protected final JComponent buildLabeledComboBox(String key, ComboBoxModel model, ListCellRenderer renderer) {
        return this.buildLabeledComboBoxImp(key, model, renderer, false);
    }

    private JComponent buildLabeledComboBoxImp(String key, ComboBoxModel model, ListCellRenderer renderer, boolean editable) {
        JComboBox comboBox = new JComboBox(model);
        comboBox.setEditable(editable);
        if (renderer != null) {
            comboBox.setRenderer(renderer);
        }
        return this.buildLabeledComponent(key, comboBox);
    }

    protected final JComponent buildLabeledComponent(String key, JComponent component) {
        return this.buildLabeledComponent(key, component, new Spacer());
    }

    protected JComponent buildLabeledComponent(String key, JComponent component, JComponent rightComponent) {
        GridBagConstraints constraints = new GridBagConstraints();
        Pane pane = new Pane(new GridBagLayout());
        JLabel label = this.buildLabel(key);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        pane.add((Component)label, constraints);
        this.addAlignLeft(label);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        pane.add((Component)component, constraints);
        component.setName(key);
        label.setLabelFor(component);
        if (rightComponent != null) {
            constraints.gridx = 2;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 21;
            constraints.insets = new Insets(0, 5, 0, 0);
            pane.add((Component)rightComponent, constraints);
            rightComponent.setName(key);
            this.addAlignRight(rightComponent);
            if (rightComponent instanceof AbstractButton) {
                SwingComponentFactory.updateButtonAccessibleName(label, (AbstractButton)rightComponent);
            }
        }
        return pane;
    }

    protected final JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model) {
        return this.buildLabeledComboBoxImp(key, model, null, true);
    }

    protected final JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ListCellRenderer renderer) {
        return this.buildLabeledComboBoxImp(key, model, renderer, true);
    }

    protected final JComponent buildLabeledSpinnerNumber(String key, SpinnerNumberModel model) {
        return this.buildLabeledSpinnerNumber(key, model, 4);
    }

    protected final JComponent buildLabeledSpinnerNumber(String key, SpinnerNumberModel model, int columns) {
        Pane pane = new Pane(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel label = this.buildLabel(key);
        pane.add((Component)label, constraints);
        this.addAlignLeft(label);
        JSpinner spinner = SwingComponentFactory.buildSpinnerNumber(model, columns);
        spinner.setName(key);
        constraints.weightx = 1.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 0);
        pane.add((Component)spinner, constraints);
        label.setLabelFor(spinner);
        Spacer spacer = new Spacer();
        constraints.weightx = 0.0;
        constraints.fill = 0;
        pane.add((Component)spacer, constraints);
        this.addAlignRight(spacer);
        return pane;
    }

    protected final JComponent buildLabeledTextField(String key, Document document) {
        return this.buildLabeledTextField(key, document, new Spacer());
    }

    protected final JComponent buildLabeledTextField(String key, Document document, JComponent rightComponent) {
        JTextField textField = new JTextField(document, null, 1);
        return this.buildLabeledComponent(key, textField, rightComponent);
    }

    protected final JRadioButton buildRadioButton(String key, ButtonModel buttonModel) {
        return SwingComponentFactory.buildRadioButton(key, buttonModel, this.resourceRepository());
    }

    protected final Border buildTitledBorder(String key) {
        return SwingComponentFactory.buildTitledBorder(this.resourceRepository(), key);
    }

    protected final Border buildStandardEmptyBorder() {
        return SwingComponentFactory.buildStandardEmptyBorder();
    }

    public ComponentAligner getAlignLeftGroup() {
        if (this.alignLeftGroup == null) {
            this.alignLeftGroup = new ComponentAligner();
        }
        return this.alignLeftGroup;
    }

    public ComponentAligner getAlignRightGroup() {
        if (this.alignRightGroup == null) {
            this.alignRightGroup = new ComponentAligner();
        }
        return this.alignRightGroup;
    }

    protected final JSpinner buildSpinnerDate(SpinnerDateModel model) {
        JSpinner spinner = new JSpinner();
        spinner.setModel(model);
        return spinner;
    }

    public final ApplicationContext getApplicationContext() {
        return this.getWorkbenchContext().getApplicationContext();
    }

    public final Application application() {
        return this.getApplicationContext().getApplication();
    }

    public final Preferences preferences() {
        return this.getApplicationContext().getPreferences();
    }

    public final ResourceRepository resourceRepository() {
        return this.getApplicationContext().getResourceRepository();
    }

    public final HelpManager helpManager() {
        return this.getApplicationContext().getHelpManager();
    }

    public final WorkbenchContextHolder getWorkbenchContextHolder() {
        return this.workbenchContextHolder;
    }

    public final WorkbenchContext getWorkbenchContext() {
        return this.workbenchContextHolder.getWorkbenchContext();
    }

    public final NavigatorSelectionModel navigatorSelectionModel() {
        return this.getWorkbenchContext().getNavigatorSelectionModel();
    }

    public final Window currentWindow() {
        return this.getWorkbenchContext().getCurrentWindow();
    }

    public final NodeManager nodeManager() {
        return this.getApplicationContext().getNodeManager();
    }

    public final PreferencesContext getPreferencesContext() {
        return (PreferencesContext)this.getApplicationContext();
    }
}

