/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWInterfaceAliasDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.AdvancedPolicyChooser;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MappingDescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational.TableDescriptorNode;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;

public class AdvancedPolicyAction
extends AbstractFrameworkAction {
    public AdvancedPolicyAction(WorkbenchContext context) {
        super(context);
        this.initializeRepositoryResources();
    }

    private void initializeRepositoryResources() {
        this.initializeTextAndMnemonic("ADVANCED_PROPERTIES_MENU_ITEM");
        this.initializeToolTipText("ADVANCED_PROPERTIES_MENU_ITEM.tooltip");
        this.initializeIcon("descriptor.advancedProperties");
    }

    protected String getResourceString(String key) {
        return this.resourceRepository().getString(key);
    }

    private List buildApplicableAdvancedPolicyHolderList() {
        ArrayList<AdvancedPolicyHolder> advancedPolicyList = new ArrayList<AdvancedPolicyHolder>();
        if (this.supportsMappingDescriptorPolicies()) {
            advancedPolicyList.add(new AfterLoadingPolicyHolder());
            advancedPolicyList.add(new CopyingPolicyHolder());
            advancedPolicyList.add(new InheritencePolicyHolder());
            advancedPolicyList.add(new InstantiationPolicyHolder());
        }
        if (this.supportsEventsPolicy()) {
            advancedPolicyList.add(new EventsPolicyHolder());
        }
        if (this.supportsInterfaceAliasPolicy()) {
            advancedPolicyList.add(new InterfaceAliasPolicyHolder());
        }
        if (this.supportsTransactionalDescriptorProperties()) {
            advancedPolicyList.add(new ReturningPolicyHolder());
        }
        if (this.supportsTableDescriptorProperties()) {
            advancedPolicyList.add(new MultiTableInfoPolicyHolder());
        }
        return advancedPolicyList;
    }

    private boolean supportsEventsPolicy() {
        ApplicationNode[] selectedNodes = this.selectedNodes();
        for (int i = 0; i < selectedNodes.length; ++i) {
            if (((DescriptorNode)selectedNodes[i]).supportsEventsPolicy()) continue;
            return false;
        }
        return true;
    }

    private boolean supportsInterfaceAliasPolicy() {
        ApplicationNode[] selectedNodes = this.selectedNodes();
        for (int i = 0; i < selectedNodes.length; ++i) {
            if (((DescriptorNode)selectedNodes[i]).supportsInterfaceAliasPolicy()) continue;
            return false;
        }
        return true;
    }

    private boolean supportsMappingDescriptorPolicies() {
        return true;
    }

    private boolean supportsTransactionalDescriptorProperties() {
        ApplicationNode[] selectedNodes = this.selectedNodes();
        for (int i = 0; i < selectedNodes.length; ++i) {
            if (((DescriptorNode)selectedNodes[i]).supportsTransactionalDescriptorProperties()) continue;
            return false;
        }
        return true;
    }

    private boolean supportsTableDescriptorProperties() {
        ApplicationNode[] selectedNodes = this.selectedNodes();
        for (int i = 0; i < selectedNodes.length; ++i) {
            if (((DescriptorNode)selectedNodes[i]).isTableDescriptor()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void execute() {
        List advancedPolicyItemList = this.buildApplicableAdvancedPolicyHolderList();
        ListValueModel advancedPoliciesListModel = this.buildAdvancedPolicyListModel(advancedPolicyItemList);
        Iterator selectedItems = this.buildSelectedItems(advancedPolicyItemList.iterator());
        ObjectListSelectionModel selectionModel = this.buildSelectionModel(advancedPoliciesListModel, selectedItems);
        AdvancedPolicyChooser chooser = new AdvancedPolicyChooser(this.getWorkbenchContext(), advancedPoliciesListModel, selectionModel, this.buildAdvancedPropertiesCellRenderer());
        chooser.setVisible(true);
        if (chooser.wasCanceled()) {
            return;
        }
        List<Object> selectedValues = Arrays.asList(selectionModel.getSelectedValues());
        for (AdvancedPolicyHolder advancedPolicyHolder : selectedValues) {
            if (advancedPolicyHolder.initialSelectionState()) continue;
            advancedPolicyHolder.addToSelectedNodes();
        }
        for (AdvancedPolicyHolder advancedPolicyHolder : advancedPolicyItemList) {
            if (selectedValues.contains(advancedPolicyHolder) || !advancedPolicyHolder.initialSelectionState()) continue;
            advancedPolicyHolder.removeFromSelectedNodes();
        }
    }

    private ObjectListSelectionModel buildSelectionModel(ListValueModel itemHolder, Iterator selectedItems) {
        ListModelAdapter adapter = new ListModelAdapter(itemHolder);
        adapter.addListDataListener(new HackableListDataListener());
        ObjectListSelectionModel model = new ObjectListSelectionModel(adapter);
        model.setSelectedValues(selectedItems);
        return model;
    }

    private Iterator buildSelectedItems(Iterator allItems) {
        Filter iteratorFilter = new Filter(){

            public boolean accept(Object o) {
                return ((AdvancedPolicyHolder)o).initialSelectionState();
            }
        };
        return new FilteringIterator(allItems, iteratorFilter);
    }

    protected ListValueModel buildAdvancedPolicyListModel(List itemList) {
        return new SortedListValueModelAdapter(new ReadOnlyListValueModel(itemList), this.buildAdvancedPolicyComparator());
    }

    private CellRendererAdapter buildAdvancedPropertiesCellRenderer() {
        return new AbstractCellRendererAdapter(){

            @Override
            public String buildText(Object value) {
                return ((AdvancedPolicyHolder)value).displayString();
            }
        };
    }

    private Comparator buildAdvancedPolicyComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return Collator.getInstance().compare(((AdvancedPolicyHolder)o1).displayString(), ((AdvancedPolicyHolder)o2).displayString());
            }
        };
    }

    private class ReturningPolicyHolder
    implements AdvancedPolicyHolder {
        private ReturningPolicyHolder() {
        }

        @Override
        public void addToSelectedNodes() {
            ApplicationNode[] selection = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < selection.length; ++i) {
                MappingDescriptorNode node = (MappingDescriptorNode)selection[i];
                MWTransactionalDescriptor desc = (MWTransactionalDescriptor)node.getDescriptor();
                if (desc.getReturningPolicy().isActive()) continue;
                JOptionPane.showMessageDialog(AdvancedPolicyAction.this.getWorkbenchContext().getCurrentWindow(), AdvancedPolicyAction.this.getResourceString("NATIVE_RETURNING_NOT_SUPPORTED_ON_PLATFORM"), AdvancedPolicyAction.this.getResourceString("NATIVE_RETURNING_NOT_SUPPORTED_ON_PLATFORM_TITLE"), 1);
                desc.addReturningPolicy();
            }
        }

        @Override
        public boolean initialSelectionState() {
            boolean isSelected = true;
            ApplicationNode[] selection = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < selection.length; ++i) {
                MappingDescriptorNode node = (MappingDescriptorNode)selection[i];
                isSelected &= ((MWTransactionalDescriptor)node.getDescriptor()).getReturningPolicy().isActive();
            }
            return isSelected;
        }

        @Override
        public void removeFromSelectedNodes() {
            ApplicationNode[] selection = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < selection.length; ++i) {
                MappingDescriptorNode node = (MappingDescriptorNode)selection[i];
                MWTransactionalDescriptor desc = (MWTransactionalDescriptor)node.getDescriptor();
                if (!desc.getReturningPolicy().isActive()) continue;
                desc.removeReturningPolicy();
            }
        }

        @Override
        public String displayString() {
            return AdvancedPolicyAction.this.getResourceString("RETURNING_ACTION");
        }
    }

    private class MultiTableInfoPolicyHolder
    implements AdvancedPolicyHolder {
        private MultiTableInfoPolicyHolder() {
        }

        @Override
        public void addToSelectedNodes() {
            ApplicationNode[] selection = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < selection.length; ++i) {
                MappingDescriptorNode node = (MappingDescriptorNode)selection[i];
                MWTableDescriptor desc = (MWTableDescriptor)node.getDescriptor();
                if (desc.getMultiTableInfoPolicy().isActive()) continue;
                desc.addMultiTableInfoPolicy();
            }
        }

        @Override
        public boolean initialSelectionState() {
            boolean isSelected = true;
            ApplicationNode[] selection = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < selection.length; ++i) {
                TableDescriptorNode node = (TableDescriptorNode)selection[i];
                isSelected &= ((MWTableDescriptor)node.getDescriptor()).getMultiTableInfoPolicy().isActive();
            }
            return isSelected;
        }

        @Override
        public void removeFromSelectedNodes() {
            ApplicationNode[] selection = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < selection.length; ++i) {
                MappingDescriptorNode node = (MappingDescriptorNode)selection[i];
                MWTableDescriptor desc = (MWTableDescriptor)node.getDescriptor();
                if (!desc.getMultiTableInfoPolicy().isActive()) continue;
                desc.removeMultiTableInfoPolicy();
            }
        }

        @Override
        public String displayString() {
            return AdvancedPolicyAction.this.getResourceString("MULTI_TABLE_INFO_ACTION");
        }
    }

    private class InterfaceAliasPolicyHolder
    implements AdvancedPolicyHolder {
        private InterfaceAliasPolicyHolder() {
        }

        @Override
        public void addToSelectedNodes() {
            ApplicationNode[] selection = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < selection.length; ++i) {
                MappingDescriptorNode node = (MappingDescriptorNode)selection[i];
                MWInterfaceAliasDescriptor desc = (MWInterfaceAliasDescriptor)node.getDescriptor();
                if (desc.getInterfaceAliasPolicy().isActive()) continue;
                desc.addInterfaceAliasPolicy();
            }
        }

        @Override
        public boolean initialSelectionState() {
            boolean isSelected = true;
            ApplicationNode[] selection = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < selection.length; ++i) {
                MappingDescriptorNode node = (MappingDescriptorNode)selection[i];
                isSelected &= ((MWInterfaceAliasDescriptor)node.getDescriptor()).getInterfaceAliasPolicy().isActive();
            }
            return isSelected;
        }

        @Override
        public void removeFromSelectedNodes() {
            ApplicationNode[] selection = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < selection.length; ++i) {
                MappingDescriptorNode node = (MappingDescriptorNode)selection[i];
                MWInterfaceAliasDescriptor desc = (MWInterfaceAliasDescriptor)node.getDescriptor();
                if (!desc.getInterfaceAliasPolicy().isActive()) continue;
                desc.removeInterfaceAliasPolicy();
            }
        }

        @Override
        public String displayString() {
            return AdvancedPolicyAction.this.getResourceString("INTERFACE_ALIAS_ACTION");
        }
    }

    public class EventsPolicyHolder
    implements AdvancedPolicyHolder {
        @Override
        public void addToSelectedNodes() {
            ApplicationNode[] selectedNodes = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < selectedNodes.length; ++i) {
                MappingDescriptorNode descNode = (MappingDescriptorNode)selectedNodes[i];
                MWMappingDescriptor mappingDescriptor = descNode.getMappingDescriptor();
                if (mappingDescriptor.getEventsPolicy().isActive()) continue;
                mappingDescriptor.addEventsPolicy();
            }
        }

        @Override
        public void removeFromSelectedNodes() {
            ApplicationNode[] selectedNodes = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < selectedNodes.length; ++i) {
                MappingDescriptorNode descNode = (MappingDescriptorNode)selectedNodes[i];
                MWMappingDescriptor mappingDescriptor = descNode.getMappingDescriptor();
                if (!mappingDescriptor.getEventsPolicy().isActive()) continue;
                mappingDescriptor.removeEventsPolicy();
            }
        }

        @Override
        public boolean initialSelectionState() {
            ApplicationNode[] selectedNodes = AdvancedPolicyAction.this.selectedNodes();
            boolean isSelected = true;
            for (int i = 0; i < selectedNodes.length; ++i) {
                MappingDescriptorNode descNode = (MappingDescriptorNode)selectedNodes[i];
                MWMappingDescriptor mappingDescriptor = descNode.getMappingDescriptor();
                isSelected &= mappingDescriptor.getEventsPolicy().isActive();
            }
            return isSelected;
        }

        @Override
        public String displayString() {
            return AdvancedPolicyAction.this.getResourceString("EVENTS_POLICY_MAPPING_DESCRIPTOR_ACTION");
        }
    }

    private class InstantiationPolicyHolder
    implements AdvancedPolicyHolder {
        private InstantiationPolicyHolder() {
        }

        @Override
        public void addToSelectedNodes() {
            ApplicationNode[] selectedNodes = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < selectedNodes.length; ++i) {
                MappingDescriptorNode descNode = (MappingDescriptorNode)selectedNodes[i];
                MWMappingDescriptor mappingDescriptor = descNode.getMappingDescriptor();
                if (mappingDescriptor.getInstantiationPolicy().isActive()) continue;
                mappingDescriptor.addInstantiationPolicy();
            }
        }

        @Override
        public void removeFromSelectedNodes() {
            ApplicationNode[] selectedNodes = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < selectedNodes.length; ++i) {
                MappingDescriptorNode descNode = (MappingDescriptorNode)selectedNodes[i];
                MWMappingDescriptor mappingDescriptor = descNode.getMappingDescriptor();
                if (!mappingDescriptor.getInstantiationPolicy().isActive()) continue;
                mappingDescriptor.removeInstantiationPolicy();
            }
        }

        @Override
        public boolean initialSelectionState() {
            ApplicationNode[] selectedNodes = AdvancedPolicyAction.this.selectedNodes();
            boolean isSelected = true;
            for (int i = 0; i < selectedNodes.length; ++i) {
                MappingDescriptorNode descNode = (MappingDescriptorNode)selectedNodes[i];
                MWMappingDescriptor mappingDescriptor = descNode.getMappingDescriptor();
                isSelected &= mappingDescriptor.getInstantiationPolicy().isActive();
            }
            return isSelected;
        }

        @Override
        public String displayString() {
            return AdvancedPolicyAction.this.getResourceString("INSTANTIATION_POLICY_MAPPING_DESCRIPTOR_ACTION");
        }
    }

    private class InheritencePolicyHolder
    implements AdvancedPolicyHolder {
        private InheritencePolicyHolder() {
        }

        @Override
        public void addToSelectedNodes() {
            ApplicationNode[] selectedNodes = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < selectedNodes.length; ++i) {
                MappingDescriptorNode descNode = (MappingDescriptorNode)selectedNodes[i];
                MWMappingDescriptor mappingDescriptor = descNode.getMappingDescriptor();
                if (mappingDescriptor.getInheritancePolicy().isActive()) continue;
                mappingDescriptor.addInheritancePolicy();
            }
        }

        @Override
        public void removeFromSelectedNodes() {
            ApplicationNode[] selectedNodes = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < selectedNodes.length; ++i) {
                MappingDescriptorNode descNode = (MappingDescriptorNode)selectedNodes[i];
                MWMappingDescriptor mappingDescriptor = descNode.getMappingDescriptor();
                if (!mappingDescriptor.getInheritancePolicy().isActive()) continue;
                mappingDescriptor.removeInheritancePolicy();
            }
        }

        @Override
        public boolean initialSelectionState() {
            ApplicationNode[] selectedNodes = AdvancedPolicyAction.this.selectedNodes();
            boolean isSelected = true;
            for (int i = 0; i < selectedNodes.length; ++i) {
                MappingDescriptorNode descNode = (MappingDescriptorNode)selectedNodes[i];
                MWMappingDescriptor mappingDescriptor = descNode.getMappingDescriptor();
                isSelected &= mappingDescriptor.getInheritancePolicy().isActive();
            }
            return isSelected;
        }

        @Override
        public String displayString() {
            return AdvancedPolicyAction.this.getResourceString("INHERITANCE_POLICY_MAPPING_DESCRIPTOR_ACTION");
        }
    }

    private class AfterLoadingPolicyHolder
    implements AdvancedPolicyHolder {
        private AfterLoadingPolicyHolder() {
        }

        @Override
        public void addToSelectedNodes() {
            ApplicationNode[] selectedNodes = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < selectedNodes.length; ++i) {
                MappingDescriptorNode descNode = (MappingDescriptorNode)selectedNodes[i];
                MWMappingDescriptor mappingDescriptor = descNode.getMappingDescriptor();
                if (mappingDescriptor.getAfterLoadingPolicy().isActive()) continue;
                mappingDescriptor.addAfterLoadingPolicy();
            }
        }

        @Override
        public void removeFromSelectedNodes() {
            ApplicationNode[] selectedNodes = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < selectedNodes.length; ++i) {
                MappingDescriptorNode descNode = (MappingDescriptorNode)selectedNodes[i];
                MWMappingDescriptor mappingDescriptor = descNode.getMappingDescriptor();
                if (!mappingDescriptor.getAfterLoadingPolicy().isActive()) continue;
                mappingDescriptor.removeAfterLoadingPolicy();
            }
        }

        @Override
        public boolean initialSelectionState() {
            ApplicationNode[] selectedNodes = AdvancedPolicyAction.this.selectedNodes();
            boolean isSelected = true;
            for (int i = 0; i < selectedNodes.length; ++i) {
                MappingDescriptorNode descNode = (MappingDescriptorNode)selectedNodes[i];
                MWMappingDescriptor mappingDescriptor = descNode.getMappingDescriptor();
                isSelected &= mappingDescriptor.getAfterLoadingPolicy().isActive();
            }
            return isSelected;
        }

        @Override
        public String displayString() {
            return AdvancedPolicyAction.this.getResourceString("AFTER_LOAD_POLICY_MAPPING_DESCRIPTOR_ACTION");
        }
    }

    private class CopyingPolicyHolder
    implements AdvancedPolicyHolder {
        private CopyingPolicyHolder() {
        }

        @Override
        public void addToSelectedNodes() {
            ApplicationNode[] selectedNodes = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < selectedNodes.length; ++i) {
                MappingDescriptorNode descNode = (MappingDescriptorNode)selectedNodes[i];
                MWMappingDescriptor mappingDescriptor = descNode.getMappingDescriptor();
                if (mappingDescriptor.getCopyPolicy().isActive()) continue;
                mappingDescriptor.addCopyPolicy();
            }
        }

        @Override
        public void removeFromSelectedNodes() {
            ApplicationNode[] selectedNodes = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < selectedNodes.length; ++i) {
                MappingDescriptorNode descNode = (MappingDescriptorNode)selectedNodes[i];
                MWMappingDescriptor mappingDescriptor = descNode.getMappingDescriptor();
                if (!mappingDescriptor.getCopyPolicy().isActive()) continue;
                mappingDescriptor.removeCopyPolicy();
            }
        }

        @Override
        public boolean initialSelectionState() {
            ApplicationNode[] selectedNodes = AdvancedPolicyAction.this.selectedNodes();
            boolean isSelected = true;
            for (int i = 0; i < selectedNodes.length; ++i) {
                MappingDescriptorNode descNode = (MappingDescriptorNode)selectedNodes[i];
                MWMappingDescriptor mappingDescriptor = descNode.getMappingDescriptor();
                isSelected &= mappingDescriptor.getCopyPolicy().isActive();
            }
            return isSelected;
        }

        @Override
        public String displayString() {
            return AdvancedPolicyAction.this.getResourceString("COPY_POLICY_MAPPING_DESCRIPTOR_ACTION");
        }
    }

    private class HackableListDataListener
    implements ListDataListener {
        private HackableListDataListener() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }
    }

    protected static interface AdvancedPolicyHolder {
        public void addToSelectedNodes();

        public void removeFromSelectedNodes();

        public boolean initialSelectionState();

        public String displayString();
    }
}

