/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBatchReadItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AbstractAttributeItemsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AttributeItemDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTree;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTreeNode;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTreeCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

final class BatchReadAttributesPanel
extends AbstractAttributeItemsPanel {
    public BatchReadAttributesPanel(PropertyValueModel queryHolder, WorkbenchContextHolder contextHolder) {
        super(queryHolder, contextHolder);
    }

    @Override
    protected PropertyValueModel buildQueryHolder(PropertyValueModel queryHolder) {
        return new FilteringPropertyValueModel(queryHolder){

            @Override
            protected boolean accept(Object value) {
                return value instanceof MWRelationalReadAllQuery;
            }
        };
    }

    @Override
    protected String helpTopicId() {
        return "query.report.batchReadAttributes";
    }

    @Override
    String listTitleKey() {
        return "BATCH_READ_ATTRIBUTES_LIST";
    }

    @Override
    AddRemovePanel.UpDownOptionAdapter buildAttributesPanelAdapter() {
        return new AddRemovePanel.UpDownOptionAdapter(){

            @Override
            public String optionalButtonKey() {
                return "BATCH_READ_ATTRIBUTES_LIST_EDIT_BUTTON";
            }

            @Override
            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                BatchReadAttributesPanel.this.editSelectedAttribute((MWAttributeItem)listSelectionModel.getSelectedValue());
            }

            @Override
            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel listSelectionModel) {
                return listSelectionModel.getSelectedValuesSize() == 1;
            }

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                BatchReadAttributesPanel.this.addBatchReadAttribute();
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] selectedValues = listSelectionModel.getSelectedValues();
                for (int i = 0; i < selectedValues.length; ++i) {
                    ((MWRelationalReadAllQuery)BatchReadAttributesPanel.this.getQuery()).removeBatchReadItem((MWBatchReadItem)selectedValues[i]);
                }
            }

            @Override
            public void moveItemsDown(Object[] items) {
                for (int i = 0; i < items.length; ++i) {
                    ((MWRelationalReadAllQuery)BatchReadAttributesPanel.this.getQuery()).moveBatchReadItemDown((MWBatchReadItem)items[i]);
                }
            }

            @Override
            public void moveItemsUp(Object[] items) {
                for (int i = 0; i < items.length; ++i) {
                    ((MWRelationalReadAllQuery)BatchReadAttributesPanel.this.getQuery()).moveBatchReadItemUp((MWBatchReadItem)items[i]);
                }
            }
        };
    }

    @Override
    protected ListValueModel buildAttributesHolder() {
        return new ListAspectAdapter(this.getQueryHolder(), "batchReadItems"){

            @Override
            protected ListIterator getValueFromSubject() {
                return ((MWRelationalReadAllQuery)this.subject).batchReadItems();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWRelationalReadAllQuery)this.subject).batchReadItemsSize();
            }
        };
    }

    @Override
    protected boolean panelEnabled(MWQueryFormat queryFormat) {
        return queryFormat.batchReadAttributesAllowed();
    }

    private void addBatchReadAttribute() {
        this.editSelectedAttribute(null);
    }

    @Override
    AttributeItemDialog buildAttributeItemDialog(MWAttributeItem item) {
        return new AttributeItemDialog(this.getQuery(), item, this.getWorkbenchContext()){

            @Override
            protected String titleKey() {
                return "BATCH_READ_ATTRIBUTE_DIALOG_TITLE";
            }

            @Override
            protected String editTitleKey() {
                return "BATCH_READ_ATTRIBUTE_EDIT_DIALOG_TITLE";
            }

            @Override
            protected String helpTopicId() {
                return "dialog.batchReadAttribute";
            }

            @Override
            protected QueryableTree buildQueryableTree() {
                QueryableTree tree = super.buildQueryableTree();
                tree.setCellRenderer(this.buildQueryableTreeRenderer(tree));
                tree.setCellEditor(null);
                return tree;
            }

            private TreeCellRenderer buildQueryableTreeRenderer(final QueryableTree tree) {
                return new SimpleTreeCellRenderer(){

                    @Override
                    public Color getBackgroundSelectionColor() {
                        if (!tree.hasFocus() && !tree.isEditing()) {
                            return UIManager.getColor("Panel.background");
                        }
                        return super.getBackgroundSelectionColor();
                    }

                    @Override
                    public Color getBorderSelectionColor() {
                        if (!tree.hasFocus() && !tree.isEditing()) {
                            return UIManager.getColor("Panel.background");
                        }
                        return super.getBorderSelectionColor();
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension size = super.getPreferredSize();
                        size.height += 2;
                        return size;
                    }

                    @Override
                    protected String buildText(Object value) {
                        if (MWTableDescriptor.class.isAssignableFrom(((DefaultMutableTreeNode)value).getUserObject().getClass())) {
                            return "";
                        }
                        return ((QueryableTreeNode)value).getQueryable().getName();
                    }

                    @Override
                    protected Icon buildIcon(Object value) {
                        if (MWTableDescriptor.class.isAssignableFrom(((DefaultMutableTreeNode)value).getUserObject().getClass())) {
                            return null;
                        }
                        return this.resourceRepository().getIcon(((QueryableTreeNode)value).getQueryable().iconKey());
                    }
                };
            }

            @Override
            protected int attributeItemsSize() {
                return ((MWRelationalReadAllQuery)this.getQuery()).batchReadItemsSize();
            }

            @Override
            protected int indexOfAttributeItem(MWAttributeItem attributeItem) {
                return ((MWRelationalReadAllQuery)this.getQuery()).indexOfBatchReadItem((MWBatchReadItem)attributeItem);
            }

            @Override
            protected void removeAttributeItem(int index) {
                ((MWRelationalReadAllQuery)this.getQuery()).removeBatchReadItem(index);
            }

            @Override
            protected void addAttributeItem(int index, Iterator queryables, Iterator allowsNulls) {
                ((MWRelationalReadAllQuery)this.getQuery()).addBatchReadItem(index, queryables, allowsNulls);
            }

            @Override
            protected Filter buildTraversableFilter() {
                return new Filter(){

                    public boolean accept(Object o) {
                        return ((MWQueryable)o).isTraversableForBatchReadAttribute();
                    }
                };
            }

            @Override
            protected Filter buildChooseableFilter() {
                return new Filter(){

                    public boolean accept(Object o) {
                        return ((MWQueryable)o).isValidForBatchReadAttribute();
                    }
                };
            }
        };
    }
}

