/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAbstractRelationalReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWJoinedItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AbstractAttributeItemsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AttributeItemDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

final class JoinedAttributesPanel
extends AbstractAttributeItemsPanel {
    public JoinedAttributesPanel(PropertyValueModel queryHolder, WorkbenchContextHolder contextHolder) {
        super(queryHolder, contextHolder);
    }

    @Override
    protected PropertyValueModel buildQueryHolder(PropertyValueModel queryHolder) {
        return new FilteringPropertyValueModel(queryHolder){

            @Override
            protected boolean accept(Object value) {
                return value instanceof MWAbstractRelationalReadQuery;
            }
        };
    }

    @Override
    protected String helpTopicId() {
        return "query.joinedAtributes";
    }

    @Override
    String listTitleKey() {
        return "JOINED_ATTRIBUTES_LIST";
    }

    @Override
    AddRemovePanel.UpDownOptionAdapter buildAttributesPanelAdapter() {
        return new AddRemovePanel.UpDownOptionAdapter(){

            @Override
            public String optionalButtonKey() {
                return "JOINED_ATTRIBUTES_LIST_EDIT_BUTTON";
            }

            @Override
            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                JoinedAttributesPanel.this.editSelectedAttribute((MWAttributeItem)((MWJoinedItem)listSelectionModel.getSelectedValue()));
            }

            @Override
            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel listSelectionModel) {
                return listSelectionModel.getSelectedValuesSize() == 1;
            }

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                JoinedAttributesPanel.this.addJoinedAttribute();
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] selectedValues = listSelectionModel.getSelectedValues();
                for (int i = 0; i < selectedValues.length; ++i) {
                    ((MWAbstractRelationalReadQuery)JoinedAttributesPanel.this.getQuery()).removeJoinedItem((MWJoinedItem)selectedValues[i]);
                }
            }

            @Override
            public void moveItemsDown(Object[] items) {
                for (int i = 0; i < items.length; ++i) {
                    ((MWAbstractRelationalReadQuery)JoinedAttributesPanel.this.getQuery()).moveJoinedItemDown((MWJoinedItem)items[i]);
                }
            }

            @Override
            public void moveItemsUp(Object[] items) {
                for (int i = 0; i < items.length; ++i) {
                    ((MWAbstractRelationalReadQuery)JoinedAttributesPanel.this.getQuery()).moveJoinedItemUp((MWJoinedItem)items[i]);
                }
            }
        };
    }

    @Override
    protected ListValueModel buildAttributesHolder() {
        return new ListAspectAdapter(this.getQueryHolder(), "joinedItems"){

            @Override
            protected ListIterator getValueFromSubject() {
                return ((MWAbstractRelationalReadQuery)this.subject).joinedItems();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWAbstractRelationalReadQuery)this.subject).joinedItemsSize();
            }
        };
    }

    @Override
    protected boolean panelEnabled(MWQueryFormat queryFormat) {
        return true;
    }

    private void addJoinedAttribute() {
        this.editSelectedAttribute(null);
    }

    @Override
    AttributeItemDialog buildAttributeItemDialog(MWAttributeItem item) {
        return new AttributeItemDialog(this.getQuery(), item, this.getWorkbenchContext()){

            @Override
            protected String titleKey() {
                return "JOINED_ATTRIBUTES_DIALOG_TITLE";
            }

            @Override
            protected String editTitleKey() {
                return "JOINED_ATTRIBUTES_EDIT_DIALOG_TITLE";
            }

            @Override
            protected String helpTopicId() {
                return "dialog.joinedAttribute";
            }

            @Override
            protected Filter buildTraversableFilter() {
                return new Filter(){

                    public boolean accept(Object o) {
                        return ((MWQueryable)o).isTraversableForJoinedAttribute();
                    }
                };
            }

            @Override
            protected Filter buildChooseableFilter() {
                return new Filter(){

                    public boolean accept(Object o) {
                        return ((MWQueryable)o).isValidForJoinedAttribute();
                    }
                };
            }

            @Override
            protected int attributeItemsSize() {
                return ((MWAbstractRelationalReadQuery)this.getQuery()).joinedItemsSize();
            }

            @Override
            protected int indexOfAttributeItem(MWAttributeItem attributeItem) {
                return ((MWAbstractRelationalReadQuery)this.getQuery()).indexOfJoinedItem((MWJoinedItem)attributeItem);
            }

            @Override
            protected void removeAttributeItem(int index) {
                ((MWAbstractRelationalReadQuery)this.getQuery()).removeJoinedItem(index);
            }

            @Override
            protected void addAttributeItem(int index, Iterator queryables, Iterator allowsNulls) {
                ((MWAbstractRelationalReadQuery)this.getQuery()).addJoinedItem(index, queryables, allowsNulls);
            }
        };
    }
}

