/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.xml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWEisInteraction;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;

public final class InteractionPanel
extends AbstractPanel {
    private PropertyValueModel eisInteractionHolder;
    private String helpTopicId;
    private JTable inputArgumentsTable;
    private JTable outputArgumentsTable;
    private JTable propertiesTable;
    private JButton addInputArgumentButton;
    private JButton removeInputArgumentButton;
    private JButton addPropertyButton;
    private JButton removePropertyButton;
    private JButton addOutputArgumentButton;
    private JButton removeOutputArgumentButton;

    public InteractionPanel(ApplicationContext context, PropertyValueModel interactionHolder, PropertyValueModel enabledBooleanHolder, String helpTopicId) {
        super(context);
        this.initialize(interactionHolder, enabledBooleanHolder, helpTopicId);
    }

    public InteractionPanel(ApplicationContext context, PropertyValueModel interactionHolder, String helpTopicId) {
        this(context, interactionHolder, null, helpTopicId);
    }

    public InteractionPanel(ApplicationContext context, PropertyValueModel interactionHolder, PropertyValueModel enabledBooleanHolder) {
        this(context, interactionHolder, enabledBooleanHolder, "descriptor.queryManager.customCalls");
    }

    public InteractionPanel(ApplicationContext context, PropertyValueModel interactionHolder) {
        this(context, interactionHolder, null, "descriptor.queryManager.customCalls");
    }

    protected void initialize(PropertyValueModel interactionModel, PropertyValueModel enabledBooleanHolder, String helpTopicId) {
        this.helpTopicId = helpTopicId;
        this.eisInteractionHolder = interactionModel;
        this.initializeLayout(enabledBooleanHolder);
    }

    public void initializeLayout(PropertyValueModel enabledBooleanHolder) {
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        GridBagConstraints constraints = new GridBagConstraints();
        Pane mainPage = new Pane(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)mainPage, constraints);
        JComboBox<String> interactionTypeCombo = new JComboBox<String>(new String[]{this.resourceRepository().getString("XML_INTERACTION")});
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 5, 0, 5);
        mainPage.add(interactionTypeCombo, constraints);
        JComponent functionNameComponent = this.buildLabeledTextField("FUNCTION_NAME", this.buildFunctionNameDocument(this.buildFunctionNameHolder()));
        CollectionTools.addAll(components, (Object[])functionNameComponent.getComponents());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 5);
        mainPage.add((Component)functionNameComponent, constraints);
        JComponent inputRecordNameComponent = this.buildLabeledTextField("INPUT_RECORD_NAME", this.buildInputRecordDocument(this.buildInputRecordNameHolder()));
        CollectionTools.addAll(components, (Object[])inputRecordNameComponent.getComponents());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 5);
        mainPage.add((Component)inputRecordNameComponent, constraints);
        JComponent inputRootElementNameComponent = this.buildLabeledTextField("INPUT_ROOT_ELEMENT_NAME", this.buildInputRootElementNameDocument(this.buildInputRootElementNameHolder()));
        CollectionTools.addAll(components, (Object[])inputRootElementNameComponent.getComponents());
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 5);
        mainPage.add((Component)inputRootElementNameComponent, constraints);
        JLabel inputArgumentsLabel = this.buildLabel("INPUT_ARGUMENTS");
        components.add(inputArgumentsLabel);
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 5, 0, 0);
        mainPage.add((Component)inputArgumentsLabel, constraints);
        this.addAlignLeft(inputArgumentsLabel);
        this.inputArgumentsTable = this.buildInputArgumentsTable();
        components.add(this.inputArgumentsTable);
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 22;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.inputArgumentsTable.setPreferredScrollableViewportSize(new Dimension(25, 50));
        JScrollPane scrollPane = new JScrollPane(this.inputArgumentsTable);
        scrollPane.getViewport().setBackground(this.inputArgumentsTable.getBackground());
        mainPage.add((Component)scrollPane, constraints);
        this.addInputArgumentButton = this.buildButton("ADD_ARGUMENT_BUTTON");
        this.addInputArgumentButton.addActionListener(this.buildAddArgumentAction());
        this.removeInputArgumentButton = this.buildButton("REMOVE_ARGUMENT_BUTTON");
        this.removeInputArgumentButton.addActionListener(this.buildRemoveArgumentAction());
        this.removeInputArgumentButton.setEnabled(false);
        ButtonPane inputButtonPanel = new ButtonPane(this.inputArgumentsTable, this.addInputArgumentButton, this.removeInputArgumentButton);
        components.add(inputButtonPanel);
        constraints.gridx = 2;
        constraints.gridy = 5;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 22;
        constraints.insets = new Insets(2, 5, 5, 5);
        mainPage.add((Component)inputButtonPanel, constraints);
        JLabel outputArgumentsLabel = this.buildLabel("OUTPUT_ARGUMENTS");
        components.add(outputArgumentsLabel);
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 1;
        constraints.gridheight = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 5, 0, 0);
        mainPage.add((Component)outputArgumentsLabel, constraints);
        this.addAlignLeft(outputArgumentsLabel);
        this.outputArgumentsTable = this.buildOutputArgumentsTable();
        components.add(this.outputArgumentsTable);
        constraints.gridx = 1;
        constraints.gridy = 6;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.outputArgumentsTable.setPreferredScrollableViewportSize(new Dimension(25, 50));
        scrollPane = new JScrollPane(this.outputArgumentsTable);
        scrollPane.getViewport().setBackground(this.outputArgumentsTable.getBackground());
        mainPage.add((Component)scrollPane, constraints);
        this.addOutputArgumentButton = this.buildButton("ADD_ARGUMENT_BUTTON");
        this.addOutputArgumentButton.addActionListener(this.buildAddArgumentAction());
        this.removeOutputArgumentButton = this.buildButton("REMOVE_ARGUMENT_BUTTON");
        this.removeOutputArgumentButton.addActionListener(this.buildRemoveArgumentAction());
        this.removeOutputArgumentButton.setEnabled(false);
        ButtonPane outputButtonPanel = new ButtonPane(this.outputArgumentsTable, this.addOutputArgumentButton, this.removeOutputArgumentButton);
        components.add(outputButtonPanel);
        constraints.gridx = 2;
        constraints.gridy = 7;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 22;
        constraints.insets = new Insets(2, 5, 5, 5);
        mainPage.add((Component)outputButtonPanel, constraints);
        JComponent inputResultPathComponent = this.buildLabeledTextField("INPUT_RESULT_PATH", this.buildInputResultPathDocument(this.buildInputResultPathHolder()));
        CollectionTools.addAll(components, (Object[])inputResultPathComponent.getComponents());
        constraints.gridx = 0;
        constraints.gridy = 8;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 5);
        mainPage.add((Component)inputResultPathComponent, constraints);
        JComponent outputResultPathComponent = this.buildLabeledTextField("OUTPUT_RESULTS_PATH", this.buildOutputResultPathDocument(this.buildOutputResultPathHolder()));
        CollectionTools.addAll(components, (Object[])outputResultPathComponent.getComponents());
        constraints.gridx = 0;
        constraints.gridy = 9;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 5);
        mainPage.add((Component)outputResultPathComponent, constraints);
        JLabel propertiesLabel = this.buildLabel("PROPERTIES");
        components.add(propertiesLabel);
        constraints.gridx = 0;
        constraints.gridy = 10;
        constraints.gridwidth = 1;
        constraints.gridheight = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 5, 0, 0);
        mainPage.add((Component)propertiesLabel, constraints);
        this.addAlignLeft(propertiesLabel);
        this.propertiesTable = this.buildPropertiesTable();
        components.add(this.propertiesTable);
        constraints.gridx = 1;
        constraints.gridy = 10;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.propertiesTable.setPreferredScrollableViewportSize(new Dimension(25, 50));
        scrollPane = new JScrollPane(this.propertiesTable);
        scrollPane.getViewport().setBackground(this.propertiesTable.getBackground());
        mainPage.add((Component)scrollPane, constraints);
        this.addPropertyButton = this.buildButton("ADD_ARGUMENT_BUTTON");
        this.addPropertyButton.addActionListener(this.buildAddArgumentAction());
        this.removePropertyButton = this.buildButton("REMOVE_ARGUMENT_BUTTON");
        this.removePropertyButton.addActionListener(this.buildRemoveArgumentAction());
        this.removePropertyButton.setEnabled(false);
        ButtonPane propertiesButtonPanel = new ButtonPane(this.propertiesTable, this.addPropertyButton, this.removePropertyButton);
        components.add(propertiesButtonPanel);
        propertiesButtonPanel.setBorder(BorderFactory.createEmptyBorder());
        constraints.gridx = 2;
        constraints.gridy = 11;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 22;
        constraints.insets = new Insets(2, 5, 5, 5);
        mainPage.add((Component)propertiesButtonPanel, constraints);
        this.addHelpTopicId(mainPage, this.helpTopicId());
        if (enabledBooleanHolder != null) {
            new ComponentEnabler((ValueModel)enabledBooleanHolder, components);
        }
    }

    private PropertyValueModel buildFunctionNameHolder() {
        return new PropertyAspectAdapter(this.eisInteractionHolder, "funtionName"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWEisInteraction)this.subject).getFunctionName();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWEisInteraction)this.subject).setFunctionName((String)value);
            }
        };
    }

    private DocumentAdapter buildFunctionNameDocument(PropertyValueModel functionNameHolder) {
        return new DocumentAdapter(functionNameHolder);
    }

    private PropertyValueModel buildInputRecordNameHolder() {
        return new PropertyAspectAdapter(this.eisInteractionHolder, "inputRecordName"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWEisInteraction)this.subject).getInputRecordName();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWEisInteraction)this.subject).setInputRecordName((String)value);
            }
        };
    }

    private DocumentAdapter buildInputRecordDocument(PropertyValueModel inputRecordNameHolder) {
        return new DocumentAdapter(inputRecordNameHolder);
    }

    private PropertyValueModel buildInputRootElementNameHolder() {
        return new PropertyAspectAdapter(this.eisInteractionHolder, "inputRootElementName"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWEisInteraction)this.subject).getInputRootElementName();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWEisInteraction)this.subject).setInputRootElementName((String)value);
            }
        };
    }

    private DocumentAdapter buildInputRootElementNameDocument(PropertyValueModel inputRootElementNameHolder) {
        return new DocumentAdapter(inputRootElementNameHolder);
    }

    private PropertyValueModel buildInputResultPathHolder() {
        return new PropertyAspectAdapter(this.eisInteractionHolder, "inputResultPath"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWEisInteraction)this.subject).getInputResultPath();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWEisInteraction)this.subject).setInputResultPath((String)value);
            }
        };
    }

    private DocumentAdapter buildInputResultPathDocument(PropertyValueModel inputResultPathHolder) {
        return new DocumentAdapter(inputResultPathHolder);
    }

    private PropertyValueModel buildOutputResultPathHolder() {
        return new PropertyAspectAdapter(this.eisInteractionHolder, "outputResultPath"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWEisInteraction)this.subject).getOutputResultPath();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWEisInteraction)this.subject).setOutputResultPath((String)value);
            }
        };
    }

    private DocumentAdapter buildOutputResultPathDocument(PropertyValueModel outputResultPathHolder) {
        return new DocumentAdapter(outputResultPathHolder);
    }

    protected ListSelectionListener buildListSelectionHandler() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    InteractionPanel.this.updateRemoveArgumentButton();
                }
            }
        };
    }

    private void updateRemoveArgumentButton() {
        boolean argsSelected = this.inputArgumentsTable.getSelectedRows().length > 0;
        this.removeInputArgumentButton.setEnabled(argsSelected);
        argsSelected = this.outputArgumentsTable.getSelectedRows().length > 0;
        this.removeOutputArgumentButton.setEnabled(argsSelected);
        argsSelected = this.propertiesTable.getSelectedRows().length > 0;
        this.removePropertyButton.setEnabled(argsSelected);
    }

    protected ActionListener buildAddArgumentAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ae.getSource() == InteractionPanel.this.addInputArgumentButton) {
                    InteractionPanel.this.addInputArgument();
                } else if (ae.getSource() == InteractionPanel.this.addOutputArgumentButton) {
                    InteractionPanel.this.addOutputArgument();
                } else {
                    InteractionPanel.this.addProperty();
                }
            }
        };
    }

    protected ActionListener buildRemoveArgumentAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ae.getSource() == InteractionPanel.this.removeInputArgumentButton) {
                    InteractionPanel.this.removeSelectedInputArguments();
                } else if (ae.getSource() == InteractionPanel.this.removeOutputArgumentButton) {
                    InteractionPanel.this.removeSelectedOutputArguments();
                } else {
                    InteractionPanel.this.removeSelectedProperty();
                }
            }
        };
    }

    protected void addInputArgument() {
        this.getEisInteraction().addInputArgument();
        int numRows = this.getEisInteraction().inputArgumentsSize() - 1;
        JTable table = this.inputArgumentsTable;
        table.setRowSelectionInterval(numRows, numRows);
        table.editCellAt(numRows, 0);
        ((JTextField)table.getEditorComponent()).grabFocus();
        ((JTextField)table.getEditorComponent()).selectAll();
    }

    protected void addOutputArgument() {
        this.getEisInteraction().addOutputArgument();
        int numRows = this.getEisInteraction().outputArgumentsSize() - 1;
        JTable table = this.outputArgumentsTable;
        table.setRowSelectionInterval(numRows, numRows);
        table.editCellAt(numRows, 0);
        ((JTextField)table.getEditorComponent()).grabFocus();
        ((JTextField)table.getEditorComponent()).selectAll();
    }

    protected void addProperty() {
        this.getEisInteraction().addProperty();
        int numRows = this.getEisInteraction().propertySize() - 1;
        JTable table = this.propertiesTable;
        table.setRowSelectionInterval(numRows, numRows);
        table.editCellAt(numRows, 0);
        ((JTextField)table.getEditorComponent()).grabFocus();
        ((JTextField)table.getEditorComponent()).selectAll();
    }

    protected void removeSelectedInputArguments() {
        if (this.inputArgumentsTable.isEditing()) {
            this.inputArgumentsTable.getCellEditor().stopCellEditing();
        }
        int[] selectedRows = this.inputArgumentsTable.getSelectedRows();
        int index = selectedRows.length;
        while (--index >= 0) {
            MWEisInteraction.ArgumentPair inputArgumentPair = this.getEisInteraction().getInputArgumentPair(selectedRows[index]);
            this.getEisInteraction().removeInputArgument(inputArgumentPair);
        }
    }

    protected void removeSelectedOutputArguments() {
        if (this.outputArgumentsTable.isEditing()) {
            this.outputArgumentsTable.getCellEditor().stopCellEditing();
        }
        int[] selectedRows = this.outputArgumentsTable.getSelectedRows();
        int index = selectedRows.length;
        while (--index >= 0) {
            MWEisInteraction.ArgumentPair outputArgumentPair = this.getEisInteraction().getOutputArgumentPair(selectedRows[index]);
            this.getEisInteraction().removeOutputArgument(outputArgumentPair);
        }
    }

    protected void removeSelectedProperty() {
        if (this.propertiesTable.isEditing()) {
            this.propertiesTable.getCellEditor().stopCellEditing();
        }
        int[] selectedRows = this.propertiesTable.getSelectedRows();
        int index = selectedRows.length;
        while (--index >= 0) {
            MWEisInteraction.ArgumentPair property = this.getEisInteraction().getProperty(selectedRows[index]);
            this.getEisInteraction().removeProperty(property);
        }
    }

    private JTable buildInputArgumentsTable() {
        this.inputArgumentsTable = SwingComponentFactory.buildTable(this.buildInputArgumentsTableModel());
        this.inputArgumentsTable.getSelectionModel().addListSelectionListener(this.buildListSelectionHandler());
        this.inputArgumentsTable.setAutoResizeMode(4);
        TableColumn argumentNameColumn = this.inputArgumentsTable.getColumnModel().getColumn(0);
        argumentNameColumn.setMinWidth(122);
        TableColumn fieldNameColumn = this.inputArgumentsTable.getColumnModel().getColumn(1);
        fieldNameColumn.setMinWidth(122);
        return this.inputArgumentsTable;
    }

    private String[] argumentColumnNameKeys() {
        return new String[]{"ARGUMENT_NAME_COLUMN_HEADER", "ARGUMENT_FIELD_NAME_COLUMN_HEADER"};
    }

    private String[] propertyColumnNameKeys() {
        return new String[]{"PROPERTY_NAME", "PROPERTY_VALUE"};
    }

    private TableModel buildInputArgumentsTableModel() {
        return new TableModelAdapter(this.buildInputArgumentsAdapter(), this.buildArgumentTableColumnAdapter(this.argumentColumnNameKeys()));
    }

    private ColumnAdapter buildArgumentTableColumnAdapter(String[] columnNameKeys) {
        return new ArgumentColumnAdapter(this.resourceRepository(), columnNameKeys);
    }

    private ListValueModel buildInputArgumentsAdapter() {
        return new ListAspectAdapter(this.eisInteractionHolder, "inputArguments"){

            @Override
            protected ListIterator getValueFromSubject() {
                return ((MWEisInteraction)this.subject).inputArguments();
            }
        };
    }

    private JTable buildPropertiesTable() {
        this.propertiesTable = SwingComponentFactory.buildTable(this.buildPropertiesTableModel());
        this.propertiesTable.getSelectionModel().addListSelectionListener(this.buildListSelectionHandler());
        this.propertiesTable.setAutoResizeMode(4);
        return this.propertiesTable;
    }

    private TableModel buildPropertiesTableModel() {
        return new TableModelAdapter(this.buildPropertiesAdapter(), this.buildArgumentTableColumnAdapter(this.propertyColumnNameKeys()));
    }

    private ListValueModel buildPropertiesAdapter() {
        return new ListAspectAdapter(this.eisInteractionHolder, "properties"){

            @Override
            protected ListIterator getValueFromSubject() {
                return ((MWEisInteraction)this.subject).properties();
            }
        };
    }

    private JTable buildOutputArgumentsTable() {
        this.outputArgumentsTable = SwingComponentFactory.buildTable(this.buildOutputArgumentsTableModel());
        this.outputArgumentsTable.getSelectionModel().addListSelectionListener(this.buildListSelectionHandler());
        this.outputArgumentsTable.setAutoResizeMode(4);
        return this.outputArgumentsTable;
    }

    private TableModel buildOutputArgumentsTableModel() {
        return new TableModelAdapter(this.buildOutputArgumentsAdapter(), this.buildArgumentTableColumnAdapter(this.argumentColumnNameKeys()));
    }

    private ListValueModel buildOutputArgumentsAdapter() {
        return new ListAspectAdapter(this.eisInteractionHolder, "outputArguments"){

            @Override
            protected ListIterator getValueFromSubject() {
                return ((MWEisInteraction)this.subject).outputArguments();
            }
        };
    }

    public MWEisInteraction getEisInteraction() {
        return (MWEisInteraction)this.eisInteractionHolder.getValue();
    }

    public String helpTopicId() {
        return this.helpTopicId;
    }

    private class ButtonPane
    extends Pane {
        private JTable table;

        ButtonPane(JTable table, JButton addButton, JButton removeButton) {
            super(new GridLayout(1, 2, 5, 0));
            this.initialize(table, addButton, removeButton);
        }

        private void initialize(JTable table, JButton addButton, JButton removeButton) {
            this.table = table;
            this.add(addButton);
            this.add(removeButton);
        }

        @Override
        protected void updateEnableStateOfChildren(boolean enabled) {
            this.getComponent(0).setEnabled(enabled);
            this.getComponent(1).setEnabled(enabled && this.table.getSelectedRowCount() > 0);
        }
    }

    private static class ArgumentColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 2;
        public static final int ARGUMENT_NAME_COLUMN = 0;
        public static final int FIELD_NAME_COLUMN = 1;
        private String[] COLUMN_NAME_KEYS;

        protected ArgumentColumnAdapter(ResourceRepository resourceRepository, String[] columnNameKeys) {
            this.resourceRepository = resourceRepository;
            this.COLUMN_NAME_KEYS = columnNameKeys;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int index) {
            return this.resourceRepository.getString(this.COLUMN_NAME_KEYS[index]);
        }

        @Override
        public Class getColumnClass(int index) {
            switch (index) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isColumnEditable(int columnIndex) {
            return true;
        }

        @Override
        public PropertyValueModel[] cellModels(Object subject) {
            MWEisInteraction.ArgumentPair argumentPair = (MWEisInteraction.ArgumentPair)subject;
            PropertyValueModel[] result = new PropertyValueModel[]{this.buildArgumentNameAdapter(argumentPair), this.buildArgumentFieldNameAdapter(argumentPair)};
            return result;
        }

        private PropertyValueModel buildArgumentNameAdapter(MWEisInteraction.ArgumentPair argumentPair) {
            return new PropertyAspectAdapter("argumentName", (Model)argumentPair){

                @Override
                protected Object getValueFromSubject() {
                    return ((MWEisInteraction.ArgumentPair)this.subject).getArgumentName();
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWEisInteraction.ArgumentPair)this.subject).setArgumentName((String)value);
                }
            };
        }

        private PropertyValueModel buildArgumentFieldNameAdapter(MWEisInteraction.ArgumentPair argumentPair) {
            return new PropertyAspectAdapter("argumentFieldName", (Model)argumentPair){

                @Override
                protected Object getValueFromSubject() {
                    return ((MWEisInteraction.ArgumentPair)this.subject).getArgumentFieldName();
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWEisInteraction.ArgumentPair)this.subject).setArgumentFieldName((String)value);
                }
            };
        }
    }
}

