/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.cell;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.eclipse.persistence.tools.workbench.uitools.cell.TreeCellEditorAdapter;

public class CheckBoxTreeCellRenderer
implements TreeCellEditorAdapter.Renderer {
    private JCheckBox checkBox;
    protected boolean editing = false;
    protected TreeCellEditorAdapter.ImmediateEditListener immediateEditListener;
    private static final Border NO_FOCUS_BORDER_LTR = BorderFactory.createEmptyBorder(2, 2, 2, 3);
    private static final Border NO_FOCUS_BORDER_RTL = BorderFactory.createEmptyBorder(2, 3, 2, 2);
    private static final Border INNER_FOCUS_BORDER_LTR = BorderFactory.createEmptyBorder(1, 1, 1, 2);
    private static final Border INNER_FOCUS_BORDER_RTL = BorderFactory.createEmptyBorder(1, 2, 1, 1);

    public CheckBoxTreeCellRenderer() {
        this.initialize();
    }

    public CheckBoxTreeCellRenderer(String text, Icon icon) {
        this();
        this.setText(text);
        this.setIcon(icon);
    }

    public CheckBoxTreeCellRenderer(String text) {
        this(text, null);
    }

    public CheckBoxTreeCellRenderer(Icon icon) {
        this(null, icon);
    }

    protected void initialize() {
        this.checkBox = this.buildCheckBox();
        this.checkBox.setBorderPainted(true);
        this.checkBox.setBorderPaintedFlat(true);
    }

    protected JCheckBox buildCheckBox() {
        JCheckBox cb = new JCheckBox();
        cb.addActionListener(this.buildActionListener());
        return cb;
    }

    private ActionListener buildActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CheckBoxTreeCellRenderer.this.immediateEditListener != null) {
                    CheckBoxTreeCellRenderer.this.immediateEditListener.immediateEdit();
                }
            }
        };
    }

    protected void setEditing(boolean editing) {
        this.editing = editing;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.checkBox.setHorizontalAlignment(10);
        this.checkBox.setComponentOrientation(tree.getComponentOrientation());
        this.checkBox.setFont(tree.getFont());
        this.checkBox.setEnabled(tree.isEnabled());
        this.checkBox.setForeground(this.foregroundColor(tree, value, selected, expanded, leaf, row, hasFocus));
        this.checkBox.setBackground(this.backgroundColor(tree, value, selected, expanded, leaf, row, hasFocus));
        this.checkBox.setOpaque(this.cellIsOpaqueIn(tree, value, selected, expanded, leaf, row, hasFocus));
        this.checkBox.setBorder(this.border(tree, value, selected, expanded, leaf, row, hasFocus));
        this.setValue(value);
        return this.checkBox;
    }

    protected Color foregroundColor(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (selected) {
            if (this.editing) {
                return UIManager.getColor("Tree.textForeground");
            }
            return UIManager.getColor("Tree.selectionForeground");
        }
        return UIManager.getColor("Tree.textForeground");
    }

    protected Color backgroundColor(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (selected) {
            if (this.editing) {
                return UIManager.getColor("Tree.textBackground");
            }
            return UIManager.getColor("Tree.selectionBackground");
        }
        return UIManager.getColor("Tree.textBackground");
    }

    protected Border border(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return hasFocus ? BorderFactory.createCompoundBorder(this.outerFocusBorder(), this.innerFocusBorder()) : this.noFocusBorder();
    }

    protected Border innerFocusBorder() {
        return this.checkBox.getComponentOrientation().isLeftToRight() ? INNER_FOCUS_BORDER_LTR : INNER_FOCUS_BORDER_RTL;
    }

    protected Border outerFocusBorder() {
        return this.editing ? UIManager.getBorder("Tree.editorBorder") : BorderFactory.createLineBorder(UIManager.getColor("Tree.selectionBorderColor"), 1);
    }

    protected Border noFocusBorder() {
        return this.checkBox.getComponentOrientation().isLeftToRight() ? NO_FOCUS_BORDER_LTR : NO_FOCUS_BORDER_RTL;
    }

    protected boolean cellIsOpaqueIn(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Color cellBackground = this.checkBox.getBackground();
        Color treeBackground = tree.getBackground();
        return !tree.isOpaque() || !cellBackground.equals(treeBackground);
    }

    protected void setValue(Object value) {
        this.checkBox.setSelected((Boolean)value);
    }

    @Override
    public Object getValue() {
        return this.checkBox.isSelected();
    }

    @Override
    public void setImmediateEditListener(TreeCellEditorAdapter.ImmediateEditListener listener) {
        this.immediateEditListener = listener;
    }

    public void setText(String text) {
        this.checkBox.setText(text);
    }

    public void setIcon(Icon icon) {
        this.checkBox.setIcon(icon);
    }

    public int getPreferredHeight() {
        return (int)this.checkBox.getPreferredSize().getHeight() + 4;
    }

    protected void addActionListener(ActionListener listener) {
        this.checkBox.addActionListener(listener);
    }
}

