/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBasicExpression;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgumentElement;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgumentParent;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWQueryableArgument
extends MWArgument {
    private volatile MWQueryableArgumentElement queryableArgumentElement;
    public static final String QUERYABLE_ARGUMENT_ELEMENT_PROPERTY = "queryableArgumentElement";

    private MWQueryableArgument() {
    }

    MWQueryableArgument(MWQueryableArgumentParent parent) {
        super(parent);
    }

    MWQueryableArgument(MWQueryableArgumentParent parent, MWQueryable queryable) {
        this(parent);
        this.setQueryableArgument(queryable);
    }

    MWQueryableArgument(MWQueryableArgumentParent parent, Iterator queryables) {
        this(parent);
        this.setQueryableArgument(queryables);
    }

    MWQueryableArgument(MWQueryableArgumentParent parent, Iterator queryables, Iterator allowsNull) {
        this(parent);
        this.setQueryableArgument(queryables, allowsNull);
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.queryableArgumentElement);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.queryableArgumentElement = new MWQueryableArgumentElement(this);
    }

    @Override
    public String getType() {
        return "queryKey";
    }

    @Override
    public String displayString() {
        return this.getQueryableArgumentElement().displayString();
    }

    @Override
    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        this.checkQueryable(currentProblems);
    }

    private void checkQueryable(List currentProblems) {
        MWQueryable queryable = this.getQueryableArgumentElement().getQueryable();
        if (queryable == null) {
            this.getQueryableArgumentParent().addQueryableNullProblemTo(currentProblems);
        } else if (!this.getQueryableArgumentParent().isQueryableValid(queryable)) {
            currentProblems.add(this.getQueryableArgumentParent().queryableInvalidProblem(queryable));
        }
    }

    @Override
    public void nodeRemoved(Node node) {
        super.nodeRemoved(node);
        if (node instanceof MWMapping) {
            this.mappingReplaced((MWMapping)node, null);
        }
        if (node instanceof MWQueryKey) {
            for (MWQueryableArgumentElement queryableArgumentElement = this.getQueryableArgumentElement().getJoinedQueryableElement(); queryableArgumentElement != null; queryableArgumentElement = queryableArgumentElement.getJoinedQueryableElement()) {
                if (queryableArgumentElement.getQueryable() != null && !queryableArgumentElement.getQueryable().isLeaf(Filter.NULL_INSTANCE)) continue;
                this.getQueryableArgumentElement().setQueryableToNull();
                break;
            }
        }
    }

    @Override
    public void descriptorUnmapped(Collection mappings) {
        super.descriptorUnmapped(mappings);
        Iterator stream = mappings.iterator();
        while (stream.hasNext()) {
            this.mappingReplaced((MWMapping)stream.next(), null);
        }
    }

    @Override
    public void mappingReplaced(MWMapping oldMapping, MWMapping newMapping) {
        super.mappingReplaced(oldMapping, newMapping);
        for (MWQueryableArgumentElement queryableArgumentElement = this.getQueryableArgumentElement().getJoinedQueryableElement(); queryableArgumentElement != null; queryableArgumentElement = queryableArgumentElement.getJoinedQueryableElement()) {
            if (queryableArgumentElement.getQueryable() != null && !queryableArgumentElement.getQueryable().isLeaf(Filter.NULL_INSTANCE)) continue;
            this.getQueryableArgumentElement().setQueryableToNull();
            break;
        }
    }

    @Override
    public void undoChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == QUERYABLE_ARGUMENT_ELEMENT_PROPERTY) {
            this.setQueryableArgumentElement((MWQueryableArgumentElement)oldValue);
        }
    }

    public MWQueryableArgumentElement getQueryableArgumentElement() {
        return this.queryableArgumentElement;
    }

    public void setQueryableArgument(MWQueryable queryable) {
        ArrayList<MWQueryable> queryables = new ArrayList<MWQueryable>();
        queryables.add(queryable);
        this.setQueryableArgument(queryables.iterator());
    }

    public void setQueryableArgument(Iterator queryables, Iterator allowsNull) {
        if (!queryables.hasNext()) {
            throw new UnsupportedOperationException();
        }
        MWQueryable queryable = (MWQueryable)queryables.next();
        queryables.remove();
        MWQueryableArgumentElement queryableArgumentElement = new MWQueryableArgumentElement(this, queryable);
        if (allowsNull.hasNext()) {
            queryableArgumentElement.setAllowsNull((Boolean)allowsNull.next());
            allowsNull.remove();
        }
        if (queryables.hasNext()) {
            queryableArgumentElement.setJoinedQueryable(queryables, allowsNull);
        }
        this.setQueryableArgumentElement(queryableArgumentElement);
    }

    public void setQueryableArgument(Iterator queryables) {
        this.setQueryableArgument(queryables, NullIterator.instance());
    }

    private void setQueryableArgumentElement(MWQueryableArgumentElement element) {
        MWQueryableArgumentElement oldElement = this.getQueryableArgumentElement();
        this.queryableArgumentElement = element;
        this.firePropertyChanged(QUERYABLE_ARGUMENT_ELEMENT_PROPERTY, oldElement, element);
        this.getQueryableArgumentParent().propertyChanged(this, QUERYABLE_ARGUMENT_ELEMENT_PROPERTY, oldElement, element);
    }

    @Override
    void recalculateQueryables() {
        MWQueryableArgumentElement element = this.getQueryableArgumentElement();
        while (element.getJoinedQueryableElement() != null) {
            if (!element.getJoinedQueryableElement().getQueryable().subQueryableElements(Filter.NULL_INSTANCE).contains(element.getQueryable())) {
                this.getQueryableArgumentElement().setQueryableToNull();
                break;
            }
            element = element.getJoinedQueryableElement();
        }
        if (!((MWRelationalDescriptor)((Object)this.getQueryableArgumentParent().getParentQuery().getOwningDescriptor())).getQueryables(Filter.NULL_INSTANCE).contains(element.getQueryable())) {
            this.getQueryableArgumentElement().setQueryableToNull();
        }
    }

    @Override
    public void toString(StringBuffer sb) {
        super.toString(sb);
        sb.append(this.getQueryableArgumentElement());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWQueryableArgument.class);
        descriptor.getInheritancePolicy().setParentClass(MWArgument.class);
        XMLCompositeObjectMapping queryableArgumentElementMapping = new XMLCompositeObjectMapping();
        queryableArgumentElementMapping.setAttributeName(QUERYABLE_ARGUMENT_ELEMENT_PROPERTY);
        queryableArgumentElementMapping.setReferenceClass(MWQueryableArgumentElement.class);
        queryableArgumentElementMapping.setXPath("queryable-argument-element");
        descriptor.addMapping((DatabaseMapping)queryableArgumentElementMapping);
        return descriptor;
    }

    @Override
    Expression runtimeExpression(ExpressionBuilder builder) {
        return this.queryableArgumentElement.convertToRuntime(builder);
    }

    static MWQueryableArgument convertFromRuntime(MWBasicExpression bldrExpression, QueryKeyExpression runtimeExpression) {
        MWQueryableArgument newArgument = new MWQueryableArgument(bldrExpression);
        ArrayList<String> queryableNames = new ArrayList<String>();
        ArrayList<Boolean> allowsNullList = new ArrayList<Boolean>();
        queryableNames.add(0, runtimeExpression.getName());
        allowsNullList.add(0, runtimeExpression.shouldUseOuterJoin());
        while (runtimeExpression.getBaseExpression().isQueryKeyExpression()) {
            runtimeExpression = (QueryKeyExpression)runtimeExpression.getBaseExpression();
            queryableNames.add(0, runtimeExpression.getName());
            allowsNullList.add(runtimeExpression.shouldUseOuterJoin());
        }
        String currentQueryableName = (String)queryableNames.remove(0);
        MWQueryable currentQueryable = ((MWTableDescriptor)newArgument.getQueryableArgumentParent().getParentQuery().getOwningDescriptor()).queryableNamed(currentQueryableName);
        ArrayList<MWQueryable> queryables = new ArrayList<MWQueryable>();
        queryables.add(0, currentQueryable);
        while (queryableNames.size() > 0) {
            Iterator subQueryableElements = currentQueryable.subQueryableElements(Filter.NULL_INSTANCE).iterator();
            String queryableName = (String)queryableNames.remove(0);
            while (subQueryableElements.hasNext()) {
                MWQueryable queryable = (MWQueryable)subQueryableElements.next();
                if (!queryable.getName().equals(queryableName)) continue;
                currentQueryable = queryable;
                break;
            }
            queryables.add(0, currentQueryable);
        }
        newArgument.setQueryableArgument(queryables.iterator(), allowsNullList.iterator());
        return newArgument;
    }
}

