/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.commons;

import java.util.Stack;
import org.eclipse.persistence.internal.libraries.asm.commons.Remapper;
import org.eclipse.persistence.internal.libraries.asm.signature.SignatureVisitor;

public class SignatureRemapper
extends SignatureVisitor {
    private final SignatureVisitor v;
    private final Remapper remapper;
    private Stack<String> classNames = new Stack();

    public SignatureRemapper(SignatureVisitor signatureVisitor, Remapper remapper) {
        this(393216, signatureVisitor, remapper);
    }

    protected SignatureRemapper(int n, SignatureVisitor signatureVisitor, Remapper remapper) {
        super(n);
        this.v = signatureVisitor;
        this.remapper = remapper;
    }

    @Override
    public void visitClassType(String string) {
        this.classNames.push(string);
        this.v.visitClassType(this.remapper.mapType(string));
    }

    @Override
    public void visitInnerClassType(String string) {
        String string2 = this.classNames.pop();
        String string3 = string2 + '$' + string;
        this.classNames.push(string3);
        String string4 = this.remapper.mapType(string2) + '$';
        String string5 = this.remapper.mapType(string3);
        int n = string5.startsWith(string4) ? string4.length() : string5.lastIndexOf(36) + 1;
        this.v.visitInnerClassType(string5.substring(n));
    }

    @Override
    public void visitFormalTypeParameter(String string) {
        this.v.visitFormalTypeParameter(string);
    }

    @Override
    public void visitTypeVariable(String string) {
        this.v.visitTypeVariable(string);
    }

    @Override
    public SignatureVisitor visitArrayType() {
        this.v.visitArrayType();
        return this;
    }

    @Override
    public void visitBaseType(char c) {
        this.v.visitBaseType(c);
    }

    @Override
    public SignatureVisitor visitClassBound() {
        this.v.visitClassBound();
        return this;
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        this.v.visitExceptionType();
        return this;
    }

    @Override
    public SignatureVisitor visitInterface() {
        this.v.visitInterface();
        return this;
    }

    @Override
    public SignatureVisitor visitInterfaceBound() {
        this.v.visitInterfaceBound();
        return this;
    }

    @Override
    public SignatureVisitor visitParameterType() {
        this.v.visitParameterType();
        return this;
    }

    @Override
    public SignatureVisitor visitReturnType() {
        this.v.visitReturnType();
        return this;
    }

    @Override
    public SignatureVisitor visitSuperclass() {
        this.v.visitSuperclass();
        return this;
    }

    @Override
    public void visitTypeArgument() {
        this.v.visitTypeArgument();
    }

    @Override
    public SignatureVisitor visitTypeArgument(char c) {
        this.v.visitTypeArgument(c);
        return this;
    }

    @Override
    public void visitEnd() {
        this.v.visitEnd();
        this.classNames.pop();
    }
}

