/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.optimizer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.FieldVisitor;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;

public class JarOptimizer {
    static final Set<String> API = new HashSet<String>();
    static final Map<String, String> HIERARCHY = new HashMap<String, String>();
    static boolean nodebug = false;

    public static void main(String[] stringArray) throws IOException {
        String string;
        File file = new File(stringArray[0]);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(new FileInputStream(file));
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(gZIPInputStream));
        while ((string = ((BufferedReader)lineNumberReader).readLine()) != null) {
            if (string.startsWith("class")) {
                String string2 = string.substring(6, string.lastIndexOf(32));
                String string3 = string.substring(string.lastIndexOf(32) + 1);
                HIERARCHY.put(string2, string3);
                continue;
            }
            API.add(string);
        }
        int n = 1;
        if (stringArray[n].equals("-nodebug")) {
            nodebug = true;
            ++n;
        }
        JarOptimizer.optimize(new File(stringArray[n]));
    }

    static void optimize(File file) throws IOException {
        if (nodebug && file.getName().contains("debug")) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                JarOptimizer.optimize(fileArray[i]);
            }
        } else if (file.getName().endsWith(".jar")) {
            File file2 = new File(file.getParentFile(), file.getName() + ".new");
            ZipFile zipFile = new ZipFile(file);
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            byte[] byArray = new byte[10000];
            while (enumeration.hasMoreElements()) {
                int n;
                Object object;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) {
                    zipOutputStream.putNextEntry(zipEntry);
                    continue;
                }
                zipOutputStream.putNextEntry(zipEntry);
                if (zipEntry.getName().endsWith(".class")) {
                    object = new ClassReader(zipFile.getInputStream(zipEntry));
                    ((ClassReader)object).accept(new ClassVerifier(), 0);
                }
                object = zipFile.getInputStream(zipEntry);
                do {
                    if ((n = ((InputStream)object).read(byArray, 0, byArray.length)) == -1) continue;
                    zipOutputStream.write(byArray, 0, n);
                } while (n != -1);
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
            zipFile.close();
            if (!file.delete()) {
                throw new IOException("Cannot delete file " + file);
            }
            if (!file2.renameTo(file)) {
                throw new IOException("Cannot rename file " + file2);
            }
        }
    }

    static class ClassVerifier
    extends ClassVisitor {
        String owner;
        String method;

        public ClassVerifier() {
            super(393216);
        }

        @Override
        public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
            this.owner = string;
        }

        @Override
        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            this.method = string + string2;
            return new MethodVisitor(393216){

                @Override
                public void visitFieldInsn(int n, String string, String string2, String string3) {
                    ClassVerifier.this.check(string, string2);
                }

                @Override
                public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
                    ClassVerifier.this.check(string, string2 + string3);
                }
            };
        }

        void check(String string, String string2) {
            if (string.startsWith("java/")) {
                String string3 = string;
                while (string3 != null) {
                    if (API.contains(string3 + ' ' + string2)) {
                        return;
                    }
                    string3 = HIERARCHY.get(string3);
                }
                System.out.println("WARNING: " + string + ' ' + string2 + " called in " + this.owner + ' ' + this.method + " is not defined in JDK 1.3 API");
            }
        }
    }

    static class ClassDump
    extends ClassVisitor {
        String owner;

        public ClassDump() {
            super(393216);
        }

        @Override
        public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
            this.owner = string;
            if (this.owner.startsWith("java/")) {
                System.out.println("class " + string + ' ' + string3);
            }
        }

        @Override
        public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
            if (this.owner.startsWith("java/")) {
                System.out.println(this.owner + ' ' + string);
            }
            return null;
        }

        @Override
        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            if (this.owner.startsWith("java/")) {
                System.out.println(this.owner + ' ' + string + string2);
            }
            return null;
        }
    }
}

