/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.annotations.CacheKeyType;
import org.eclipse.persistence.annotations.IdValidation;
import org.eclipse.persistence.config.CacheIsolationType;
import org.eclipse.persistence.core.descriptors.CoreDescriptor;
import org.eclipse.persistence.descriptors.AllFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.CachePolicy;
import org.eclipse.persistence.descriptors.ChangedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventManager;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.descriptors.FieldsLockingPolicy;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.descriptors.InterfacePolicy;
import org.eclipse.persistence.descriptors.MultitenantPolicy;
import org.eclipse.persistence.descriptors.ReturningPolicy;
import org.eclipse.persistence.descriptors.SelectedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.SerializedObjectPolicy;
import org.eclipse.persistence.descriptors.TablePerClassPolicy;
import org.eclipse.persistence.descriptors.TablePerMultitenantPolicy;
import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.descriptors.WrapperPolicy;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.DeferredChangeDetectionPolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.descriptors.copying.CloneCopyPolicy;
import org.eclipse.persistence.descriptors.copying.CopyPolicy;
import org.eclipse.persistence.descriptors.copying.InstantiationCopyPolicy;
import org.eclipse.persistence.descriptors.copying.PersistenceEntityCopyPolicy;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.NoExpiryCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.HistoryPolicy;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.CascadeLockingPolicy;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.descriptors.PersistenceObjectAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.PersistenceObjectInstantiationPolicy;
import org.eclipse.persistence.internal.descriptors.SerializedObjectPolicyWrapper;
import org.eclipse.persistence.internal.descriptors.VirtualAttributeMethodInfo;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.MappingCompare;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.ManyToOneMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.UnidirectionalOneToManyMapping;
import org.eclipse.persistence.mappings.foundation.AbstractColumnMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.querykeys.DirectQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public class ClassDescriptor
extends CoreDescriptor<AttributeGroup, DescriptorEventManager, DatabaseField, InheritancePolicy, InstantiationPolicy, Vector, ObjectBuilder>
implements Cloneable,
Serializable {
    protected Class javaClass;
    protected String javaClassName;
    protected Vector<DatabaseTable> tables = NonSynchronizedVector.newInstance(3);
    protected transient DatabaseTable defaultTable;
    protected List<DatabaseField> primaryKeyFields;
    protected Map<DatabaseTable, Map<DatabaseField, DatabaseField>> additionalTablePrimaryKeyFields;
    protected transient List<DatabaseTable> multipleTableInsertOrder;
    protected Map<DatabaseTable, Set<DatabaseTable>> multipleTableForeignKeys;
    protected boolean isCascadeOnDeleteSetOnDatabaseOnSecondaryTables;
    protected transient Vector<DatabaseField> fields;
    protected transient Vector<DatabaseField> allFields;
    protected transient List<DatabaseField> selectionFields;
    protected transient List<DatabaseField> allSelectionFields;
    protected Vector<DatabaseMapping> mappings = NonSynchronizedVector.newInstance();
    protected Set<ClassDescriptor> referencingClasses;
    protected List<DatabaseMapping> lockableMappings;
    protected Map<String, QueryKey> queryKeys;
    protected String sequenceNumberName;
    protected DatabaseField sequenceNumberField;
    protected transient String sessionName;
    protected transient Vector constraintDependencies;
    protected transient String amendmentMethodName;
    protected transient Class amendmentClass;
    protected String amendmentClassName;
    protected String alias;
    protected boolean shouldBeReadOnly = false;
    protected boolean shouldAlwaysConformResultsInUnitOfWork = false;
    protected boolean shouldRegisterResultsInUnitOfWork = true;
    protected DescriptorQueryManager queryManager;
    protected CopyPolicy copyPolicy;
    protected String copyPolicyClassName;
    protected InterfacePolicy interfacePolicy;
    protected OptimisticLockingPolicy optimisticLockingPolicy;
    protected List<CascadeLockingPolicy> cascadeLockingPolicies;
    protected WrapperPolicy wrapperPolicy;
    protected ObjectChangePolicy changePolicy;
    protected ReturningPolicy returningPolicy;
    protected HistoryPolicy historyPolicy;
    protected String partitioningPolicyName;
    protected PartitioningPolicy partitioningPolicy;
    protected CMPPolicy cmpPolicy;
    protected CachePolicy cachePolicy;
    protected MultitenantPolicy multitenantPolicy;
    protected SerializedObjectPolicy serializedObjectPolicy;
    protected FetchGroupManager fetchGroupManager;
    protected Map properties;
    protected Map<String, List<String>> unconvertedProperties;
    protected transient int initializationStage = 0;
    protected transient int interfaceInitializationStage = 0;
    protected static final int UNINITIALIZED = 0;
    protected static final int PREINITIALIZED = 1;
    protected static final int INITIALIZED = 2;
    protected static final int POST_INITIALIZED = 3;
    protected static final int ERROR = -1;
    protected int descriptorType = 0;
    protected static final int NORMAL = 0;
    protected static final int INTERFACE = 1;
    protected static final int AGGREGATE = 2;
    protected static final int AGGREGATE_COLLECTION = 3;
    protected boolean shouldOrderMappings = true;
    protected CacheInvalidationPolicy cacheInvalidationPolicy = null;
    protected boolean shouldAcquireCascadedLocks = false;
    protected boolean cascadedLockingInitialized = false;
    protected boolean hasSimplePrimaryKey = false;
    protected boolean hasMultipleTableConstraintDependecy = false;
    public static final int UNDEFINED_OBJECT_CHANGE_BEHAVIOR = 0;
    public static final int SEND_OBJECT_CHANGES = 1;
    public static final int INVALIDATE_CHANGED_OBJECTS = 2;
    public static final int SEND_NEW_OBJECTS_WITH_CHANGES = 3;
    public static final int DO_NOT_SEND_CHANGES = 4;
    public static final int UNDEFINED_ISOLATATION = -1;
    public static final int USE_SESSION_CACHE_AFTER_TRANSACTION = 0;
    public static final int ISOLATE_NEW_DATA_AFTER_TRANSACTION = 1;
    public static final int ISOLATE_CACHE_AFTER_TRANSACTION = 2;
    public static final int ISOLATE_FROM_CLIENT_SESSION = 3;
    public static final int ISOLATE_CACHE_ALWAYS = 4;
    public static boolean shouldUseFullChangeSetsForNewObjects = false;
    protected boolean isNativeConnectionRequired;
    protected IdValidation idValidation;
    protected List<IdValidation> primaryKeyIdValidations;
    protected Map<String, DatabaseMapping> derivesIdMappings;
    protected QueryRedirector defaultQueryRedirector;
    protected QueryRedirector defaultReadAllQueryRedirector;
    protected QueryRedirector defaultReadObjectQueryRedirector;
    protected QueryRedirector defaultReportQueryRedirector;
    protected QueryRedirector defaultUpdateObjectQueryRedirector;
    protected QueryRedirector defaultInsertObjectQueryRedirector;
    protected QueryRedirector defaultDeleteObjectQueryRedirector;
    protected String defaultQueryRedirectorClassName;
    protected String defaultReadAllQueryRedirectorClassName;
    protected String defaultReadObjectQueryRedirectorClassName;
    protected String defaultReportQueryRedirectorClassName;
    protected String defaultUpdateObjectQueryRedirectorClassName;
    protected String defaultInsertObjectQueryRedirectorClassName;
    protected String defaultDeleteObjectQueryRedirectorClassName;
    protected Sequence sequence;
    protected List<DatabaseMapping> mappingsPostCalculateChanges;
    protected List<DatabaseMapping> mappingsPostCalculateChangesOnDeleted;
    protected transient List<DatabaseField> additionalAggregateCollectionKeyFields;
    protected List<DatabaseMapping> preDeleteMappings;
    protected transient List<DatabaseField> additionalWritableMapKeyFields;
    protected boolean hasRelationships = false;
    protected Set<DatabaseField> foreignKeyValuesForCaching;
    protected boolean hasNoncacheableMappings = false;
    protected boolean weavingUsesPropertyAccess = false;
    protected List<VirtualAttributeMethodInfo> virtualAttributeMethods = null;
    protected List<AttributeAccessor> accessorTree;
    protected String descriptorCustomizerClassName;
    protected boolean shouldLockForClone = true;

    public ClassDescriptor() {
        this.primaryKeyFields = new ArrayList<DatabaseField>(2);
        this.fields = NonSynchronizedVector.newInstance();
        this.allFields = NonSynchronizedVector.newInstance();
        this.constraintDependencies = NonSynchronizedVector.newInstance(2);
        this.multipleTableForeignKeys = new HashMap<DatabaseTable, Set<DatabaseTable>>(5);
        this.queryKeys = new HashMap<String, QueryKey>(5);
        this.derivesIdMappings = new HashMap<String, DatabaseMapping>(5);
        this.referencingClasses = new HashSet<ClassDescriptor>();
        this.objectBuilder = new ObjectBuilder(this);
        this.cachePolicy = new CachePolicy();
        this.additionalWritableMapKeyFields = new ArrayList<DatabaseField>(2);
        this.foreignKeyValuesForCaching = new HashSet<DatabaseField>();
    }

    public void addAbstractQueryKey(String queryKeyName) {
        QueryKey queryKey = new QueryKey();
        queryKey.setName(queryKeyName);
        this.addQueryKey(queryKey);
    }

    public void addCascadeLockingPolicy(CascadeLockingPolicy policy) {
        this.getCascadeLockingPolicies().add(policy);
        if (this.hasInheritance()) {
            for (ClassDescriptor parent : this.getInheritancePolicy().getAllChildDescriptors()) {
                parent.addCascadeLockingPolicy(policy);
            }
        }
        if (!this.cascadedLockingInitialized && this.isInitialized(2)) {
            for (DatabaseMapping mapping : this.getMappings()) {
                this.prepareCascadeLockingPolicy(mapping);
            }
            this.cascadedLockingInitialized = true;
        }
    }

    public void addConstraintDependencies(Class dependencies) {
        this.addConstraintDependency(dependencies);
    }

    public void addConstraintDependency(Class dependencies) {
        this.getConstraintDependencies().add(dependencies);
    }

    public AbstractDirectMapping newDirectMapping() {
        return new DirectToFieldMapping();
    }

    public AggregateMapping newAggregateMapping() {
        return new AggregateObjectMapping();
    }

    public DatabaseMapping newAggregateCollectionMapping() {
        return new AggregateCollectionMapping();
    }

    public DatabaseMapping newDirectCollectionMapping() {
        return new DirectCollectionMapping();
    }

    public ObjectReferenceMapping newOneToOneMapping() {
        OneToOneMapping mapping = new OneToOneMapping();
        mapping.setIsOneToOneRelationship(true);
        return mapping;
    }

    public ObjectReferenceMapping newManyToOneMapping() {
        return new ManyToOneMapping();
    }

    public CollectionMapping newOneToManyMapping() {
        return new OneToManyMapping();
    }

    public CollectionMapping newUnidirectionalOneToManyMapping() {
        return new UnidirectionalOneToManyMapping();
    }

    public CollectionMapping newManyToManyMapping() {
        return new ManyToManyMapping();
    }

    public DatabaseMapping addDirectMapping(String attributeName, String fieldName) {
        AbstractDirectMapping mapping = this.newDirectMapping();
        mapping.setAttributeName(attributeName);
        mapping.setField(new DatabaseField(fieldName));
        return this.addMapping(mapping);
    }

    public DatabaseMapping addDirectMapping(String attributeName, String getMethodName, String setMethodName, String fieldName) {
        AbstractDirectMapping mapping = (AbstractDirectMapping)this.addDirectMapping(attributeName, fieldName);
        mapping.setSetMethodName(setMethodName);
        mapping.setGetMethodName(getMethodName);
        return mapping;
    }

    public void addDirectQueryKey(String queryKeyName, String fieldName) {
        DirectQueryKey queryKey = new DirectQueryKey();
        DatabaseField field = new DatabaseField(fieldName);
        queryKey.setName(queryKeyName);
        queryKey.setField(field);
        this.getQueryKeys().put(queryKeyName, queryKey);
    }

    public void addForeignKeyFieldNameForMultipleTable(String sourceForeignKeyFieldName, String targetPrimaryKeyFieldName) throws DescriptorException {
        this.addForeignKeyFieldForMultipleTable(new DatabaseField(sourceForeignKeyFieldName), new DatabaseField(targetPrimaryKeyFieldName));
    }

    public void addForeignKeyFieldForMultipleTable(DatabaseField sourceForeignKeyField, DatabaseField targetPrimaryKeyField) throws DescriptorException {
        if (!sourceForeignKeyField.hasTableName() || !targetPrimaryKeyField.hasTableName()) {
            throw DescriptorException.multipleTablePrimaryKeyMustBeFullyQualified(this);
        }
        this.setAdditionalTablePrimaryKeyFields(sourceForeignKeyField.getTable(), targetPrimaryKeyField, sourceForeignKeyField);
        Set<DatabaseTable> sourceTables = this.getMultipleTableForeignKeys().get(targetPrimaryKeyField.getTable());
        if (sourceTables == null) {
            sourceTables = new HashSet<DatabaseTable>(3);
            this.getMultipleTableForeignKeys().put(targetPrimaryKeyField.getTable(), sourceTables);
        }
        sourceTables.add(sourceForeignKeyField.getTable());
    }

    public DatabaseMapping addMapping(DatabaseMapping mapping) {
        if (mapping.getDescriptor() == null) {
            mapping.setDescriptor(this);
        }
        this.getMappings().add(mapping);
        return mapping;
    }

    protected void validateMappingType(DatabaseMapping mapping) {
        if (!mapping.isRelationalMapping()) {
            throw DescriptorException.invalidMappingType(mapping);
        }
    }

    public void addPrimaryKeyFieldName(String fieldName) {
        this.addPrimaryKeyField(new DatabaseField(fieldName));
    }

    public void addPrimaryKeyField(DatabaseField field) {
        this.getPrimaryKeyFields().add(field);
    }

    public void addQueryKey(QueryKey queryKey) {
        this.getQueryKeys().put(queryKey.getName(), queryKey);
    }

    public void addTable(DatabaseTable table) {
        this.getTables().add(table);
    }

    public void addTableName(String tableName) {
        this.addTable(new DatabaseTable(tableName));
    }

    public void addUnconvertedProperty(String propertyName, String propertyValue, String propertyType) {
        ArrayList<String> valuePair = new ArrayList<String>(2);
        valuePair.add(propertyValue);
        valuePair.add(propertyType);
        this.getUnconvertedProperties().put(propertyName, valuePair);
    }

    public void adjustMultipleTableInsertOrder() {
        if (this.getMultipleTableInsertOrder() == null || this.getMultipleTableInsertOrder().isEmpty()) {
            this.createMultipleTableInsertOrder();
        } else {
            this.verifyMultipleTableInsertOrder();
        }
        this.toggleAdditionalTablePrimaryKeyFields();
    }

    public void alwaysConformResultsInUnitOfWork() {
        this.setShouldAlwaysConformResultsInUnitOfWork(true);
    }

    public void alwaysRefreshCache() {
        this.setShouldAlwaysRefreshCache(true);
    }

    public void alwaysRefreshCacheOnRemote() {
        this.setShouldAlwaysRefreshCacheOnRemote(true);
    }

    public void applyAmendmentMethod() {
        this.applyAmendmentMethod(null);
    }

    public void applyAmendmentMethod(DescriptorEvent event) {
        if (this.getAmendmentClass() == null || this.getAmendmentMethodName() == null) {
            return;
        }
        Method method = null;
        Class[] argTypes = new Class[]{ClassDescriptor.class};
        try {
            method = Helper.getDeclaredMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), argTypes);
        }
        catch (Exception exception) {
            argTypes[0] = ClassDescriptor.class;
            try {
                method = Helper.getDeclaredMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), argTypes);
            }
            catch (Exception exception2) {
                throw DescriptorException.invalidAmendmentMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), exception2, this);
            }
        }
        Object[] args = new Object[]{this};
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                AccessController.doPrivileged(new PrivilegedMethodInvoker(method, null, args));
            } else {
                PrivilegedAccessHelper.invokeMethod(method, null, args);
            }
        }
        catch (Exception exception) {
            throw DescriptorException.errorOccuredInAmendmentMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), exception, this);
        }
    }

    public boolean arePrimaryKeyFields(Vector fields) {
        if (fields.size() != this.getPrimaryKeyFields().size()) {
            return false;
        }
        Enumeration enumFields = fields.elements();
        while (enumFields.hasMoreElements()) {
            DatabaseField field = (DatabaseField)enumFields.nextElement();
            if (this.getPrimaryKeyFields().contains(field)) continue;
            return false;
        }
        return true;
    }

    protected void assignDefaultValues(AbstractSession session) {
        if (this.idValidation == null) {
            this.idValidation = session.getProject().getDefaultIdValidation();
        }
        this.getCachePolicy().assignDefaultValues(session);
    }

    public Expression buildBatchCriteriaByPK(ExpressionBuilder builder, ObjectLevelReadQuery query) {
        int size = this.getPrimaryKeyFields().size();
        if (size > 1) {
            ArrayList<Expression> fields = new ArrayList<Expression>(size);
            for (DatabaseField targetForeignKeyField : this.primaryKeyFields) {
                fields.add(builder.getField(targetForeignKeyField));
            }
            return query.getSession().getPlatform().buildBatchCriteriaForComplexId(builder, fields);
        }
        return query.getSession().getPlatform().buildBatchCriteria(builder, builder.getField(this.primaryKeyFields.get(0)));
    }

    public DatasourceCall buildCallFromStatement(SQLStatement statement, DatabaseQuery query, AbstractSession session) {
        DatabaseCall call = statement.buildCall(session);
        if (this.isNativeConnectionRequired()) {
            call.setIsNativeConnectionRequired(true);
        }
        return call;
    }

    public Vector buildDirectValuesFromFieldValue(Object fieldValue) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public DatabaseField buildField(String fieldName) {
        DatabaseField field = new DatabaseField(fieldName);
        DatabaseTable table = field.hasTableName() ? this.getTable(field.getTableName()) : (this.getDefaultTable() != null ? this.getDefaultTable() : this.getTable(this.getTableName()));
        field.setTable(table);
        return field;
    }

    public DatabaseField buildField(DatabaseField field) {
        return this.buildField(field, null);
    }

    public DatabaseField buildField(DatabaseField field, DatabaseTable relationTable) {
        DatabaseField builtField = this.getObjectBuilder().getFieldsMap().get(field);
        if (builtField == null) {
            builtField = field;
            DatabaseTable table = relationTable != null && field.hasTableName() && field.getTableName().equals(relationTable.getName()) ? relationTable : (relationTable != null && !field.hasTableName() ? relationTable : (field.hasTableName() ? this.getTable(field.getTableName()) : this.getDefaultTable()));
            field.setTable(table);
            this.getObjectBuilder().getFieldsMap().put(builtField, builtField);
        }
        return builtField;
    }

    public Object buildFieldValueFromDirectValues(Vector directValues, String elementDataTypeName, AbstractSession session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Object buildFieldValueFromForeignKeys(Vector foreignKeys, String referenceDataTypeName, AbstractSession session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Object buildFieldValueFromNestedRow(AbstractRecord nestedRow, AbstractSession session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Object buildFieldValueFromNestedRows(Vector nestedRows, String structureName, AbstractSession session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public AbstractRecord buildNestedRowFromFieldValue(Object fieldValue) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Vector buildNestedRowsFromFieldValue(Object fieldValue, AbstractSession session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    protected void checkDatabase(AbstractSession session) {
        if (session.getIntegrityChecker().shouldCheckDatabase()) {
            for (DatabaseTable table : this.getTables()) {
                if (session.getIntegrityChecker().checkTable(table, session)) {
                    ArrayList<Object> databaseFields = new ArrayList<Object>();
                    Vector result = session.getAccessor().getColumnInfo(null, null, table.getName(), null, session);
                    if (result.isEmpty() && session.getPlatform().shouldForceFieldNamesToUpperCase()) {
                        result = session.getAccessor().getColumnInfo(null, null, table.getName().toLowerCase(), null, session);
                    }
                    for (AbstractRecord row : result) {
                        if (session.getPlatform().shouldForceFieldNamesToUpperCase()) {
                            databaseFields.add(((String)row.get("COLUMN_NAME")).toUpperCase());
                            continue;
                        }
                        databaseFields.add(row.get("COLUMN_NAME"));
                    }
                    for (DatabaseField field : this.getFields()) {
                        if (!field.getTable().equals(table) || databaseFields.contains(field.getName())) continue;
                        session.getIntegrityChecker().handleError(DescriptorException.fieldIsNotPresentInDatabase(this, table.getName(), field.getName()));
                    }
                    continue;
                }
                session.getIntegrityChecker().handleError(DescriptorException.tableIsNotPresentInDatabase(this));
            }
        }
    }

    public void checkInheritanceTreeAggregateSettings(AbstractSession session, AggregateMapping mapping) throws DescriptorException {
        if (!this.hasInheritance()) {
            return;
        }
        if (this.isChildDescriptor()) {
            Class parentClass = this.getInheritancePolicy().getParentClass();
            if (parentClass == this.getJavaClass()) {
                throw DescriptorException.parentClassIsSelf(this);
            }
            session.getDescriptor(parentClass).checkInheritanceTreeAggregateSettings(session, mapping);
        } else {
            this.checkInheritanceTreeAggregateSettingsForChildren(session, mapping);
        }
    }

    private void checkInheritanceTreeAggregateSettingsForChildren(AbstractSession session, AggregateMapping mapping) throws DescriptorException {
        if (!this.isAggregateDescriptor()) {
            session.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregate(this.getJavaClass().getName(), mapping));
        }
        for (ClassDescriptor childDescriptor : this.getInheritancePolicy().getChildDescriptors()) {
            childDescriptor.checkInheritanceTreeAggregateSettingsForChildren(session, mapping);
        }
    }

    protected void createMultipleTableInsertOrder() {
        int nParentTables = 0;
        if (this.isChildDescriptor()) {
            nParentTables = this.getInheritancePolicy().getParentDescriptor().getTables().size();
            this.setMultipleTableInsertOrder(new ArrayList<DatabaseTable>(this.getInheritancePolicy().getParentDescriptor().getMultipleTableInsertOrder()));
            if (nParentTables == this.getTables().size()) {
                return;
            }
        }
        if (this.getMultipleTableForeignKeys().isEmpty()) {
            if (nParentTables == 0) {
                this.setMultipleTableInsertOrder((Vector)this.getTables().clone());
            } else {
                int k = nParentTables;
                while (k < this.getTables().size()) {
                    this.getMultipleTableInsertOrder().add(this.getTables().get(k));
                    ++k;
                }
            }
            return;
        }
        this.verifyMultipleTablesForeignKeysTables();
        int[][] tableComparison = this.createTableComparison(this.getTables(), nParentTables);
        this.createMultipleTableInsertOrderFromComparison(tableComparison, nParentTables);
    }

    protected void verifyMultipleTableInsertOrder() {
        int nParentTables = 0;
        if (this.isChildDescriptor() && (nParentTables = this.getInheritancePolicy().getParentDescriptor().getTables().size()) + this.getMultipleTableInsertOrder().size() == this.getTables().size()) {
            List<DatabaseTable> childMultipleTableInsertOrder = this.getMultipleTableInsertOrder();
            this.setMultipleTableInsertOrder(new ArrayList<DatabaseTable>(this.getInheritancePolicy().getParentDescriptor().getMultipleTableInsertOrder()));
            this.getMultipleTableInsertOrder().addAll(childMultipleTableInsertOrder);
        }
        if (this.getMultipleTableInsertOrder().size() != this.getTables().size()) {
            throw DescriptorException.multipleTableInsertOrderMismatch(this);
        }
        if (nParentTables == this.getTables().size()) {
            return;
        }
        if (this.getMultipleTableForeignKeys().isEmpty()) {
            return;
        }
        this.verifyMultipleTablesForeignKeysTables();
        int[][] tableComparison = this.createTableComparison(this.getMultipleTableInsertOrder(), nParentTables);
        int i = nParentTables;
        while (i < this.getMultipleTableInsertOrder().size()) {
            int j = i + 1;
            while (j < this.getTables().size()) {
                if (tableComparison[i - nParentTables][j - nParentTables] > 0) {
                    throw DescriptorException.insertOrderConflictsWithMultipleTableForeignKeys(this, this.getMultipleTableInsertOrder().get(i), this.getMultipleTableInsertOrder().get(j));
                }
                ++j;
            }
            ++i;
        }
    }

    protected void verifyMultipleTablesForeignKeysTables() {
        for (Map.Entry<DatabaseTable, Set<DatabaseTable>> entry : this.getMultipleTableForeignKeys().entrySet()) {
            DatabaseTable targetTable = entry.getKey();
            if (this.getTables().indexOf(targetTable) == -1) {
                throw DescriptorException.illegalTableNameInMultipleTableForeignKeyField(this, targetTable);
            }
            for (DatabaseTable sourceTable : entry.getValue()) {
                if (this.getTables().indexOf(sourceTable) != -1) continue;
                throw DescriptorException.illegalTableNameInMultipleTableForeignKeyField(this, targetTable);
            }
        }
    }

    protected int[][] createTableComparison(List<DatabaseTable> tables, int nStart) {
        int nTables = tables.size();
        int[][] tableComparison = new int[nTables - nStart][nTables - nStart];
        for (Map.Entry<DatabaseTable, Set<DatabaseTable>> entry : this.getMultipleTableForeignKeys().entrySet()) {
            DatabaseTable targetTable = entry.getKey();
            int targetIndex = tables.indexOf(targetTable) - nStart;
            if (targetIndex < 0) continue;
            Set<DatabaseTable> sourceTables = entry.getValue();
            for (DatabaseTable sourceTable : sourceTables) {
                int sourceIndex = tables.indexOf(sourceTable) - nStart;
                if (sourceIndex >= 0) {
                    if (tableComparison[targetIndex][sourceIndex] == 1) {
                        throw DescriptorException.insertOrderCyclicalDependencyBetweenTwoTables(this, sourceTable, targetTable);
                    }
                    tableComparison[targetIndex][sourceIndex] = -1;
                    tableComparison[sourceIndex][targetIndex] = 1;
                    continue;
                }
                throw DescriptorException.insertOrderChildBeforeParent(this, sourceTable, targetTable);
            }
        }
        return tableComparison;
    }

    protected void createMultipleTableInsertOrderFromComparison(int[][] tableComparison, int nStart) {
        int[] tableOrder;
        int nTables = this.getTables().size();
        boolean bOk = this.createTableOrder(0, nTables - nStart, tableOrder = new int[nTables - nStart], tableComparison);
        if (bOk) {
            if (nStart == 0) {
                this.setMultipleTableInsertOrder(NonSynchronizedVector.newInstance(nTables));
            }
            int k = 0;
            while (k < nTables - nStart) {
                this.getMultipleTableInsertOrder().add(this.getTables().get(tableOrder[k] + nStart));
                ++k;
            }
        } else {
            throw DescriptorException.insertOrderCyclicalDependencyBetweenThreeOrMoreTables(this);
        }
    }

    protected boolean createTableOrder(int k, int nTables, int[] tableOrder, int[][] tableComparison) {
        if (k == nTables) {
            return true;
        }
        int[] iAvailable = new int[nTables - k];
        int l = 0;
        int i = 0;
        while (i < nTables) {
            boolean isUsed = false;
            int j = 0;
            while (j < k && !isUsed) {
                if (i == tableOrder[j]) {
                    isUsed = true;
                }
                ++j;
            }
            if (!isUsed) {
                iAvailable[l] = i;
                ++l;
            }
            ++i;
        }
        boolean bOk = false;
        int i2 = 0;
        while (i2 < nTables - k && !bOk) {
            boolean isSmallest = true;
            int j = 0;
            while (j < nTables - k && isSmallest) {
                if (i2 != j && tableComparison[iAvailable[i2]][iAvailable[j]] > 0) {
                    isSmallest = false;
                }
                ++j;
            }
            if (isSmallest) {
                tableOrder[k] = iAvailable[i2];
                bOk = this.createTableOrder(k + 1, nTables, tableOrder, tableComparison);
            }
            ++i2;
        }
        return bOk;
    }

    public Object clone() {
        ClassDescriptor clonedDescriptor = null;
        try {
            clonedDescriptor = (ClassDescriptor)super.clone();
        }
        catch (Exception exception) {}
        NonSynchronizedVector mappingsVector = NonSynchronizedVector.newInstance();
        Enumeration<DatabaseMapping> mappingsEnum = this.getMappings().elements();
        while (mappingsEnum.hasMoreElements()) {
            DatabaseMapping mapping = (DatabaseMapping)mappingsEnum.nextElement().clone();
            mapping.setDescriptor(clonedDescriptor);
            ((Vector)mappingsVector).addElement(mapping);
        }
        clonedDescriptor.setMappings(mappingsVector);
        HashMap<String, QueryKey> queryKeys = new HashMap<String, QueryKey>(this.getQueryKeys().size() + 2);
        for (QueryKey queryKey : this.getQueryKeys().values()) {
            queryKey = (QueryKey)queryKey.clone();
            queryKey.setDescriptor(clonedDescriptor);
            queryKeys.put(queryKey.getName(), queryKey);
        }
        clonedDescriptor.setQueryKeys(queryKeys);
        ArrayList<DatabaseField> primaryKeyVector = new ArrayList<DatabaseField>(this.getPrimaryKeyFields().size());
        List<DatabaseField> primaryKeyFields = this.getPrimaryKeyFields();
        int index = 0;
        while (index < primaryKeyFields.size()) {
            DatabaseField primaryKey = primaryKeyFields.get(index).clone();
            primaryKeyVector.add(primaryKey);
            ++index;
        }
        clonedDescriptor.setPrimaryKeyFields((List<DatabaseField>)primaryKeyVector);
        clonedDescriptor.setFields(NonSynchronizedVector.newInstance());
        if (clonedDescriptor.hasInheritance()) {
            clonedDescriptor.setInheritancePolicy((InheritancePolicy)this.getInheritancePolicy().clone());
            clonedDescriptor.getInheritancePolicy().setDescriptor(clonedDescriptor);
        }
        if (clonedDescriptor.hasSerializedObjectPolicy()) {
            clonedDescriptor.setSerializedObjectPolicy(this.getSerializedObjectPolicy().clone());
        }
        if (clonedDescriptor.hasReturningPolicy()) {
            clonedDescriptor.setReturningPolicy((ReturningPolicy)this.getReturningPolicy().clone());
            clonedDescriptor.getReturningPolicy().setDescriptor(clonedDescriptor);
        }
        clonedDescriptor.setObjectBuilder((ObjectBuilder)this.getObjectBuilder().clone());
        clonedDescriptor.getObjectBuilder().setDescriptor(clonedDescriptor);
        clonedDescriptor.setEventManager((DescriptorEventManager)this.getEventManager().clone());
        clonedDescriptor.getEventManager().setDescriptor(clonedDescriptor);
        clonedDescriptor.setQueryManager((DescriptorQueryManager)this.getQueryManager().clone());
        clonedDescriptor.getQueryManager().setDescriptor(clonedDescriptor);
        if (this.hasFetchGroupManager()) {
            clonedDescriptor.setFetchGroupManager((FetchGroupManager)this.getFetchGroupManager().clone());
        }
        if (this.cachePolicy != null) {
            clonedDescriptor.setCachePolicy(this.cachePolicy.clone());
        }
        if (this.instantiationPolicy != null) {
            clonedDescriptor.setInstantiationPolicy((InstantiationPolicy)this.getInstantiationPolicy().clone());
        }
        if (this.copyPolicy != null) {
            clonedDescriptor.setCopyPolicy((CopyPolicy)this.getCopyPolicy().clone());
        }
        if (this.getOptimisticLockingPolicy() != null) {
            clonedDescriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)this.getOptimisticLockingPolicy().clone());
        }
        clonedDescriptor.setObjectChangePolicy(this.getObjectChangePolicyInternal());
        NonSynchronizedVector tables = NonSynchronizedVector.newInstance(3);
        for (DatabaseTable table : this.getTables()) {
            ((Vector)tables).add(table.clone());
        }
        clonedDescriptor.setTables(tables);
        if (this.getDefaultTable() != null) {
            clonedDescriptor.setDefaultTable(this.getDefaultTable().clone());
        }
        if (this.getCMPPolicy() != null) {
            clonedDescriptor.setCMPPolicy(this.getCMPPolicy().clone());
            clonedDescriptor.getCMPPolicy().setDescriptor(clonedDescriptor);
        }
        if (this.getSequenceNumberField() != null) {
            clonedDescriptor.setSequenceNumberField(this.getSequenceNumberField().clone());
        }
        if (this.hasMultitenantPolicy()) {
            clonedDescriptor.setMultitenantPolicy(this.getMultitenantPolicy().clone(clonedDescriptor));
        }
        return clonedDescriptor;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        block120: {
            Class redirectorClass;
            block119: {
                block118: {
                    block117: {
                        block116: {
                            block115: {
                                block114: {
                                    redirectorClass = null;
                                    if (this.getJavaClassName() != null) {
                                        Class descriptorClass;
                                        block110: {
                                            descriptorClass = null;
                                            try {
                                                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                                    try {
                                                        descriptorClass = AccessController.doPrivileged(new PrivilegedClassForName(this.getJavaClassName(), true, classLoader));
                                                        break block110;
                                                    }
                                                    catch (PrivilegedActionException exception) {
                                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getJavaClassName(), exception.getException());
                                                    }
                                                }
                                                descriptorClass = PrivilegedAccessHelper.getClassForName(this.getJavaClassName(), true, classLoader);
                                            }
                                            catch (ClassNotFoundException exc) {
                                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.getJavaClassName(), exc);
                                            }
                                        }
                                        this.setJavaClass(descriptorClass);
                                    }
                                    if (this.getAmendmentClassName() != null) {
                                        Class amendmentClass;
                                        block111: {
                                            amendmentClass = null;
                                            try {
                                                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                                    try {
                                                        amendmentClass = AccessController.doPrivileged(new PrivilegedClassForName(this.getAmendmentClassName(), true, classLoader));
                                                        break block111;
                                                    }
                                                    catch (PrivilegedActionException exception) {
                                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getAmendmentClassName(), exception.getException());
                                                    }
                                                }
                                                amendmentClass = PrivilegedAccessHelper.getClassForName(this.getAmendmentClassName(), true, classLoader);
                                            }
                                            catch (ClassNotFoundException exc) {
                                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.getAmendmentClassName(), exc);
                                            }
                                        }
                                        this.setAmendmentClass(amendmentClass);
                                    }
                                    if (this.copyPolicy == null && this.getCopyPolicyClassName() != null) {
                                        CopyPolicy newCopyPolicy;
                                        block112: {
                                            Class copyPolicyClass = null;
                                            newCopyPolicy = null;
                                            try {
                                                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                                    try {
                                                        copyPolicyClass = AccessController.doPrivileged(new PrivilegedClassForName(this.getCopyPolicyClassName(), true, classLoader));
                                                    }
                                                    catch (PrivilegedActionException exception) {
                                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getCopyPolicyClassName(), exception.getException());
                                                    }
                                                    try {
                                                        newCopyPolicy = (CopyPolicy)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(copyPolicyClass));
                                                        break block112;
                                                    }
                                                    catch (PrivilegedActionException exception) {
                                                        throw ValidationException.reflectiveExceptionWhileCreatingClassInstance(this.getCopyPolicyClassName(), exception.getException());
                                                    }
                                                }
                                                copyPolicyClass = PrivilegedAccessHelper.getClassForName(this.getCopyPolicyClassName(), true, classLoader);
                                                newCopyPolicy = (CopyPolicy)PrivilegedAccessHelper.newInstanceFromClass(copyPolicyClass);
                                            }
                                            catch (ClassNotFoundException exc) {
                                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.getCopyPolicyClassName(), exc);
                                            }
                                            catch (IllegalAccessException ex) {
                                                throw ValidationException.reflectiveExceptionWhileCreatingClassInstance(this.getCopyPolicyClassName(), ex);
                                            }
                                            catch (InstantiationException e) {
                                                throw ValidationException.reflectiveExceptionWhileCreatingClassInstance(this.getCopyPolicyClassName(), e);
                                            }
                                        }
                                        this.setCopyPolicy(newCopyPolicy);
                                    }
                                    if (this.serializedObjectPolicy != null && this.serializedObjectPolicy instanceof SerializedObjectPolicyWrapper) {
                                        SerializedObjectPolicy newSerializedObjectPolicy;
                                        block113: {
                                            String serializedObjectPolicyClassName = ((SerializedObjectPolicyWrapper)this.serializedObjectPolicy).getSerializedObjectPolicyClassName();
                                            Class serializedObjectPolicyClass = null;
                                            newSerializedObjectPolicy = null;
                                            try {
                                                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                                    try {
                                                        serializedObjectPolicyClass = AccessController.doPrivileged(new PrivilegedClassForName(serializedObjectPolicyClassName, true, classLoader));
                                                    }
                                                    catch (PrivilegedActionException exception) {
                                                        throw ValidationException.classNotFoundWhileConvertingClassNames(serializedObjectPolicyClassName, exception.getException());
                                                    }
                                                    try {
                                                        newSerializedObjectPolicy = (SerializedObjectPolicy)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(serializedObjectPolicyClass));
                                                        break block113;
                                                    }
                                                    catch (PrivilegedActionException exception) {
                                                        throw ValidationException.reflectiveExceptionWhileCreatingClassInstance(serializedObjectPolicyClassName, exception.getException());
                                                    }
                                                }
                                                serializedObjectPolicyClass = PrivilegedAccessHelper.getClassForName(serializedObjectPolicyClassName, true, classLoader);
                                                newSerializedObjectPolicy = (SerializedObjectPolicy)PrivilegedAccessHelper.newInstanceFromClass(serializedObjectPolicyClass);
                                            }
                                            catch (ClassNotFoundException exc) {
                                                throw ValidationException.classNotFoundWhileConvertingClassNames(serializedObjectPolicyClassName, exc);
                                            }
                                            catch (IllegalAccessException ex) {
                                                throw ValidationException.reflectiveExceptionWhileCreatingClassInstance(serializedObjectPolicyClassName, ex);
                                            }
                                            catch (InstantiationException e) {
                                                throw ValidationException.reflectiveExceptionWhileCreatingClassInstance(serializedObjectPolicyClassName, e);
                                            }
                                        }
                                        newSerializedObjectPolicy.setField(this.serializedObjectPolicy.getField());
                                        this.setSerializedObjectPolicy(newSerializedObjectPolicy);
                                    }
                                    if (this.defaultQueryRedirectorClassName != null) {
                                        try {
                                            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                                try {
                                                    redirectorClass = AccessController.doPrivileged(new PrivilegedClassForName(this.defaultQueryRedirectorClassName, true, classLoader));
                                                }
                                                catch (PrivilegedActionException exception) {
                                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultQueryRedirectorClassName, exception.getException());
                                                }
                                                try {
                                                    this.setDefaultQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(redirectorClass)));
                                                    break block114;
                                                }
                                                catch (PrivilegedActionException exception) {
                                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultQueryRedirectorClassName, exception.getException());
                                                }
                                            }
                                            redirectorClass = PrivilegedAccessHelper.getClassForName(this.defaultQueryRedirectorClassName, true, classLoader);
                                            this.setDefaultQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(redirectorClass));
                                        }
                                        catch (ClassNotFoundException exc) {
                                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultQueryRedirectorClassName, exc);
                                        }
                                        catch (Exception e) {
                                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultQueryRedirectorClassName, e);
                                        }
                                    }
                                }
                                if (this.defaultReadObjectQueryRedirectorClassName != null) {
                                    try {
                                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                            try {
                                                redirectorClass = AccessController.doPrivileged(new PrivilegedClassForName(this.defaultReadObjectQueryRedirectorClassName, true, classLoader));
                                            }
                                            catch (PrivilegedActionException exception) {
                                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadObjectQueryRedirectorClassName, exception.getException());
                                            }
                                            try {
                                                this.setDefaultReadObjectQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(redirectorClass)));
                                                break block115;
                                            }
                                            catch (PrivilegedActionException exception) {
                                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadObjectQueryRedirectorClassName, exception.getException());
                                            }
                                        }
                                        redirectorClass = PrivilegedAccessHelper.getClassForName(this.defaultReadObjectQueryRedirectorClassName, true, classLoader);
                                        this.setDefaultReadObjectQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(redirectorClass));
                                    }
                                    catch (ClassNotFoundException exc) {
                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadObjectQueryRedirectorClassName, exc);
                                    }
                                    catch (Exception e) {
                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadObjectQueryRedirectorClassName, e);
                                    }
                                }
                            }
                            if (this.defaultReadAllQueryRedirectorClassName != null) {
                                try {
                                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                        try {
                                            redirectorClass = AccessController.doPrivileged(new PrivilegedClassForName(this.defaultReadAllQueryRedirectorClassName, true, classLoader));
                                        }
                                        catch (PrivilegedActionException exception) {
                                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadAllQueryRedirectorClassName, exception.getException());
                                        }
                                        try {
                                            this.setDefaultReadAllQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(redirectorClass)));
                                            break block116;
                                        }
                                        catch (PrivilegedActionException exception) {
                                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadAllQueryRedirectorClassName, exception.getException());
                                        }
                                    }
                                    redirectorClass = PrivilegedAccessHelper.getClassForName(this.defaultReadAllQueryRedirectorClassName, true, classLoader);
                                    this.setDefaultReadAllQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(redirectorClass));
                                }
                                catch (ClassNotFoundException exc) {
                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadAllQueryRedirectorClassName, exc);
                                }
                                catch (Exception e) {
                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadAllQueryRedirectorClassName, e);
                                }
                            }
                        }
                        if (this.defaultReportQueryRedirectorClassName != null) {
                            try {
                                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                    try {
                                        redirectorClass = AccessController.doPrivileged(new PrivilegedClassForName(this.defaultReportQueryRedirectorClassName, true, classLoader));
                                    }
                                    catch (PrivilegedActionException exception) {
                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReportQueryRedirectorClassName, exception.getException());
                                    }
                                    try {
                                        this.setDefaultReportQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(redirectorClass)));
                                        break block117;
                                    }
                                    catch (PrivilegedActionException exception) {
                                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReportQueryRedirectorClassName, exception.getException());
                                    }
                                }
                                redirectorClass = PrivilegedAccessHelper.getClassForName(this.defaultReportQueryRedirectorClassName, true, classLoader);
                                this.setDefaultReportQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(redirectorClass));
                            }
                            catch (ClassNotFoundException exc) {
                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReportQueryRedirectorClassName, exc);
                            }
                            catch (Exception e) {
                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReportQueryRedirectorClassName, e);
                            }
                        }
                    }
                    if (this.defaultInsertObjectQueryRedirectorClassName != null) {
                        try {
                            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                try {
                                    redirectorClass = AccessController.doPrivileged(new PrivilegedClassForName(this.defaultInsertObjectQueryRedirectorClassName, true, classLoader));
                                }
                                catch (PrivilegedActionException exception) {
                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultInsertObjectQueryRedirectorClassName, exception.getException());
                                }
                                try {
                                    this.setDefaultInsertObjectQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(redirectorClass)));
                                    break block118;
                                }
                                catch (PrivilegedActionException exception) {
                                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultInsertObjectQueryRedirectorClassName, exception.getException());
                                }
                            }
                            redirectorClass = PrivilegedAccessHelper.getClassForName(this.defaultInsertObjectQueryRedirectorClassName, true, classLoader);
                            this.setDefaultInsertObjectQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(redirectorClass));
                        }
                        catch (ClassNotFoundException exc) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultInsertObjectQueryRedirectorClassName, exc);
                        }
                        catch (Exception e) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultInsertObjectQueryRedirectorClassName, e);
                        }
                    }
                }
                if (this.defaultUpdateObjectQueryRedirectorClassName != null) {
                    try {
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                redirectorClass = AccessController.doPrivileged(new PrivilegedClassForName(this.defaultUpdateObjectQueryRedirectorClassName, true, classLoader));
                            }
                            catch (PrivilegedActionException exception) {
                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultUpdateObjectQueryRedirectorClassName, exception.getException());
                            }
                            try {
                                this.setDefaultUpdateObjectQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(redirectorClass)));
                                break block119;
                            }
                            catch (PrivilegedActionException exception) {
                                throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultUpdateObjectQueryRedirectorClassName, exception.getException());
                            }
                        }
                        redirectorClass = PrivilegedAccessHelper.getClassForName(this.defaultUpdateObjectQueryRedirectorClassName, true, classLoader);
                        this.setDefaultUpdateObjectQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(redirectorClass));
                    }
                    catch (ClassNotFoundException exc) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultUpdateObjectQueryRedirectorClassName, exc);
                    }
                    catch (Exception e) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultUpdateObjectQueryRedirectorClassName, e);
                    }
                }
            }
            if (this.defaultDeleteObjectQueryRedirectorClassName != null) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            redirectorClass = AccessController.doPrivileged(new PrivilegedClassForName(this.defaultDeleteObjectQueryRedirectorClassName, true, classLoader));
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultDeleteObjectQueryRedirectorClassName, exception.getException());
                        }
                        try {
                            this.setDefaultDeleteObjectQueryRedirector((QueryRedirector)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(redirectorClass)));
                            break block120;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultDeleteObjectQueryRedirectorClassName, exception.getException());
                        }
                    }
                    redirectorClass = PrivilegedAccessHelper.getClassForName(this.defaultDeleteObjectQueryRedirectorClassName, true, classLoader);
                    this.setDefaultDeleteObjectQueryRedirector((QueryRedirector)PrivilegedAccessHelper.newInstanceFromClass(redirectorClass));
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultDeleteObjectQueryRedirectorClassName, exc);
                }
                catch (Exception e) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.defaultDeleteObjectQueryRedirectorClassName, e);
                }
            }
        }
        Iterator<DatabaseMapping> mappings = this.getMappings().iterator();
        while (mappings.hasNext()) {
            mappings.next().convertClassNamesToClasses(classLoader);
        }
        if (this.inheritancePolicy != null) {
            ((InheritancePolicy)this.inheritancePolicy).convertClassNamesToClasses(classLoader);
        }
        if (this.interfacePolicy != null) {
            this.interfacePolicy.convertClassNamesToClasses(classLoader);
        }
        if (this.instantiationPolicy != null) {
            ((InstantiationPolicy)this.instantiationPolicy).convertClassNamesToClasses(classLoader);
        }
        if (this.hasCMPPolicy()) {
            this.getCMPPolicy().convertClassNamesToClasses(classLoader);
        }
        if (this.queryManager != null) {
            this.queryManager.convertClassNamesToClasses(classLoader);
        }
        if (this.cachePolicy != null) {
            this.cachePolicy.convertClassNamesToClasses(classLoader);
        }
        if (this.hasUnconvertedProperties()) {
            for (String propertyName : this.getUnconvertedProperties().keySet()) {
                Class valueType;
                String value;
                block121: {
                    List<String> valuePair = this.getUnconvertedProperties().get(propertyName);
                    value = valuePair.get(0);
                    String valueTypeName = valuePair.get(1);
                    valueType = String.class;
                    if (valueTypeName != null) {
                        try {
                            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                try {
                                    valueType = AccessController.doPrivileged(new PrivilegedClassForName(valueTypeName, true, classLoader));
                                    break block121;
                                }
                                catch (PrivilegedActionException exception) {
                                    throw ValidationException.classNotFoundWhileConvertingClassNames(valueTypeName, exception.getException());
                                }
                            }
                            valueType = PrivilegedAccessHelper.getClassForName(valueTypeName, true, classLoader);
                        }
                        catch (ClassNotFoundException exc) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(valueTypeName, exc);
                        }
                    }
                }
                this.getProperties().put(propertyName, ConversionManager.getDefaultManager().convertObject(value, valueType));
            }
        }
    }

    public void createCopyPolicy(String policyType) {
        if (policyType.equals("clone")) {
            this.useCloneCopyPolicy();
            return;
        }
        if (policyType.equals("constructor")) {
            this.useInstantiationCopyPolicy();
            return;
        }
    }

    public void createInstantiationPolicy(String policyType) {
        if (policyType.equals("static method")) {
            return;
        }
        if (policyType.equals("constructor")) {
            this.useDefaultConstructorInstantiationPolicy();
            return;
        }
        if (policyType.equals("factory")) {
            return;
        }
    }

    public void descriptorIsAggregate() {
        this.setDescriptorType(2);
    }

    public void descriptorIsAggregateCollection() {
        this.setDescriptorType(3);
    }

    public void descriptorIsForInterface() {
        this.setDescriptorType(1);
    }

    public void descriptorIsNormal() {
        this.setDescriptorType(0);
    }

    public void disableCacheHits() {
        this.setShouldDisableCacheHits(true);
    }

    public void disableCacheHitsOnRemote() {
        this.setShouldDisableCacheHitsOnRemote(true);
    }

    public void dontAlwaysConformResultsInUnitOfWork() {
        this.setShouldAlwaysConformResultsInUnitOfWork(false);
    }

    public void dontAlwaysRefreshCache() {
        this.setShouldAlwaysRefreshCache(false);
    }

    public void dontAlwaysRefreshCacheOnRemote() {
        this.setShouldAlwaysRefreshCacheOnRemote(false);
    }

    public void dontDisableCacheHits() {
        this.setShouldDisableCacheHits(false);
    }

    public void dontDisableCacheHitsOnRemote() {
        this.setShouldDisableCacheHitsOnRemote(false);
    }

    public void dontOnlyRefreshCacheIfNewerVersion() {
        this.setShouldOnlyRefreshCacheIfNewerVersion(false);
    }

    protected DatabaseTable extractDefaultTable() {
        if (this.getTables().isEmpty()) {
            if (this.isChildDescriptor()) {
                return this.getInheritancePolicy().getParentDescriptor().extractDefaultTable();
            }
            return null;
        }
        return this.getTables().get(0);
    }

    public List<DatabaseField> getAdditionalAggregateCollectionKeyFields() {
        if (this.additionalAggregateCollectionKeyFields == null) {
            this.additionalAggregateCollectionKeyFields = new ArrayList<DatabaseField>();
        }
        return this.additionalAggregateCollectionKeyFields;
    }

    public Map<DatabaseTable, Map<DatabaseField, DatabaseField>> getAdditionalTablePrimaryKeyFields() {
        if (this.additionalTablePrimaryKeyFields == null) {
            this.additionalTablePrimaryKeyFields = new HashMap<DatabaseTable, Map<DatabaseField, DatabaseField>>(5);
        }
        return this.additionalTablePrimaryKeyFields;
    }

    public List<DatabaseField> getAdditionalWritableMapKeyFields() {
        if (this.additionalWritableMapKeyFields == null) {
            this.additionalWritableMapKeyFields = new ArrayList<DatabaseField>(2);
        }
        return this.additionalWritableMapKeyFields;
    }

    public String getAlias() {
        if (this.alias == null && this.getJavaClassName() != null) {
            this.alias = Helper.getShortClassName(this.getJavaClassName());
        }
        return this.alias;
    }

    public Vector<DatabaseField> getAllFields() {
        return this.allFields;
    }

    public List<DatabaseField> getAllSelectionFields() {
        return this.allSelectionFields;
    }

    public List<DatabaseField> getAllSelectionFields(ObjectLevelReadQuery query) {
        if (this.hasSerializedObjectPolicy() && query.shouldUseSerializedObjectPolicy()) {
            return this.serializedObjectPolicy.getAllSelectionFields();
        }
        return this.allSelectionFields;
    }

    public Class getAmendmentClass() {
        return this.amendmentClass;
    }

    public String getAmendmentClassName() {
        if (this.amendmentClassName == null && this.amendmentClass != null) {
            this.amendmentClassName = this.amendmentClass.getName();
        }
        return this.amendmentClassName;
    }

    public String getAmendmentMethodName() {
        return this.amendmentMethodName;
    }

    public List<AttributeAccessor> getAccessorTree() {
        return this.accessorTree;
    }

    public ObjectChangePolicy getObjectChangePolicy() {
        if (this.changePolicy == null) {
            this.changePolicy = new DeferredChangeDetectionPolicy();
        }
        return this.changePolicy;
    }

    public ObjectChangePolicy getObjectChangePolicyInternal() {
        return this.changePolicy;
    }

    public HistoryPolicy getHistoryPolicy() {
        return this.historyPolicy;
    }

    public PartitioningPolicy getPartitioningPolicy() {
        return this.partitioningPolicy;
    }

    public void setPartitioningPolicy(PartitioningPolicy partitioningPolicy) {
        this.partitioningPolicy = partitioningPolicy;
    }

    public String getPartitioningPolicyName() {
        return this.partitioningPolicyName;
    }

    public void setPartitioningPolicyName(String partitioningPolicyName) {
        this.partitioningPolicyName = partitioningPolicyName;
    }

    public Class getCacheInterceptorClass() {
        return this.getCachePolicy().getCacheInterceptorClass();
    }

    public String getCacheInterceptorClassName() {
        return this.getCachePolicy().getCacheInterceptorClassName();
    }

    public CacheInvalidationPolicy getCacheInvalidationPolicy() {
        if (this.cacheInvalidationPolicy == null) {
            this.cacheInvalidationPolicy = new NoExpiryCacheInvalidationPolicy();
        }
        return this.cacheInvalidationPolicy;
    }

    public int getCacheSynchronizationType() {
        return this.getCachePolicy().getCacheSynchronizationType();
    }

    public List<CascadeLockingPolicy> getCascadeLockingPolicies() {
        if (this.cascadeLockingPolicies == null) {
            this.cascadeLockingPolicies = new ArrayList<CascadeLockingPolicy>();
        }
        return this.cascadeLockingPolicies;
    }

    public Vector getConstraintDependencies() {
        if (this.constraintDependencies == null) {
            this.constraintDependencies = NonSynchronizedVector.newInstance(1);
        }
        return this.constraintDependencies;
    }

    public CopyPolicy getCopyPolicy() {
        if (this.copyPolicy == null) {
            this.setCopyPolicy(new InstantiationCopyPolicy());
        }
        return this.copyPolicy;
    }

    public String getCopyPolicyClassName() {
        return this.copyPolicyClassName;
    }

    public DatabaseTable getDefaultTable() {
        return this.defaultTable;
    }

    public int getDescriptorType() {
        return this.descriptorType;
    }

    public String getDescriptorTypeValue() {
        if (this.isAggregateCollectionDescriptor()) {
            return "Aggregate collection";
        }
        if (this.isAggregateDescriptor()) {
            return "Aggregate";
        }
        if (this.isDescriptorForInterface()) {
            return "Interface";
        }
        return "Normal";
    }

    public Collection<DatabaseMapping> getDerivesIdMappinps() {
        return this.derivesIdMappings.values();
    }

    public String getDescriptorCustomizerClassName() {
        return this.descriptorCustomizerClassName;
    }

    public DescriptorEventManager getDescriptorEventManager() {
        return this.getEventManager();
    }

    @Override
    public DescriptorEventManager getEventManager() {
        if (this.eventManager == null) {
            this.setEventManager(new DescriptorEventManager());
        }
        return (DescriptorEventManager)this.eventManager;
    }

    public Vector<DatabaseField> getFields() {
        if (this.fields == null) {
            this.fields = NonSynchronizedVector.newInstance();
        }
        return this.fields;
    }

    public List<DatabaseField> getSelectionFields() {
        return this.selectionFields;
    }

    public List<DatabaseField> getSelectionFields(ObjectLevelReadQuery query) {
        if (this.hasSerializedObjectPolicy() && query.shouldUseSerializedObjectPolicy()) {
            return this.serializedObjectPolicy.getSelectionFields();
        }
        return this.selectionFields;
    }

    public Set<DatabaseField> getForeignKeyValuesForCaching() {
        return this.foreignKeyValuesForCaching;
    }

    public Class getIdentityMapClass() {
        return this.getCachePolicy().getIdentityMapClass();
    }

    public int getIdentityMapSize() {
        return this.getCachePolicy().getIdentityMapSize();
    }

    public InheritancePolicy getDescriptorInheritancePolicy() {
        return this.getInheritancePolicy();
    }

    @Override
    public InheritancePolicy getInheritancePolicy() {
        if (this.inheritancePolicy == null) {
            this.setInheritancePolicy(new InheritancePolicy(this));
        }
        return (InheritancePolicy)this.inheritancePolicy;
    }

    public InheritancePolicy getInheritancePolicyOrNull() {
        return (InheritancePolicy)this.inheritancePolicy;
    }

    @Override
    public InstantiationPolicy getInstantiationPolicy() {
        if (this.instantiationPolicy == null) {
            this.setInstantiationPolicy(new InstantiationPolicy());
        }
        return (InstantiationPolicy)this.instantiationPolicy;
    }

    public InterfacePolicy getInterfacePolicy() {
        if (this.interfacePolicy == null) {
            this.setInterfacePolicy(new InterfacePolicy(this));
        }
        return this.interfacePolicy;
    }

    public InterfacePolicy getInterfacePolicyOrNull() {
        return this.interfacePolicy;
    }

    @Override
    public Class getJavaClass() {
        return this.javaClass;
    }

    public String getJavaClassName() {
        if (this.javaClassName == null && this.javaClass != null) {
            this.javaClassName = this.javaClass.getName();
        }
        return this.javaClassName;
    }

    public List<DatabaseMapping> getLockableMappings() {
        if (this.lockableMappings == null) {
            this.lockableMappings = new ArrayList<DatabaseMapping>();
        }
        return this.lockableMappings;
    }

    public DatabaseMapping getMappingForAttributeName(String attributeName) {
        Enumeration<DatabaseMapping> mappingsNum = this.mappings.elements();
        while (mappingsNum.hasMoreElements()) {
            DatabaseMapping mapping = mappingsNum.nextElement();
            if (mapping.getAttributeName() == null || !mapping.getAttributeName().equals(attributeName)) continue;
            return mapping;
        }
        return null;
    }

    public DatabaseMapping removeMappingForAttributeName(String attributeName) {
        DatabaseMapping mapping = this.getMappingForAttributeName(attributeName);
        this.getMappings().remove(mapping);
        return mapping;
    }

    public Vector<DatabaseMapping> getMappings() {
        return this.mappings;
    }

    public Vector getMultipleTableForeignKeyAssociations() {
        Vector<Association> associations = new Vector<Association>(this.getAdditionalTablePrimaryKeyFields().size() * 2);
        for (Map<DatabaseField, DatabaseField> tableHash : this.getAdditionalTablePrimaryKeyFields().values()) {
            for (DatabaseField keyField : tableHash.keySet()) {
                if (!this.getMultipleTableForeignKeys().containsKey(keyField.getTable())) continue;
                Association association = new Association(keyField.getQualifiedName(), tableHash.get(keyField).getQualifiedName());
                associations.addElement(association);
            }
        }
        return associations;
    }

    public Map<DatabaseTable, Set<DatabaseTable>> getMultipleTableForeignKeys() {
        if (this.multipleTableForeignKeys == null) {
            this.multipleTableForeignKeys = new HashMap<DatabaseTable, Set<DatabaseTable>>(5);
        }
        return this.multipleTableForeignKeys;
    }

    public List<DatabaseTable> getMultipleTableInsertOrder() throws DescriptorException {
        return this.multipleTableInsertOrder;
    }

    public Vector getMultipleTablePrimaryKeyAssociations() {
        Vector<Association> associations = new Vector<Association>(this.getAdditionalTablePrimaryKeyFields().size() * 2);
        for (Map<DatabaseField, DatabaseField> tableHash : this.getAdditionalTablePrimaryKeyFields().values()) {
            for (DatabaseField keyField : tableHash.keySet()) {
                if (this.getMultipleTableForeignKeys().containsKey(keyField.getTable())) continue;
                Association association = new Association(keyField.getQualifiedName(), tableHash.get(keyField).getQualifiedName());
                associations.addElement(association);
            }
        }
        return associations;
    }

    public MultitenantPolicy getMultitenantPolicy() {
        return this.multitenantPolicy;
    }

    @Override
    public ObjectBuilder getObjectBuilder() {
        return (ObjectBuilder)this.objectBuilder;
    }

    public OptimisticLockingPolicy getOptimisticLockingPolicy() {
        return this.optimisticLockingPolicy;
    }

    public List<DatabaseMapping> getPreDeleteMappings() {
        if (this.preDeleteMappings == null) {
            this.preDeleteMappings = new ArrayList<DatabaseMapping>();
        }
        return this.preDeleteMappings;
    }

    public void addPreDeleteMapping(DatabaseMapping mapping) {
        if (mapping.getAttributeName() == null) {
            System.out.println(mapping);
        }
        this.getPreDeleteMappings().add(mapping);
    }

    public Vector<String> getPrimaryKeyFieldNames() {
        Vector<String> result = new Vector<String>(this.getPrimaryKeyFields().size());
        List<DatabaseField> primaryKeyFields = this.getPrimaryKeyFields();
        int index = 0;
        while (index < primaryKeyFields.size()) {
            result.addElement(primaryKeyFields.get(index).getQualifiedName());
            ++index;
        }
        return result;
    }

    @Override
    public List<DatabaseField> getPrimaryKeyFields() {
        return this.primaryKeyFields;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap(5);
        }
        return this.properties;
    }

    public Object getProperty(String name) {
        return this.getProperties().get(name);
    }

    public QueryKey getQueryKeyNamed(String queryKeyName) {
        return this.getQueryKeys().get(queryKeyName);
    }

    public Map<String, QueryKey> getQueryKeys() {
        return this.queryKeys;
    }

    public DescriptorQueryManager getDescriptorQueryManager() {
        return this.getQueryManager();
    }

    public DescriptorQueryManager getQueryManager() {
        if (this.queryManager == null) {
            this.setQueryManager(new DescriptorQueryManager());
        }
        return this.queryManager;
    }

    public Class getRemoteIdentityMapClass() {
        return this.getCachePolicy().getRemoteIdentityMapClass();
    }

    public ClassDescriptor getRootDescriptor() {
        if (this.hasInheritance()) {
            return this.getInheritancePolicy().getRootParentDescriptor();
        }
        return this;
    }

    public int getRemoteIdentityMapSize() {
        return this.getCachePolicy().getRemoteIdentityMapSize();
    }

    public ReturningPolicy getReturningPolicy() {
        return this.returningPolicy;
    }

    public DatabaseField getSequenceNumberField() {
        return this.sequenceNumberField;
    }

    public String getSequenceNumberFieldName() {
        if (this.getSequenceNumberField() == null) {
            return null;
        }
        return this.getSequenceNumberField().getQualifiedName();
    }

    public String getSequenceNumberName() {
        return this.sequenceNumberName;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public DatabaseTable getTable(String tableName) throws DescriptorException {
        DatabaseTable table;
        if (this.hasTablePerMultitenantPolicy() && (table = ((TablePerMultitenantPolicy)this.getMultitenantPolicy()).getTable(tableName)) != null) {
            return table;
        }
        if (this.getTables().isEmpty()) {
            return null;
        }
        Enumeration<DatabaseTable> tables = this.getTables().elements();
        while (tables.hasMoreElements()) {
            String currentTableName;
            DatabaseTable table2 = tables.nextElement();
            if (tableName.indexOf(32) != -1 && (currentTableName = table2.getName()).substring(1, currentTableName.length() - 1).equals(tableName)) {
                return table2;
            }
            if (!table2.getName().equals(tableName)) continue;
            return table2;
        }
        if (this.isAggregateDescriptor()) {
            return this.getDefaultTable();
        }
        throw DescriptorException.tableNotPresent(tableName, this);
    }

    public String getTableName() {
        if (this.getTables().isEmpty()) {
            return null;
        }
        return this.getTables().get(0).getName();
    }

    public Vector getTableNames() {
        Vector<String> tableNames = new Vector<String>(this.getTables().size());
        Enumeration<DatabaseTable> fieldsEnum = this.getTables().elements();
        while (fieldsEnum.hasMoreElements()) {
            tableNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return tableNames;
    }

    public TablePerClassPolicy getTablePerClassPolicy() {
        return (TablePerClassPolicy)this.interfacePolicy;
    }

    public Vector<DatabaseTable> getTables() {
        return this.tables;
    }

    @Override
    public DatabaseField getTypedField(DatabaseField field) {
        DatabaseField returnField;
        boolean mayBeMoreThanOne = this.hasMultipleTables() && !field.hasTableName();
        DatabaseField foundField = null;
        int index = 0;
        while (index < this.getFields().size()) {
            DatabaseField descField = this.getFields().get(index);
            if (field.equals(descField) && descField.getType() != null) {
                foundField = descField;
                if (!mayBeMoreThanOne || descField.getTable().equals(this.getDefaultTable())) break;
            }
            ++index;
        }
        if (foundField == null && this.hasReturningPolicy() && (returnField = this.getReturningPolicy().getField(field)) != null && returnField.getType() != null) {
            foundField = returnField;
        }
        if (foundField != null) {
            foundField = foundField.clone();
            if (!field.hasTableName()) {
                foundField.setTableName("");
            }
        }
        return foundField;
    }

    public WrapperPolicy getWrapperPolicy() {
        return this.wrapperPolicy;
    }

    public boolean hasDependencyOnParts() {
        for (DatabaseMapping mapping : this.getMappings()) {
            if (!mapping.hasDependency()) continue;
            return true;
        }
        return false;
    }

    public boolean hasDerivedId() {
        return !this.derivesIdMappings.isEmpty();
    }

    @Override
    public boolean hasEventManager() {
        return this.eventManager != null;
    }

    @Override
    public boolean hasInheritance() {
        return this.inheritancePolicy != null;
    }

    public boolean hasInterfacePolicy() {
        return this.interfacePolicy != null;
    }

    public boolean hasMultipleTables() {
        return this.getTables().size() > 1;
    }

    public boolean hasNestedIdentityReference(boolean withChildren) {
        if (withChildren && this.hasInheritance() && this.getInheritancePolicy().hasChildren()) {
            for (ClassDescriptor childDescriptor : this.getInheritancePolicy().getAllChildDescriptors()) {
                if (childDescriptor.getInheritancePolicy().hasChildren() || !childDescriptor.hasNestedIdentityReference(false)) continue;
                return true;
            }
        } else {
            for (DatabaseMapping mapping : this.getMappings()) {
                if (!mapping.hasNestedIdentityReference()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasNoncacheableMappings() {
        return this.hasNoncacheableMappings;
    }

    public boolean hasPreDeleteMappings() {
        return this.preDeleteMappings != null;
    }

    public boolean hasPrivatelyOwnedParts() {
        Enumeration<DatabaseMapping> mappings = this.getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = mappings.nextElement();
            if (!mapping.isPrivateOwned()) continue;
            return true;
        }
        return false;
    }

    public boolean hasQueryKeyOrMapping(String attributeName) {
        return this.getQueryKeys().containsKey(attributeName) || this.getObjectBuilder().getMappingForAttributeName(attributeName) != null;
    }

    public boolean hasRelationships() {
        return this.hasRelationships;
    }

    public boolean hasRelationshipsExceptBackpointer(ClassDescriptor descriptor) {
        Iterator<DatabaseMapping> i = this.mappings.iterator();
        boolean foundRelationship = false;
        while (i.hasNext()) {
            DatabaseMapping mapping = i.next();
            if (!mapping.isForeignReferenceMapping()) continue;
            ForeignReferenceMapping frMapping = (ForeignReferenceMapping)mapping;
            if (frMapping.getReferenceDescriptor().equals(descriptor)) {
                if (foundRelationship) {
                    return true;
                }
                foundRelationship = true;
                continue;
            }
            return true;
        }
        return false;
    }

    public boolean hasReturningPolicy() {
        return this.returningPolicy != null;
    }

    public boolean hasSerializedObjectPolicy() {
        return this.serializedObjectPolicy != null;
    }

    public SerializedObjectPolicy getSerializedObjectPolicy() {
        return this.serializedObjectPolicy;
    }

    public void setSerializedObjectPolicy(SerializedObjectPolicy serializedObjectPolicy) {
        this.serializedObjectPolicy = serializedObjectPolicy;
        if (serializedObjectPolicy != null) {
            serializedObjectPolicy.setDescriptor(this);
        }
    }

    public boolean hasWrapperPolicy() {
        return this.wrapperPolicy != null;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        ClassDescriptor parentDescriptor;
        if (this.isInitialized(2) || this.isInvalid()) {
            return;
        }
        this.setInitializationStage(2);
        if (this.isChildDescriptor()) {
            ClassDescriptor parentDescriptor2 = this.getInheritancePolicy().getParentDescriptor();
            parentDescriptor2.initialize(session);
            this.getCachePolicy().initializeFromParent(parentDescriptor2.getCachePolicy(), this, parentDescriptor2, session);
            this.getInheritancePolicy().initializeOptimisticLocking();
            this.getInheritancePolicy().initializeCacheInvalidationPolicy();
            if (parentDescriptor2.hasSerializedObjectPolicy() && !this.hasSerializedObjectPolicy()) {
                this.setSerializedObjectPolicy(parentDescriptor2.getSerializedObjectPolicy().instantiateChild());
            }
        }
        if (this.shouldOrderMappings()) {
            NonSynchronizedVector mappings = this.getMappings();
            Object[] mappingsArray = new Object[((Vector)mappings).size()];
            int index = 0;
            while (index < ((Vector)mappings).size()) {
                mappingsArray[index] = ((Vector)mappings).get(index);
                ++index;
            }
            Arrays.sort(mappingsArray, new MappingCompare());
            mappings = NonSynchronizedVector.newInstance(mappingsArray.length);
            index = 0;
            while (index < mappingsArray.length) {
                ((Vector)mappings).add(mappingsArray[index]);
                ++index;
            }
            this.setMappings(mappings);
        }
        boolean initializeCascadeLocking = this.usesOptimisticLocking() && this.getOptimisticLockingPolicy().isCascaded() || this.hasCascadeLockingPolicies();
        for (DatabaseMapping mapping : this.getMappings()) {
            Object referencedDescriptor;
            this.validateMappingType(mapping);
            mapping.initialize(session);
            if (!mapping.isCacheable()) {
                this.hasNoncacheableMappings = true;
            }
            if (mapping.isForeignReferenceMapping()) {
                if (((ForeignReferenceMapping)mapping).getIndirectionPolicy() instanceof ProxyIndirectionPolicy) {
                    session.getProject().setHasProxyIndirection(true);
                }
                if ((referencedDescriptor = ((ForeignReferenceMapping)mapping).getReferenceDescriptor()) != null) {
                    ((ClassDescriptor)referencedDescriptor).referencingClasses.add(this);
                }
            }
            if (mapping.isAggregateObjectMapping() && (referencedDescriptor = ((AggregateObjectMapping)mapping).getReferenceDescriptor()) != null) {
                ((ClassDescriptor)referencedDescriptor).referencingClasses.add(this);
            }
            if (initializeCascadeLocking) {
                this.prepareCascadeLockingPolicy(mapping);
            }
            if (mapping.derivesId()) {
                this.derivesIdMappings.put(mapping.getAttributeName(), mapping);
            }
            Helper.addAllUniqueToVector(this.getFields(), mapping.getFields());
        }
        if (initializeCascadeLocking) {
            this.cascadedLockingInitialized = true;
        }
        if (this.hasMappingsPostCalculateChangesOnDeleted()) {
            session.getProject().setHasMappingsPostCalculateChangesOnDeleted(true);
        }
        if (!this.isAggregateDescriptor()) {
            if (!this.isChildDescriptor() && this.usesOptimisticLocking()) {
                this.getOptimisticLockingPolicy().initializeProperties();
            }
            if (this.hasSerializedObjectPolicy()) {
                this.getSerializedObjectPolicy().initializeField(session);
            }
        }
        for (QueryKey queryKey : this.getQueryKeys().values()) {
            queryKey.initialize(this);
        }
        if (this.getPartitioningPolicyName() != null) {
            PartitioningPolicy policy = session.getProject().getPartitioningPolicy(this.getPartitioningPolicyName());
            if (policy == null) {
                session.getIntegrityChecker().handleError(DescriptorException.missingPartitioningPolicy(this.getPartitioningPolicyName(), this, null));
            }
            this.setPartitioningPolicy(policy);
        }
        if (this.hasInheritance()) {
            this.getInheritancePolicy().initialize(session);
            if (this.getInheritancePolicy().isChildDescriptor()) {
                ClassDescriptor parentDescriptor3 = this.getInheritancePolicy().getParentDescriptor();
                for (DatabaseMapping mapping : parentDescriptor3.getMappings()) {
                    if (mapping.isAggregateObjectMapping() || mapping.isForeignReferenceMapping() && !mapping.isDirectCollectionMapping() && !((ForeignReferenceMapping)mapping).usesIndirection()) {
                        this.getLockableMappings().add(mapping);
                    }
                    if (!mapping.derivesId()) continue;
                    this.derivesIdMappings.put(mapping.getAttributeName(), mapping);
                }
                if (parentDescriptor3.hasPreDeleteMappings()) {
                    this.getPreDeleteMappings().addAll(parentDescriptor3.getPreDeleteMappings());
                }
                if (parentDescriptor3.hasMappingsPostCalculateChanges()) {
                    this.getMappingsPostCalculateChanges().addAll(parentDescriptor3.getMappingsPostCalculateChanges());
                }
                if (parentDescriptor3.hasMappingsPostCalculateChangesOnDeleted()) {
                    this.getMappingsPostCalculateChangesOnDeleted().addAll(parentDescriptor3.getMappingsPostCalculateChangesOnDeleted());
                }
            }
        }
        if (this.hasInheritance() && this.shouldOrderMappings()) {
            NonSynchronizedVector mappings = this.getMappings();
            Object[] mappingsArray = new Object[((Vector)mappings).size()];
            int index = 0;
            while (index < ((Vector)mappings).size()) {
                mappingsArray[index] = ((Vector)mappings).get(index);
                ++index;
            }
            Arrays.sort(mappingsArray, new MappingCompare());
            mappings = NonSynchronizedVector.newInstance(mappingsArray.length);
            index = 0;
            while (index < mappingsArray.length) {
                ((Vector)mappings).add(mappingsArray[index]);
                ++index;
            }
            this.setMappings(mappings);
        }
        this.setAllFields((Vector)this.getFields().clone());
        this.getObjectBuilder().initialize(session);
        if (this.hasMultitenantPolicy()) {
            this.getMultitenantPolicy().initialize(session);
        }
        if (this.shouldOrderMappings()) {
            int index = this.getObjectBuilder().getPrimaryKeyMappings().size() - 1;
            while (index >= 0) {
                DatabaseMapping mapping;
                mapping = this.getObjectBuilder().getPrimaryKeyMappings().get(index);
                if (mapping != null && mapping.isAbstractColumnMapping()) {
                    this.getMappings().remove(mapping);
                    this.getMappings().add(0, mapping);
                    DatabaseField field = ((AbstractColumnMapping)mapping).getField();
                    this.getFields().remove(field);
                    this.getFields().add(0, field);
                    this.getAllFields().remove(field);
                    this.getAllFields().add(0, field);
                }
                --index;
            }
        }
        if (this.usesOptimisticLocking() && !this.isChildDescriptor()) {
            this.getOptimisticLockingPolicy().initialize(session);
        }
        if (this.hasInterfacePolicy() || this.isDescriptorForInterface()) {
            this.interfaceInitialization(session);
        }
        if (this.hasWrapperPolicy()) {
            this.getWrapperPolicy().initialize(session);
        }
        if (this.hasReturningPolicy()) {
            this.getReturningPolicy().initialize(session);
        }
        if (this.hasSerializedObjectPolicy()) {
            this.getSerializedObjectPolicy().initialize(session);
        }
        this.getQueryManager().initialize(session);
        this.getEventManager().initialize(session);
        this.getCopyPolicy().initialize(session);
        this.getInstantiationPolicy().initialize(session);
        this.getCachePolicy().initialize(this, session);
        if (this.getHistoryPolicy() != null) {
            this.getHistoryPolicy().initialize(session);
        } else if (this.hasInheritance() && (parentDescriptor = this.getInheritancePolicy().getParentDescriptor()) != null && parentDescriptor.getHistoryPolicy() != null) {
            this.setHistoryPolicy((HistoryPolicy)parentDescriptor.getHistoryPolicy().clone());
        }
        if (this.getCMPPolicy() != null) {
            this.getCMPPolicy().initialize(this, session);
        }
        if (this.hasFetchGroupManager()) {
            this.getFetchGroupManager().initialize(session);
        }
        if (this.getObjectChangePolicyInternal() == null && ChangeTracker.class.isAssignableFrom(this.getJavaClass()) && (Arrays.asList(this.getJavaClass().getInterfaces()).contains(PersistenceWeavedChangeTracking.class) || DynamicEntityImpl.class.isAssignableFrom(this.getJavaClass())) && this.supportsChangeTracking(session.getProject())) {
            this.setObjectChangePolicy(new AttributeChangeTrackingPolicy());
        }
        this.getObjectChangePolicy().initialize(session, this);
        if (this.defaultReadAllQueryRedirector == null) {
            this.defaultReadAllQueryRedirector = this.defaultQueryRedirector;
        }
        if (this.defaultReadObjectQueryRedirector == null) {
            this.defaultReadObjectQueryRedirector = this.defaultQueryRedirector;
        }
        if (this.defaultReportQueryRedirector == null) {
            this.defaultReportQueryRedirector = this.defaultQueryRedirector;
        }
        if (this.defaultInsertObjectQueryRedirector == null) {
            this.defaultInsertObjectQueryRedirector = this.defaultQueryRedirector;
        }
        if (this.defaultUpdateObjectQueryRedirector == null) {
            this.defaultUpdateObjectQueryRedirector = this.defaultQueryRedirector;
        }
    }

    public void initialize(DescriptorQueryManager queryManager, AbstractSession session) {
        if (!queryManager.hasReadObjectQuery()) {
            ReadObjectQuery readObjectQuery = new ReadObjectQuery();
            readObjectQuery.setSelectionCriteria(this.getObjectBuilder().getPrimaryKeyExpression());
            queryManager.setReadObjectQuery(readObjectQuery);
        }
        queryManager.getReadObjectQuery().setName("read" + this.getJavaClass().getSimpleName());
        if (!queryManager.hasInsertQuery()) {
            queryManager.setInsertQuery(new InsertObjectQuery());
        }
        queryManager.getInsertQuery().setModifyRow(this.getObjectBuilder().buildTemplateInsertRow(session));
        if (!this.usesFieldLocking()) {
            if (!queryManager.hasDeleteQuery()) {
                queryManager.setDeleteQuery(new DeleteObjectQuery());
            }
            queryManager.getDeleteQuery().setModifyRow(new DatabaseRecord());
        }
        if (queryManager.hasUpdateQuery()) {
            queryManager.getUpdateQuery().setModifyRow(this.getObjectBuilder().buildTemplateUpdateRow(session));
        }
    }

    public void initializeAggregateInheritancePolicy(AbstractSession session) {
        ClassDescriptor parentDescriptor = session.getDescriptor(this.getInheritancePolicy().getParentClass());
        parentDescriptor.getInheritancePolicy().addChildDescriptor(this);
    }

    public void initializeMultipleTablePrimaryKeyFields() {
        DatabaseTable table;
        boolean isChild;
        int tableSize = this.getTables().size();
        int additionalTablesSize = tableSize - 1;
        boolean bl = isChild = this.hasInheritance() && this.getInheritancePolicy().isChildDescriptor();
        if (isChild) {
            additionalTablesSize = tableSize - this.getInheritancePolicy().getParentDescriptor().getTables().size();
        }
        if (tableSize <= 1) {
            return;
        }
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression joinExpression = this.getQueryManager().getMultipleTableJoinExpression();
        int index = 1;
        while (index < tableSize) {
            table = this.getTables().get(index);
            Map<DatabaseField, DatabaseField> oldKeyMapping = this.getAdditionalTablePrimaryKeyFields().get(table);
            if (oldKeyMapping != null) {
                if (!this.getQueryManager().hasCustomMultipleTableJoinExpression()) {
                    Expression keyJoinExpression = null;
                    for (Map.Entry<DatabaseField, DatabaseField> entry : oldKeyMapping.entrySet()) {
                        DatabaseField sourceTableField = entry.getKey();
                        DatabaseField targetTableField = entry.getValue();
                        if (!this.getFields().contains(sourceTableField)) {
                            this.getFields().add(sourceTableField);
                        }
                        if (!this.getFields().contains(targetTableField)) {
                            this.getFields().add(targetTableField);
                        }
                        keyJoinExpression = builder.getField(targetTableField).equal(builder.getField(sourceTableField)).and(keyJoinExpression);
                    }
                    if (keyJoinExpression != null) {
                        joinExpression = keyJoinExpression.and(joinExpression);
                    }
                    this.getQueryManager().getTablesJoinExpressions().put(table, keyJoinExpression);
                }
            } else {
                HashMap<DatabaseField, DatabaseField> newKeyMapping = new HashMap<DatabaseField, DatabaseField>(this.getPrimaryKeyFields().size());
                this.getAdditionalTablePrimaryKeyFields().put(table, newKeyMapping);
                Expression keyJoinExpression = null;
                for (DatabaseField primaryKeyField : this.getPrimaryKeyFields()) {
                    DatabaseField secondaryKeyField = primaryKeyField.clone();
                    secondaryKeyField.setTable(table);
                    newKeyMapping.put(primaryKeyField, secondaryKeyField);
                    this.getFields().add(this.buildField(secondaryKeyField));
                    if (this.getQueryManager().hasCustomMultipleTableJoinExpression()) continue;
                    keyJoinExpression = builder.getField(secondaryKeyField).equal(builder.getField(primaryKeyField)).and(keyJoinExpression);
                }
                if (keyJoinExpression != null) {
                    joinExpression = keyJoinExpression.and(joinExpression);
                }
                this.getQueryManager().getTablesJoinExpressions().put(table, keyJoinExpression);
            }
            ++index;
        }
        if (joinExpression != null) {
            this.getQueryManager().setInternalMultipleTableJoinExpression(joinExpression);
        }
        if (this.getQueryManager().hasCustomMultipleTableJoinExpression()) {
            Map tablesJoinExpressions = SQLSelectStatement.mapTableToExpression(joinExpression, this.getTables());
            this.getQueryManager().getTablesJoinExpressions().putAll(tablesJoinExpressions);
        }
        if (isChild && additionalTablesSize > 0) {
            index = tableSize - additionalTablesSize;
            while (index < tableSize) {
                table = this.getTables().get(index);
                this.getInheritancePolicy().addChildTableJoinExpressionToAllParents(table, this.getQueryManager().getTablesJoinExpressions().get(table));
                ++index;
            }
        }
    }

    protected void initializeProperties(AbstractSession session) throws DescriptorException {
        if (!this.isAggregateDescriptor()) {
            if (!this.isChildDescriptor()) {
                int index = 0;
                while (index < this.getPrimaryKeyFields().size()) {
                    DatabaseField primaryKey = this.getPrimaryKeyFields().get(index);
                    primaryKey = this.buildField(primaryKey);
                    primaryKey.setPrimaryKey(true);
                    this.getPrimaryKeyFields().set(index, primaryKey);
                    ++index;
                }
                List primaryKeyFields = (List)((ArrayList)this.getPrimaryKeyFields()).clone();
                int index2 = 0;
                while (index2 < primaryKeyFields.size()) {
                    DatabaseField primaryKey = (DatabaseField)primaryKeyFields.get(index2);
                    if (!primaryKey.getTable().equals(this.getDefaultTable())) {
                        this.getPrimaryKeyFields().remove(primaryKey);
                    }
                    ++index2;
                }
            }
            if (this.getSequenceNumberField() != null) {
                this.setSequenceNumberField(this.buildField(this.getSequenceNumberField()));
            }
        }
        this.setSessionName(session.getName());
    }

    public void interfaceInitialization(AbstractSession session) throws DescriptorException {
        if (this.isInterfaceInitialized(2)) {
            return;
        }
        this.setInterfaceInitializationStage(2);
        if (this.isInterfaceChildDescriptor()) {
            for (Class parentInterface : this.getInterfacePolicy().getParentInterfaces()) {
                ClassDescriptor parentDescriptor = session.getDescriptor(parentInterface);
                parentDescriptor.interfaceInitialization(session);
                if (this.isDescriptorForInterface()) {
                    this.setQueryKeys(Helper.concatenateMaps(this.getQueryKeys(), parentDescriptor.getQueryKeys()));
                } else {
                    for (String queryKeyName : parentDescriptor.getQueryKeys().keySet()) {
                        if (this.hasQueryKeyOrMapping(queryKeyName)) continue;
                        session.getIntegrityChecker().handleError(DescriptorException.childDoesNotDefineAbstractQueryKeyOfParent(this, parentDescriptor, queryKeyName));
                    }
                }
                if (parentDescriptor != this) continue;
                return;
            }
        }
        this.getInterfacePolicy().initialize(session);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getJavaClass().getModifiers());
    }

    public boolean isAggregateCollectionDescriptor() {
        return this.descriptorType == 3;
    }

    public boolean isAggregateDescriptor() {
        return this.descriptorType == 2;
    }

    public boolean isChildDescriptor() {
        return this.hasInheritance() && this.getInheritancePolicy().isChildDescriptor();
    }

    public boolean isEISDescriptor() {
        return false;
    }

    public boolean isObjectRelationalDataTypeDescriptor() {
        return false;
    }

    public boolean isXMLDescriptor() {
        return false;
    }

    public boolean isRelationalDescriptor() {
        return false;
    }

    public boolean isDescriptorForInterface() {
        return this.descriptorType == 1;
    }

    public boolean isDescriptorTypeAggregate() {
        return this.descriptorType == 3 || this.descriptorType == 2;
    }

    public boolean isDescriptorTypeNormal() {
        return this.descriptorType == 0;
    }

    public boolean isFullyInitialized() {
        return this.initializationStage == 3;
    }

    protected boolean isInitialized(int initializationStage) {
        return this.initializationStage >= initializationStage;
    }

    public boolean isInterfaceChildDescriptor() {
        return this.hasInterfacePolicy() && this.getInterfacePolicy().isInterfaceChildDescriptor();
    }

    protected boolean isInterfaceInitialized(int interfaceInitializationStage) {
        return this.interfaceInitializationStage >= interfaceInitializationStage;
    }

    public boolean isInvalid() {
        return this.initializationStage == -1;
    }

    public boolean isIsolated() {
        return this.getCachePolicy().isIsolated();
    }

    public boolean isProtectedIsolation() {
        return this.getCachePolicy().isProtectedIsolation();
    }

    public boolean isSharedIsolation() {
        return this.getCachePolicy().isSharedIsolation();
    }

    public boolean isMultipleTableDescriptor() {
        return this.getTables().size() > 1;
    }

    public boolean isPrimaryKeySetAfterInsert(AbstractSession session) {
        return this.usesSequenceNumbers() && this.getSequence().shouldAcquireValueAfterInsert() || this.hasReturningPolicy() && this.getReturningPolicy().isUsedToSetPrimaryKey();
    }

    public boolean shouldLockForClone() {
        return this.shouldLockForClone;
    }

    public boolean shouldUseFullChangeSetsForNewObjects() {
        return this.getCachePolicy().getCacheSynchronizationType() == 3 || shouldUseFullChangeSetsForNewObjects;
    }

    public void onlyRefreshCacheIfNewerVersion() {
        this.setShouldOnlyRefreshCacheIfNewerVersion(true);
    }

    public void postInitialize(AbstractSession session) throws DescriptorException {
        if (this.getHistoryPolicy() != null) {
            session.getProject().setHasGenericHistorySupport(true);
        }
        if (this.isInitialized(3) || this.isInvalid()) {
            return;
        }
        this.setInitializationStage(3);
        if (this.hasInheritance()) {
            for (ClassDescriptor child : this.getInheritancePolicy().getChildDescriptors()) {
                child.postInitialize(session);
            }
        }
        for (DatabaseMapping mapping : this.getMappings()) {
            mapping.postInitialize(session);
            if (!this.shouldAcquireCascadedLocks()) {
                if (mapping.isForeignReferenceMapping()) {
                    if (!((ForeignReferenceMapping)mapping).usesIndirection()) {
                        this.setShouldAcquireCascadedLocks(true);
                    }
                    this.hasRelationships = true;
                }
                if (mapping instanceof AggregateObjectMapping) {
                    if (mapping.getReferenceDescriptor().shouldAcquireCascadedLocks()) {
                        this.setShouldAcquireCascadedLocks(true);
                    }
                    if (mapping.getReferenceDescriptor().hasRelationships()) {
                        this.hasRelationships = true;
                    }
                }
            }
            if (this.getCachePolicy().isProtectedIsolation() && (mapping.isForeignReferenceMapping() && !mapping.isCacheable() || mapping.isAggregateObjectMapping() && mapping.getReferenceDescriptor().hasNoncacheableMappings())) {
                mapping.collectQueryParameters(this.foreignKeyValuesForCaching);
            }
            if (!mapping.isLockableMapping()) continue;
            this.getLockableMappings().add(mapping);
        }
        if (this.hasInheritance()) {
            this.getInheritancePolicy().postInitialize(session);
        }
        int index = this.getPrimaryKeyFields().size() - 1;
        while (index >= 0) {
            DatabaseField primaryKeyField = this.getPrimaryKeyFields().get(index);
            int fieldIndex = this.getFields().indexOf(primaryKeyField);
            if (fieldIndex != -1) {
                primaryKeyField = this.getFields().get(fieldIndex);
                this.getPrimaryKeyFields().set(index, primaryKeyField);
                primaryKeyField.setPrimaryKey(true);
            }
            --index;
        }
        List<DatabaseField> sopSelectionFields = null;
        if (this.hasSerializedObjectPolicy()) {
            this.getSerializedObjectPolicy().postInitialize(session);
            this.selectionFields = (List)this.getFields().clone();
            this.selectionFields.remove(this.getSerializedObjectPolicy().getField());
            this.allSelectionFields = (List)this.getAllFields().clone();
            this.allSelectionFields.remove(this.getSerializedObjectPolicy().getField());
            sopSelectionFields = this.getSerializedObjectPolicy().getSelectionFields();
            if (sopSelectionFields.size() == this.getFields().size()) {
                sopSelectionFields = null;
            }
        } else {
            this.selectionFields = this.getFields();
            this.allSelectionFields = this.getAllFields();
        }
        int index2 = 0;
        while (index2 < this.getFields().size()) {
            int sopFieldIndex;
            DatabaseMapping mapping;
            DatabaseField field = this.getFields().elementAt(index2);
            if (field.getType() == null && (mapping = this.getObjectBuilder().getMappingForField(field)) != null) {
                field.setType(mapping.getFieldClassification(field));
            }
            if (field.getType() == ClassConstants.BLOB || field.getType() == ClassConstants.CLOB) {
                this.setHasMultipleTableConstraintDependecy(true);
            }
            field.setIndex(index2);
            if (sopSelectionFields != null && (sopFieldIndex = sopSelectionFields.indexOf(field)) != -1) {
                field.setIndex(sopFieldIndex);
            }
            ++index2;
        }
        for (DatabaseMapping mapping : this.getMappings()) {
            mapping.postInitializeSourceAndTargetExpressions();
        }
        if (this.getCachePolicy().getCacheKeyType() == null || this.getCachePolicy().getCacheKeyType() == CacheKeyType.AUTO) {
            if (this.getPrimaryKeyFields().size() > 1 || this.getObjectBuilder().isXMLObjectBuilder()) {
                this.setCacheKeyType(CacheKeyType.CACHE_ID);
            } else if (this.getPrimaryKeyFields().size() == 1 && this.getObjectBuilder().getPrimaryKeyClassifications().size() == 1) {
                Class type = this.getObjectBuilder().getPrimaryKeyClassifications().get(0);
                if (type == null || type.isArray()) {
                    this.getCachePolicy().setCacheKeyType(CacheKeyType.CACHE_ID);
                } else {
                    this.getCachePolicy().setCacheKeyType(CacheKeyType.ID_VALUE);
                }
            } else {
                this.getCachePolicy().setCacheKeyType(CacheKeyType.CACHE_ID);
            }
        } else if (this.getCachePolicy().getCacheKeyType() == CacheKeyType.ID_VALUE && this.getPrimaryKeyFields().size() > 1) {
            session.getIntegrityChecker().handleError(DescriptorException.cannotUseIdValueForCompositeId(this));
        }
        if (this.hasFetchGroupManager()) {
            this.getFetchGroupManager().postInitialize(session);
        }
        this.getObjectBuilder().postInitialize(session);
        this.getQueryManager().postInitialize(session);
        if (this.hasMultitenantPolicy()) {
            this.getMultitenantPolicy().postInitialize(session);
        }
        this.getCachePolicy().postInitialize(this, session);
        this.validateAfterInitialization(session);
        this.checkDatabase(session);
    }

    public void notifyReferencingDescriptorsOfIsolation(AbstractSession session) {
        for (ClassDescriptor descriptor : this.referencingClasses) {
            if (descriptor.getCachePolicy().getCacheIsolation() != null && descriptor.getCachePolicy().getCacheIsolation() != CacheIsolationType.SHARED) continue;
            descriptor.getCachePolicy().setCacheIsolation(CacheIsolationType.PROTECTED);
            descriptor.getCachePolicy().postInitialize(descriptor, session);
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                if (!mapping.isAggregateMapping() || mapping.getReferenceDescriptor() == null) continue;
                mapping.getReferenceDescriptor().getCachePolicy().setCacheIsolation(CacheIsolationType.PROTECTED);
            }
        }
    }

    public void preInitialize(AbstractSession session) throws DescriptorException {
        if (this.isInitialized(1)) {
            return;
        }
        this.setInitializationStage(1);
        this.assignDefaultValues(session);
        if (this.isCascadeOnDeleteSetOnDatabaseOnSecondaryTables && !session.getPlatform().supportsDeleteOnCascade()) {
            this.isCascadeOnDeleteSetOnDatabaseOnSecondaryTables = false;
        }
        if (FetchGroupTracker.class.isAssignableFrom(this.getJavaClass()) && this.getFetchGroupManager() == null && !this.isAggregateDescriptor()) {
            this.setFetchGroupManager(new FetchGroupManager());
        }
        if (Arrays.asList(this.getJavaClass().getInterfaces()).contains(PersistenceObject.class)) {
            boolean isMethodAccess = false;
            for (DatabaseMapping mapping : this.getMappings()) {
                if (mapping.isUsingMethodAccess()) {
                    if (mapping.isOneToOneMapping() && ((ForeignReferenceMapping)mapping).usesIndirection()) continue;
                    isMethodAccess = true;
                    continue;
                }
                if (mapping.isWriteOnly()) continue;
                mapping.setAttributeAccessor(new PersistenceObjectAttributeAccessor(mapping.getAttributeName()));
            }
            if (!isMethodAccess) {
                if (this.copyPolicy == null) {
                    this.setCopyPolicy(new PersistenceEntityCopyPolicy());
                }
                if (!this.isAbstract()) {
                    try {
                        if (this.instantiationPolicy == null) {
                            this.setInstantiationPolicy(new PersistenceObjectInstantiationPolicy((PersistenceObject)this.getJavaClass().newInstance()));
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        for (DatabaseTable next : this.getTables()) {
            if (next.getName().indexOf(32) == -1) continue;
            next.setUseDelimiters(true);
        }
        for (DatabaseMapping mapping : this.getMappings()) {
            try {
                mapping.preInitialize(session);
            }
            catch (DescriptorException exception) {
                session.getIntegrityChecker().handleError(exception);
            }
        }
        this.validateBeforeInitialization(session);
        this.preInitializeInheritancePolicy(session);
        if (this.hasInheritance()) {
            this.getInheritancePolicy().preInitialize(session);
        } else {
            this.setInternalDefaultTable();
        }
        if (this.hasMultitenantPolicy()) {
            this.getMultitenantPolicy().preInitialize(session);
        }
        this.verifyTableQualifiers(session.getDatasourcePlatform());
        this.initializeProperties(session);
        if (!this.isAggregateDescriptor()) {
            this.adjustMultipleTableInsertOrder();
            this.initializeMultipleTablePrimaryKeyFields();
        }
        if (this.hasInterfacePolicy()) {
            this.preInterfaceInitialization(session);
        }
        this.getQueryManager().preInitialize(session);
    }

    protected void prepareCascadeLockingPolicy(DatabaseMapping mapping) {
        if (mapping.isPrivateOwned() && mapping.isForeignReferenceMapping()) {
            if (mapping.isCascadedLockingSupported()) {
                if (((ForeignReferenceMapping)mapping).hasCustomSelectionQuery()) {
                    throw ValidationException.unsupportedCascadeLockingMappingWithCustomQuery(mapping);
                }
                if (this.isDescriptorTypeAggregate()) {
                    throw ValidationException.unsupportedCascadeLockingDescriptor(this);
                }
                mapping.prepareCascadeLockingPolicy();
            } else {
                throw ValidationException.unsupportedCascadeLockingMapping(mapping);
            }
        }
    }

    protected void preInitializeInheritancePolicy(AbstractSession session) throws DescriptorException {
        if (this.isChildDescriptor() && this.requiresInitialization(session)) {
            if (this.getInheritancePolicy().getParentClass().equals(this.getJavaClass())) {
                this.setInterfaceInitializationStage(-1);
                throw DescriptorException.parentClassIsSelf(this);
            }
            ClassDescriptor parentDescriptor = session.getDescriptor(this.getInheritancePolicy().getParentClass());
            parentDescriptor.getInheritancePolicy().addChildDescriptor(this);
            this.getInheritancePolicy().setParentDescriptor(parentDescriptor);
            parentDescriptor.preInitialize(session);
        }
    }

    public void preInterfaceInitialization(AbstractSession session) throws DescriptorException {
        if (this.isInterfaceInitialized(1)) {
            return;
        }
        this.setInterfaceInitializationStage(1);
        this.assignDefaultValues(session);
        if (this.isInterfaceChildDescriptor()) {
            for (Class parentInterface : this.getInterfacePolicy().getParentInterfaces()) {
                ClassDescriptor parentDescriptor = session.getDescriptor(parentInterface);
                if (parentDescriptor == null || parentDescriptor.getJavaClass() == this.getJavaClass() || parentDescriptor.getInterfacePolicy().usesImplementorDescriptor()) {
                    session.getProject().getDescriptors().put(parentInterface, this);
                    session.clearLastDescriptorAccessed();
                    continue;
                }
                if (!parentDescriptor.isDescriptorForInterface()) {
                    throw DescriptorException.descriptorForInterfaceIsMissing(parentInterface.getName());
                }
                parentDescriptor.preInterfaceInitialization(session);
                parentDescriptor.getInterfacePolicy().addChildDescriptor(this);
                this.getInterfacePolicy().addParentDescriptor(parentDescriptor);
            }
        }
    }

    public void rehashFieldDependancies(AbstractSession session) {
        this.getObjectBuilder().rehashFieldDependancies(session);
        Enumeration<DatabaseMapping> enumtr = this.getMappings().elements();
        while (enumtr.hasMoreElements()) {
            enumtr.nextElement().rehashFieldDependancies(session);
        }
    }

    public void reInitializeJoinedAttributes() {
        if (!this.isInitialized(3)) {
            return;
        }
        this.getObjectBuilder().initializeJoinedAttributes();
        if (this.hasInheritance()) {
            for (ClassDescriptor child : this.getInheritancePolicy().getChildDescriptors()) {
                child.reInitializeJoinedAttributes();
            }
        }
    }

    public void remoteInitialization(DistributedSession session) {
        if (this.getHistoryPolicy() != null) {
            session.getProject().setHasGenericHistorySupport(true);
        }
        if (!this.getCachePolicy().isSharedIsolation()) {
            session.getProject().setHasIsolatedClasses(true);
        }
        if (!this.getCachePolicy().shouldIsolateObjectsInUnitOfWork() && !this.shouldBeReadOnly()) {
            session.getProject().setHasNonIsolatedUOWClasses(true);
        }
        for (DatabaseMapping mapping : this.getMappings()) {
            mapping.remoteInitialization(session);
        }
        this.getEventManager().remoteInitialization(session);
        this.getInstantiationPolicy().initialize(session);
        this.getCopyPolicy().initialize(session);
        if (this.hasInheritance()) {
            this.getInheritancePolicy().remoteInitialization(session);
        }
        if (this.getCMPPolicy() != null) {
            this.getCMPPolicy().remoteInitialize(this, session);
        }
    }

    public void removeProperty(String property) {
        this.getProperties().remove(property);
    }

    public boolean requiresInitialization(AbstractSession session) {
        if (this.isDescriptorTypeAggregate() || this.isDescriptorForInterface()) {
            return false;
        }
        if (this.hasTablePerMultitenantPolicy()) {
            return ((TablePerMultitenantPolicy)this.getMultitenantPolicy()).shouldInitialize(session);
        }
        return true;
    }

    protected void selfValidationAfterInitialization(AbstractSession session) throws DescriptorException {
        if (!(this.hasInheritance() && (this.getInheritancePolicy().shouldReadSubclasses() || this.isAbstract()) || this.hasTablePerClassPolicy() && this.isAbstract() || !session.getIntegrityChecker().shouldCheckInstantiationPolicy())) {
            this.getInstantiationPolicy().buildNewInstance();
        }
        if (this.hasReturningPolicy()) {
            this.getReturningPolicy().validationAfterDescriptorInitialization(session);
        }
        this.getObjectBuilder().validate(session);
    }

    protected void selfValidationBeforeInitialization(AbstractSession session) throws DescriptorException {
        if (this.isChildDescriptor()) {
            ClassDescriptor parentDescriptor = session.getDescriptor(this.getInheritancePolicy().getParentClass());
            if (parentDescriptor == null) {
                session.getIntegrityChecker().handleError(DescriptorException.parentDescriptorNotSpecified(this.getInheritancePolicy().getParentClass().getName(), this));
            }
        } else if (this.getTables().isEmpty() && !this.isAggregateDescriptor()) {
            session.getIntegrityChecker().handleError(DescriptorException.tableNotSpecified(this));
        }
        if (!this.isChildDescriptor() && !this.isDescriptorTypeAggregate() && ((Vector)this.getPrimaryKeyFieldNames()).isEmpty()) {
            session.getIntegrityChecker().handleError(DescriptorException.primaryKeyFieldsNotSepcified(this));
        }
        if (this.getIdentityMapClass() == ClassConstants.NoIdentityMap_Class && this.getQueryManager().getDoesExistQuery().shouldCheckCacheForDoesExist()) {
            session.getIntegrityChecker().handleError(DescriptorException.identityMapNotSpecified(this));
        }
        if (this.getSequenceNumberName() != null && this.getSequenceNumberField() == null || this.getSequenceNumberName() == null && this.getSequenceNumberField() != null) {
            session.getIntegrityChecker().handleError(DescriptorException.sequenceNumberPropertyNotSpecified(this));
        }
    }

    protected void setAdditionalTablePrimaryKeyFields(DatabaseTable table, DatabaseField field1, DatabaseField field2) {
        Map<DatabaseField, DatabaseField> tableAdditionalPKFields = this.getAdditionalTablePrimaryKeyFields().get(table);
        if (tableAdditionalPKFields == null) {
            tableAdditionalPKFields = new HashMap<DatabaseField, DatabaseField>(2);
            this.getAdditionalTablePrimaryKeyFields().put(table, tableAdditionalPKFields);
        }
        tableAdditionalPKFields.put(field1, field2);
    }

    protected void toggleAdditionalTablePrimaryKeyFields() {
        if (this.additionalTablePrimaryKeyFields == null) {
            return;
        }
        int nProcessedTables = 1;
        if (this.isChildDescriptor()) {
            nProcessedTables = this.getInheritancePolicy().getParentDescriptor().getTables().size();
            if (this.getTables().size() > nProcessedTables) {
                ++nProcessedTables;
            }
        }
        Map<DatabaseTable, Map<DatabaseField, DatabaseField>> additionalTablePrimaryKeyFieldsOld = this.additionalTablePrimaryKeyFields;
        this.additionalTablePrimaryKeyFields = null;
        for (Map.Entry<DatabaseTable, Map<DatabaseField, DatabaseField>> entryTable : additionalTablePrimaryKeyFieldsOld.entrySet()) {
            DatabaseTable sourceTable = entryTable.getKey();
            boolean isSourceProcessed = this.getTables().indexOf(sourceTable) < nProcessedTables;
            int sourceInsertOrderIndex = this.getMultipleTableInsertOrder().indexOf(sourceTable);
            Map<DatabaseField, DatabaseField> targetTableAdditionalPKFields = entryTable.getValue();
            for (Map.Entry<DatabaseField, DatabaseField> entryField : targetTableAdditionalPKFields.entrySet()) {
                DatabaseField targetField = entryField.getKey();
                DatabaseField sourceField = entryField.getValue();
                DatabaseTable targetTable = targetField.getTable();
                boolean isTargetProcessed = this.getTables().indexOf(targetTable) < nProcessedTables;
                int targetInsertOrderIndex = this.getMultipleTableInsertOrder().indexOf(targetTable);
                if (!isTargetProcessed && (isSourceProcessed || sourceInsertOrderIndex > targetInsertOrderIndex)) {
                    this.setAdditionalTablePrimaryKeyFields(targetTable, sourceField, targetField);
                    continue;
                }
                this.setAdditionalTablePrimaryKeyFields(sourceTable, targetField, sourceField);
            }
        }
    }

    public void setAdditionalTablePrimaryKeyFields(Map<DatabaseTable, Map<DatabaseField, DatabaseField>> additionalTablePrimaryKeyFields) {
        this.additionalTablePrimaryKeyFields = additionalTablePrimaryKeyFields;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    protected void setAllFields(Vector<DatabaseField> allFields) {
        this.allFields = allFields;
    }

    public void setAmendmentClass(Class amendmentClass) {
        this.amendmentClass = amendmentClass;
    }

    public void setAmendmentClassName(String amendmentClassName) {
        this.amendmentClassName = amendmentClassName;
    }

    public void setAmendmentMethodName(String amendmentMethodName) {
        this.amendmentMethodName = amendmentMethodName;
    }

    public void setAccessorTree(List<AttributeAccessor> accessorTree) {
        this.accessorTree = accessorTree;
    }

    public void setCacheSynchronizationType(int type) {
        this.getCachePolicy().setCacheSynchronizationType(type);
    }

    public void setObjectChangePolicy(ObjectChangePolicy policy) {
        this.changePolicy = policy;
    }

    public void setHistoryPolicy(HistoryPolicy policy) {
        this.historyPolicy = policy;
        if (policy != null) {
            policy.setDescriptor(this);
        }
    }

    public void setCacheInterceptorClass(Class cacheInterceptorClass) {
        this.getCachePolicy().setCacheInterceptorClass(cacheInterceptorClass);
    }

    public void setCacheInterceptorClassName(String cacheInterceptorClassName) {
        this.getCachePolicy().setCacheInterceptorClassName(cacheInterceptorClassName);
    }

    public void setCacheInvalidationPolicy(CacheInvalidationPolicy policy) {
        this.cacheInvalidationPolicy = policy;
    }

    public void setConstraintDependencies(Vector constraintDependencies) {
        this.constraintDependencies = constraintDependencies;
    }

    public void setCopyPolicy(CopyPolicy policy) {
        this.copyPolicy = policy;
        if (policy != null) {
            policy.setDescriptor(this);
        }
    }

    public void setCopyPolicyClassName(String className) {
        this.copyPolicyClassName = className;
    }

    public void setDefaultTable(DatabaseTable defaultTable) {
        this.defaultTable = defaultTable;
    }

    public void setDefaultTableName(String defaultTableName) {
        this.setDefaultTable(new DatabaseTable(defaultTableName));
    }

    public void setDescriptorCustomizerClassName(String descriptorCustomizerClassName) {
        this.descriptorCustomizerClassName = descriptorCustomizerClassName;
    }

    public void setDescriptorType(int descriptorType) {
        this.descriptorType = descriptorType;
    }

    public void setDescriptorTypeValue(String value) {
        if (value.equals("Aggregate collection")) {
            this.descriptorIsAggregateCollection();
        } else if (value.equals("Aggregate")) {
            this.descriptorIsAggregate();
        } else if (value.equals("Interface")) {
            this.descriptorIsForInterface();
        } else {
            this.descriptorIsNormal();
        }
    }

    @Override
    public void setEventManager(DescriptorEventManager eventManager) {
        this.eventManager = eventManager;
        if (eventManager != null) {
            eventManager.setDescriptor(this);
        }
    }

    public void setExistenceChecking(String token) throws DescriptorException {
        this.getQueryManager().setExistenceCheck(token);
    }

    public void setFields(Vector<DatabaseField> fields) {
        this.fields = fields;
    }

    public void setForeignKeyFieldNamesForMultipleTable(Vector associations) throws DescriptorException {
        Enumeration foreignKeys = associations.elements();
        while (foreignKeys.hasMoreElements()) {
            Association association = (Association)foreignKeys.nextElement();
            this.addForeignKeyFieldNameForMultipleTable((String)association.getKey(), (String)association.getValue());
        }
    }

    public void setFullyMergeEntity(boolean fullyMergeEntity) {
        this.getCachePolicy().setFullyMergeEntity(fullyMergeEntity);
    }

    public void setIdentityMapClass(Class theIdentityMapClass) {
        this.getCachePolicy().setIdentityMapClass(theIdentityMapClass);
    }

    public void setIdentityMapSize(int identityMapSize) {
        this.getCachePolicy().setIdentityMapSize(identityMapSize);
    }

    @Override
    public void setInheritancePolicy(InheritancePolicy inheritancePolicy) {
        this.inheritancePolicy = inheritancePolicy;
        if (inheritancePolicy != null) {
            inheritancePolicy.setDescriptor(this);
        }
    }

    public void setReturningPolicy(ReturningPolicy returningPolicy) {
        this.returningPolicy = returningPolicy;
        if (returningPolicy != null) {
            returningPolicy.setDescriptor(this);
        }
    }

    protected void setInitializationStage(int initializationStage) {
        this.initializationStage = initializationStage;
    }

    @Override
    public void setInstantiationPolicy(InstantiationPolicy instantiationPolicy) {
        this.instantiationPolicy = instantiationPolicy;
        if (instantiationPolicy != null) {
            instantiationPolicy.setDescriptor(this);
        }
    }

    protected void setInterfaceInitializationStage(int interfaceInitializationStage) {
        this.interfaceInitializationStage = interfaceInitializationStage;
    }

    public void setInterfacePolicy(InterfacePolicy interfacePolicy) {
        this.interfacePolicy = interfacePolicy;
        if (interfacePolicy != null) {
            interfacePolicy.setDescriptor(this);
        }
    }

    public void setInternalDefaultTable() {
        if (this.getDefaultTable() == null) {
            this.setDefaultTable(this.extractDefaultTable());
        }
    }

    public void setInternalDefaultTable(DatabaseTable defaultTable) {
        if (this.getDefaultTable() == null) {
            this.setDefaultTable(defaultTable);
        }
    }

    @Deprecated
    public void setIsIsolated(boolean isIsolated) {
        this.getCachePolicy().setCacheIsolation(isIsolated ? CacheIsolationType.ISOLATED : CacheIsolationType.SHARED);
    }

    public void setCacheable(Boolean cacheable) {
        this.getCachePolicy().setCacheable(cacheable);
    }

    public CacheIsolationType getCacheIsolation() {
        return this.getCachePolicy().getCacheIsolation();
    }

    public void setCacheIsolation(CacheIsolationType isolationType) {
        this.getCachePolicy().setCacheIsolation(isolationType);
    }

    public boolean shouldIsolateObjectsInUnitOfWork() {
        return this.getCachePolicy().shouldIsolateObjectsInUnitOfWork();
    }

    public boolean shouldIsolateProtectedObjectsInUnitOfWork() {
        return this.getCachePolicy().shouldIsolateProtectedObjectsInUnitOfWork();
    }

    public boolean shouldIsolateObjectsInUnitOfWorkEarlyTransaction() {
        return this.getCachePolicy().shouldIsolateObjectsInUnitOfWorkEarlyTransaction();
    }

    public boolean shouldUseSessionCacheInUnitOfWorkEarlyTransaction() {
        return this.getCachePolicy().shouldUseSessionCacheInUnitOfWorkEarlyTransaction();
    }

    public Map<String, List<String>> getUnconvertedProperties() {
        if (this.unconvertedProperties == null) {
            this.unconvertedProperties = new HashMap<String, List<String>>(5);
        }
        return this.unconvertedProperties;
    }

    public int getUnitOfWorkCacheIsolationLevel() {
        return this.getCachePolicy().getUnitOfWorkCacheIsolationLevel();
    }

    public void setUnitOfWorkCacheIsolationLevel(int unitOfWorkCacheIsolationLevel) {
        this.getCachePolicy().setUnitOfWorkCacheIsolationLevel(unitOfWorkCacheIsolationLevel);
    }

    public void setHasRelationships(boolean hasRelationships) {
        this.hasRelationships = hasRelationships;
    }

    @Override
    public void setJavaClass(Class theJavaClass) {
        this.javaClass = theJavaClass;
    }

    public void setJavaClassName(String theJavaClassName) {
        this.javaClassName = theJavaClassName;
    }

    public void setJavaInterface(Class theJavaInterface) {
        this.javaClass = theJavaInterface;
        this.descriptorIsForInterface();
    }

    public void setJavaInterfaceName(String theJavaInterfaceName) {
        this.javaClassName = theJavaInterfaceName;
        this.descriptorIsForInterface();
    }

    public void setLockableMappings(List<DatabaseMapping> lockableMappings) {
        this.lockableMappings = lockableMappings;
    }

    public void setMappings(Vector<DatabaseMapping> mappings) {
        Enumeration<DatabaseMapping> mappingsEnum = mappings.elements();
        while (mappingsEnum.hasMoreElements()) {
            DatabaseMapping mapping = mappingsEnum.nextElement();
            if (mapping.getDescriptor() != null) continue;
            mapping.setDescriptor(this);
        }
        this.mappings = mappings;
    }

    protected void setMultipleTableForeignKeys(Map<DatabaseTable, Set<DatabaseTable>> newValue) {
        this.multipleTableForeignKeys = newValue;
    }

    public void setMultipleTableInsertOrder(List<DatabaseTable> newValue) {
        this.multipleTableInsertOrder = newValue;
    }

    public void setMultitenantPolicy(MultitenantPolicy multitenantPolicy) {
        this.multitenantPolicy = multitenantPolicy;
    }

    public boolean isCascadeOnDeleteSetOnDatabaseOnSecondaryTables() {
        return this.isCascadeOnDeleteSetOnDatabaseOnSecondaryTables;
    }

    public void setIsCascadeOnDeleteSetOnDatabaseOnSecondaryTables(boolean isCascadeOnDeleteSetOnDatabaseOnSecondaryTables) {
        this.isCascadeOnDeleteSetOnDatabaseOnSecondaryTables = isCascadeOnDeleteSetOnDatabaseOnSecondaryTables;
    }

    @Override
    protected void setObjectBuilder(ObjectBuilder builder) {
        this.objectBuilder = builder;
    }

    public void setOptimisticLockingPolicy(OptimisticLockingPolicy optimisticLockingPolicy) {
        this.optimisticLockingPolicy = optimisticLockingPolicy;
        if (optimisticLockingPolicy != null) {
            optimisticLockingPolicy.setDescriptor(this);
        }
    }

    public void setPrimaryKeyFieldName(String fieldName) {
        this.addPrimaryKeyFieldName(fieldName);
    }

    @Override
    public void setPrimaryKeyFieldNames(Vector primaryKeyFieldsName) {
        this.setPrimaryKeyFields((List<DatabaseField>)new ArrayList<DatabaseField>(primaryKeyFieldsName.size()));
        Enumeration keyEnum = primaryKeyFieldsName.elements();
        while (keyEnum.hasMoreElements()) {
            this.addPrimaryKeyFieldName((String)keyEnum.nextElement());
        }
    }

    @Override
    public void setPrimaryKeyFields(List<DatabaseField> thePrimaryKeyFields) {
        this.primaryKeyFields = thePrimaryKeyFields;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public void setProperty(String name, Object value) {
        this.getProperties().put(name, value);
    }

    public void setQueryKeys(Map<String, QueryKey> queryKeys) {
        this.queryKeys = queryKeys;
    }

    public void setQueryManager(DescriptorQueryManager queryManager) {
        this.queryManager = queryManager;
        if (queryManager != null) {
            queryManager.setDescriptor(this);
        }
    }

    public void setRemoteIdentityMapClass(Class theIdentityMapClass) {
        this.getCachePolicy().setRemoteIdentityMapClass(theIdentityMapClass);
    }

    public void setRemoteIdentityMapSize(int identityMapSize) {
        this.getCachePolicy().setRemoteIdentityMapSize(identityMapSize);
    }

    public void setSequenceNumberField(DatabaseField sequenceNumberField) {
        this.sequenceNumberField = sequenceNumberField;
    }

    public void setSequenceNumberFieldName(String fieldName) {
        if (fieldName == null) {
            this.setSequenceNumberField(null);
        } else {
            this.setSequenceNumberField(new DatabaseField(fieldName));
        }
    }

    public void setSequenceNumberName(String name) {
        this.sequenceNumberName = name;
    }

    protected void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void setShouldAlwaysConformResultsInUnitOfWork(boolean shouldAlwaysConformResultsInUnitOfWork) {
        this.shouldAlwaysConformResultsInUnitOfWork = shouldAlwaysConformResultsInUnitOfWork;
    }

    public void setShouldAlwaysRefreshCache(boolean shouldAlwaysRefreshCache) {
        this.getCachePolicy().setShouldAlwaysRefreshCache(shouldAlwaysRefreshCache);
    }

    public void setShouldAlwaysRefreshCacheOnRemote(boolean shouldAlwaysRefreshCacheOnRemote) {
        this.getCachePolicy().setShouldAlwaysRefreshCacheOnRemote(shouldAlwaysRefreshCacheOnRemote);
    }

    public void setShouldBeReadOnly(boolean shouldBeReadOnly) {
        this.shouldBeReadOnly = shouldBeReadOnly;
    }

    public void setReadOnly() {
        this.setShouldBeReadOnly(true);
    }

    public void setShouldDisableCacheHits(boolean shouldDisableCacheHits) {
        this.getCachePolicy().setShouldDisableCacheHits(shouldDisableCacheHits);
    }

    public void setShouldDisableCacheHitsOnRemote(boolean shouldDisableCacheHitsOnRemote) {
        this.getCachePolicy().setShouldDisableCacheHitsOnRemote(shouldDisableCacheHitsOnRemote);
    }

    public void setShouldLockForClone(boolean shouldLockForClone) {
        this.shouldLockForClone = shouldLockForClone;
    }

    public void setShouldOnlyRefreshCacheIfNewerVersion(boolean shouldOnlyRefreshCacheIfNewerVersion) {
        this.getCachePolicy().setShouldOnlyRefreshCacheIfNewerVersion(shouldOnlyRefreshCacheIfNewerVersion);
    }

    public void setShouldOrderMappings(boolean shouldOrderMappings) {
        this.shouldOrderMappings = shouldOrderMappings;
    }

    public void setShouldRegisterResultsInUnitOfWork(boolean shouldRegisterResultsInUnitOfWork) {
        this.shouldRegisterResultsInUnitOfWork = shouldRegisterResultsInUnitOfWork;
    }

    public void setTableName(String tableName) throws DescriptorException {
        if (this.getTables().isEmpty()) {
            this.addTableName(tableName);
        } else {
            this.getTables().get(0).setPossiblyQualifiedName(tableName);
        }
    }

    public void setTableNames(Vector tableNames) {
        this.setTables(NonSynchronizedVector.newInstance(tableNames.size()));
        Enumeration tableEnum = tableNames.elements();
        while (tableEnum.hasMoreElements()) {
            this.addTableName((String)tableEnum.nextElement());
        }
    }

    public void setTablePerClassPolicy(TablePerClassPolicy tablePerClassPolicy) {
        this.interfacePolicy = tablePerClassPolicy;
        if (this.interfacePolicy != null) {
            this.interfacePolicy.setDescriptor(this);
        }
    }

    public void setTableQualifier(String tableQualifier) {
        Enumeration<DatabaseTable> enumtr = this.getTables().elements();
        while (enumtr.hasMoreElements()) {
            DatabaseTable table = enumtr.nextElement();
            table.setTableQualifier(tableQualifier);
        }
    }

    public void setTables(Vector<DatabaseTable> theTables) {
        this.tables = theTables;
    }

    public void setWrapperPolicy(WrapperPolicy wrapperPolicy) {
        this.wrapperPolicy = wrapperPolicy;
        if (wrapperPolicy != null) {
            wrapperPolicy.setDescriptor(this);
        }
        this.getObjectBuilder().setHasWrapperPolicy(wrapperPolicy != null);
    }

    public boolean shouldAlwaysConformResultsInUnitOfWork() {
        return this.shouldAlwaysConformResultsInUnitOfWork;
    }

    public boolean shouldAlwaysRefreshCache() {
        return this.getCachePolicy().shouldAlwaysRefreshCache();
    }

    public boolean shouldAlwaysRefreshCacheOnRemote() {
        return this.getCachePolicy().shouldAlwaysRefreshCacheOnRemote();
    }

    public boolean shouldBeReadOnly() {
        return this.shouldBeReadOnly;
    }

    public boolean shouldDisableCacheHits() {
        return this.getCachePolicy().shouldDisableCacheHits();
    }

    public boolean shouldDisableCacheHitsOnRemote() {
        return this.getCachePolicy().shouldDisableCacheHitsOnRemote();
    }

    public boolean shouldOnlyRefreshCacheIfNewerVersion() {
        return this.getCachePolicy().shouldOnlyRefreshCacheIfNewerVersion();
    }

    public boolean shouldOrderMappings() {
        return this.shouldOrderMappings;
    }

    public boolean hasSimplePrimaryKey() {
        return this.hasSimplePrimaryKey;
    }

    public boolean hasTablePerClassPolicy() {
        return this.hasInterfacePolicy() && this.interfacePolicy.isTablePerClassPolicy();
    }

    public void setHasSimplePrimaryKey(boolean hasSimplePrimaryKey) {
        this.hasSimplePrimaryKey = hasSimplePrimaryKey;
    }

    public boolean shouldAcquireCascadedLocks() {
        return this.shouldAcquireCascadedLocks;
    }

    public void setShouldAcquireCascadedLocks(boolean shouldAcquireCascadedLocks) {
        this.shouldAcquireCascadedLocks = shouldAcquireCascadedLocks;
    }

    public boolean shouldUseAdditionalJoinExpression() {
        return this.getQueryManager().getAdditionalJoinExpression() != null && (!this.hasInheritance() || !this.getInheritancePolicy().hasView());
    }

    public boolean shouldUseCacheIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.CacheIdentityMap_Class;
    }

    public boolean shouldUseFullIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.FullIdentityMap_Class;
    }

    public boolean shouldUseSoftIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.SoftIdentityMap_Class;
    }

    public boolean shouldUseRemoteSoftIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.SoftIdentityMap_Class;
    }

    public boolean shouldUseHardCacheWeakIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.HardCacheWeakIdentityMap_Class;
    }

    public boolean shouldUseNoIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.NoIdentityMap_Class;
    }

    public boolean shouldRegisterResultsInUnitOfWork() {
        return this.shouldRegisterResultsInUnitOfWork;
    }

    public boolean shouldUseRemoteCacheIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.CacheIdentityMap_Class;
    }

    public boolean shouldUseRemoteFullIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.FullIdentityMap_Class;
    }

    public boolean shouldUseRemoteHardCacheWeakIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.HardCacheWeakIdentityMap_Class;
    }

    public boolean shouldUseRemoteNoIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.NoIdentityMap_Class;
    }

    public boolean shouldUseRemoteSoftCacheWeakIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.SoftCacheWeakIdentityMap_Class;
    }

    public boolean shouldUseRemoteWeakIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.WeakIdentityMap_Class;
    }

    public boolean shouldUseSoftCacheWeakIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.SoftCacheWeakIdentityMap_Class;
    }

    public boolean shouldUseWeakIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.WeakIdentityMap_Class;
    }

    public boolean supportsChangeTracking(Project project) {
        OptimisticLockingPolicy lockingPolicy = this.getOptimisticLockingPolicy();
        if (lockingPolicy != null && lockingPolicy instanceof FieldsLockingPolicy) {
            return false;
        }
        Vector<DatabaseMapping> mappings = this.getMappings();
        for (DatabaseMapping mapping : mappings) {
            if (mapping.isChangeTrackingSupported(project)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.valueOf(Helper.getShortClassName(this.getClass())) + "(" + this.getJavaClassName() + " --> " + this.getTables() + ")";
    }

    public void useAllFieldsLocking() {
        this.setOptimisticLockingPolicy(new AllFieldsLockingPolicy());
    }

    public void useCacheIdentityMap() {
        this.setIdentityMapClass(ClassConstants.CacheIdentityMap_Class);
    }

    public void useChangedFieldsLocking() {
        this.setOptimisticLockingPolicy(new ChangedFieldsLockingPolicy());
    }

    public void useCloneCopyPolicy() {
        this.useCloneCopyPolicy("clone");
    }

    public void useCloneCopyPolicy(String cloneMethodName) {
        CloneCopyPolicy policy = new CloneCopyPolicy();
        policy.setMethodName(cloneMethodName);
        this.setCopyPolicy(policy);
    }

    public void useInstantiationCopyPolicy() {
        this.setCopyPolicy(new InstantiationCopyPolicy());
    }

    public void useDefaultConstructorInstantiationPolicy() {
        this.getInstantiationPolicy().useDefaultConstructorInstantiationPolicy();
    }

    public void useFactoryInstantiationPolicy(Class factoryClass, String methodName) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(factoryClass, methodName);
    }

    public void useFactoryInstantiationPolicy(String factoryClassName, String methodName) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(factoryClassName, methodName);
    }

    public void useFactoryInstantiationPolicy(Class factoryClass, String methodName, String factoryMethodName) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(factoryClass, methodName, factoryMethodName);
    }

    public void useFactoryInstantiationPolicy(String factoryClassName, String methodName, String factoryMethodName) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(factoryClassName, methodName, factoryMethodName);
    }

    public void useFactoryInstantiationPolicy(Object factory, String methodName) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(factory, methodName);
    }

    public void useFullIdentityMap() {
        this.getCachePolicy().useFullIdentityMap();
    }

    public void useHardCacheWeakIdentityMap() {
        this.getCachePolicy().useHardCacheWeakIdentityMap();
    }

    public void useSoftIdentityMap() {
        this.getCachePolicy().useSoftIdentityMap();
    }

    public void useRemoteSoftIdentityMap() {
        this.getCachePolicy().setRemoteIdentityMapClass(ClassConstants.SoftIdentityMap_Class);
    }

    public void useMethodInstantiationPolicy(String staticMethodName) {
        this.getInstantiationPolicy().useMethodInstantiationPolicy(staticMethodName);
    }

    public void useNoIdentityMap() {
        this.getCachePolicy().useNoIdentityMap();
    }

    public void useRemoteCacheIdentityMap() {
        this.getCachePolicy().setRemoteIdentityMapClass(ClassConstants.CacheIdentityMap_Class);
    }

    public void useRemoteFullIdentityMap() {
        this.getCachePolicy().setRemoteIdentityMapClass(ClassConstants.FullIdentityMap_Class);
    }

    public void useRemoteHardCacheWeakIdentityMap() {
        this.getCachePolicy().setRemoteIdentityMapClass(ClassConstants.HardCacheWeakIdentityMap_Class);
    }

    public void useRemoteNoIdentityMap() {
        this.getCachePolicy().setRemoteIdentityMapClass(ClassConstants.NoIdentityMap_Class);
    }

    public void useRemoteSoftCacheWeakIdentityMap() {
        this.getCachePolicy().setRemoteIdentityMapClass(ClassConstants.SoftCacheWeakIdentityMap_Class);
    }

    public void useRemoteWeakIdentityMap() {
        this.getCachePolicy().setRemoteIdentityMapClass(ClassConstants.WeakIdentityMap_Class);
    }

    public void useSelectedFieldsLocking(Vector fieldNames) {
        SelectedFieldsLockingPolicy policy = new SelectedFieldsLockingPolicy();
        policy.setLockFieldNames(fieldNames);
        this.setOptimisticLockingPolicy(policy);
    }

    public boolean usesFieldLocking() {
        return this.usesOptimisticLocking() && this.getOptimisticLockingPolicy() instanceof FieldsLockingPolicy;
    }

    public void useSoftCacheWeakIdentityMap() {
        this.setIdentityMapClass(ClassConstants.SoftCacheWeakIdentityMap_Class);
    }

    public boolean usesOptimisticLocking() {
        return this.optimisticLockingPolicy != null;
    }

    public boolean usesVersionLocking() {
        return this.usesOptimisticLocking() && this.getOptimisticLockingPolicy() instanceof VersionLockingPolicy;
    }

    public boolean usesSequenceNumbers() {
        return this.sequenceNumberField != null;
    }

    public void useTimestampLocking(String writeLockFieldName) {
        this.useTimestampLocking(writeLockFieldName, true);
    }

    public void useTimestampLocking(String writeLockFieldName, boolean shouldStoreInCache) {
        TimestampLockingPolicy policy = new TimestampLockingPolicy(writeLockFieldName);
        if (shouldStoreInCache) {
            policy.storeInCache();
        } else {
            policy.storeInObject();
        }
        this.setOptimisticLockingPolicy(policy);
    }

    public void useVersionLocking(String writeLockFieldName) {
        this.useVersionLocking(writeLockFieldName, true);
    }

    public void useVersionLocking(String writeLockFieldName, boolean shouldStoreInCache) {
        VersionLockingPolicy policy = new VersionLockingPolicy(writeLockFieldName);
        if (shouldStoreInCache) {
            policy.storeInCache();
        } else {
            policy.storeInObject();
        }
        this.setOptimisticLockingPolicy(policy);
    }

    public void useWeakIdentityMap() {
        this.getCachePolicy().useWeakIdentityMap();
    }

    protected void validateAfterInitialization(AbstractSession session) {
        this.selfValidationAfterInitialization(session);
        for (DatabaseMapping mapping : this.getMappings()) {
            mapping.validateAfterInitialization(session);
        }
    }

    protected void validateBeforeInitialization(AbstractSession session) {
        this.selfValidationBeforeInitialization(session);
        for (DatabaseMapping mapping : this.getMappings()) {
            mapping.validateBeforeInitialization(session);
        }
    }

    protected void verifyTableQualifiers(Platform platform) {
        String tableQualifier = platform.getTableQualifier();
        if (tableQualifier.length() == 0) {
            return;
        }
        for (DatabaseTable table : this.getTables()) {
            if (table.getTableQualifier().length() != 0) continue;
            table.setTableQualifier(tableQualifier);
        }
    }

    public CMPPolicy getCMPPolicy() {
        return this.cmpPolicy;
    }

    public void setCMPPolicy(CMPPolicy newCMPPolicy) {
        this.cmpPolicy = newCMPPolicy;
        if (this.cmpPolicy != null) {
            this.cmpPolicy.setDescriptor(this);
        }
    }

    public CachePolicy getCachePolicy() {
        if (this.cachePolicy == null) {
            this.cachePolicy = new CachePolicy();
        }
        return this.cachePolicy;
    }

    public void setCachePolicy(CachePolicy cachePolicy) {
        this.cachePolicy = cachePolicy;
    }

    public boolean hasPessimisticLockingPolicy() {
        return this.cmpPolicy != null && this.cmpPolicy.hasPessimisticLockingPolicy();
    }

    public FetchGroupManager getFetchGroupManager() {
        return this.fetchGroupManager;
    }

    public boolean getFullyMergeEntity() {
        return this.getCachePolicy().getFullyMergeEntity();
    }

    public void setFetchGroupManager(FetchGroupManager fetchGroupManager) {
        this.fetchGroupManager = fetchGroupManager;
        if (fetchGroupManager != null) {
            fetchGroupManager.setDescriptor(this);
        }
    }

    public boolean hasFetchGroupManager() {
        return this.fetchGroupManager != null;
    }

    public boolean hasCascadeLockingPolicies() {
        return this.cascadeLockingPolicies != null && !this.cascadeLockingPolicies.isEmpty();
    }

    public boolean hasCMPPolicy() {
        return this.cmpPolicy != null;
    }

    public FetchGroup getDefaultFetchGroup() {
        if (!this.hasFetchGroupManager()) {
            return null;
        }
        return this.getFetchGroupManager().getDefaultFetchGroup();
    }

    public boolean isReturnTypeRequiredForReturningPolicy() {
        return true;
    }

    public void setIsNativeConnectionRequired(boolean isNativeConnectionRequired) {
        this.isNativeConnectionRequired = isNativeConnectionRequired;
    }

    public boolean isNativeConnectionRequired() {
        return this.isNativeConnectionRequired;
    }

    public void setIdValidation(IdValidation idValidation) {
        this.idValidation = idValidation;
        if (this.getPrimaryKeyIdValidations() != null) {
            int index = 0;
            while (index < this.getPrimaryKeyIdValidations().size()) {
                this.getPrimaryKeyIdValidations().set(index, idValidation);
                ++index;
            }
        }
    }

    public IdValidation getIdValidation() {
        return this.idValidation;
    }

    public List<IdValidation> getPrimaryKeyIdValidations() {
        return this.primaryKeyIdValidations;
    }

    public void setPrimaryKeyIdValidations(List<IdValidation> primaryKeyIdValidations) {
        this.primaryKeyIdValidations = primaryKeyIdValidations;
    }

    public void setCacheKeyType(CacheKeyType cacheKeyType) {
        this.getCachePolicy().setCacheKeyType(cacheKeyType);
    }

    public CacheKeyType getCacheKeyType() {
        return this.getCachePolicy().getCacheKeyType();
    }

    public QueryRedirector getDefaultQueryRedirector() {
        return this.defaultQueryRedirector;
    }

    public void setDefaultQueryRedirector(QueryRedirector defaultRedirector) {
        this.defaultQueryRedirector = defaultRedirector;
    }

    public QueryRedirector getDefaultReadAllQueryRedirector() {
        return this.defaultReadAllQueryRedirector;
    }

    public void setDefaultReadAllQueryRedirector(QueryRedirector defaultReadAllQueryRedirector) {
        this.defaultReadAllQueryRedirector = defaultReadAllQueryRedirector;
    }

    public QueryRedirector getDefaultReadObjectQueryRedirector() {
        return this.defaultReadObjectQueryRedirector;
    }

    public void setDefaultReadObjectQueryRedirector(QueryRedirector defaultReadObjectQueryRedirector) {
        this.defaultReadObjectQueryRedirector = defaultReadObjectQueryRedirector;
    }

    public QueryRedirector getDefaultReportQueryRedirector() {
        return this.defaultReportQueryRedirector;
    }

    public void setDefaultReportQueryRedirector(QueryRedirector defaultReportQueryRedirector) {
        this.defaultReportQueryRedirector = defaultReportQueryRedirector;
    }

    public QueryRedirector getDefaultUpdateObjectQueryRedirector() {
        return this.defaultUpdateObjectQueryRedirector;
    }

    public void setDefaultUpdateObjectQueryRedirector(QueryRedirector defaultUpdateQueryRedirector) {
        this.defaultUpdateObjectQueryRedirector = defaultUpdateQueryRedirector;
    }

    public QueryRedirector getDefaultInsertObjectQueryRedirector() {
        return this.defaultInsertObjectQueryRedirector;
    }

    public void setDefaultInsertObjectQueryRedirector(QueryRedirector defaultInsertQueryRedirector) {
        this.defaultInsertObjectQueryRedirector = defaultInsertQueryRedirector;
    }

    public QueryRedirector getDefaultDeleteObjectQueryRedirector() {
        return this.defaultDeleteObjectQueryRedirector;
    }

    public void setDefaultDeleteObjectQueryRedirector(QueryRedirector defaultDeleteObjectQueryRedirector) {
        this.defaultDeleteObjectQueryRedirector = defaultDeleteObjectQueryRedirector;
    }

    public void setDefaultQueryRedirectorClassName(String defaultQueryRedirectorClassName) {
        this.defaultQueryRedirectorClassName = defaultQueryRedirectorClassName;
    }

    public void setDefaultReadAllQueryRedirectorClassName(String defaultReadAllQueryRedirectorClassName) {
        this.defaultReadAllQueryRedirectorClassName = defaultReadAllQueryRedirectorClassName;
    }

    public void setDefaultReadObjectQueryRedirectorClassName(String defaultReadObjectQueryRedirectorClassName) {
        this.defaultReadObjectQueryRedirectorClassName = defaultReadObjectQueryRedirectorClassName;
    }

    public void setDefaultReportQueryRedirectorClassName(String defaultReportQueryRedirectorClassName) {
        this.defaultReportQueryRedirectorClassName = defaultReportQueryRedirectorClassName;
    }

    public void setDefaultUpdateObjectQueryRedirectorClassName(String defaultUpdateObjectQueryRedirectorClassName) {
        this.defaultUpdateObjectQueryRedirectorClassName = defaultUpdateObjectQueryRedirectorClassName;
    }

    public void setDefaultInsertObjectQueryRedirectorClassName(String defaultInsertObjectQueryRedirectorClassName) {
        this.defaultInsertObjectQueryRedirectorClassName = defaultInsertObjectQueryRedirectorClassName;
    }

    public void setDefaultDeleteObjectQueryRedirectorClassName(String defaultDeleteObjectQueryRedirectorClassName) {
        this.defaultDeleteObjectQueryRedirectorClassName = defaultDeleteObjectQueryRedirectorClassName;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public List<DatabaseMapping> getMappingsPostCalculateChanges() {
        if (this.mappingsPostCalculateChanges == null) {
            this.mappingsPostCalculateChanges = new ArrayList<DatabaseMapping>();
        }
        return this.mappingsPostCalculateChanges;
    }

    public boolean hasMappingsPostCalculateChanges() {
        return this.mappingsPostCalculateChanges != null;
    }

    public void addMappingsPostCalculateChanges(DatabaseMapping mapping) {
        this.getMappingsPostCalculateChanges().add(mapping);
    }

    public List<DatabaseMapping> getMappingsPostCalculateChangesOnDeleted() {
        if (this.mappingsPostCalculateChangesOnDeleted == null) {
            this.mappingsPostCalculateChangesOnDeleted = new ArrayList<DatabaseMapping>();
        }
        return this.mappingsPostCalculateChangesOnDeleted;
    }

    public boolean hasMappingsPostCalculateChangesOnDeleted() {
        return this.mappingsPostCalculateChangesOnDeleted != null;
    }

    public void addMappingsPostCalculateChangesOnDeleted(DatabaseMapping mapping) {
        this.getMappingsPostCalculateChangesOnDeleted().add(mapping);
    }

    public boolean hasMultipleTableConstraintDependecy() {
        return this.hasMultipleTableConstraintDependecy;
    }

    public boolean hasMultitenantPolicy() {
        return this.multitenantPolicy != null;
    }

    public boolean hasTablePerMultitenantPolicy() {
        return this.hasMultitenantPolicy() && this.getMultitenantPolicy().isTablePerMultitenantPolicy();
    }

    public boolean hasUnconvertedProperties() {
        return this.unconvertedProperties != null;
    }

    public void setHasMultipleTableConstraintDependecy(boolean hasMultipleTableConstraintDependecy) {
        this.hasMultipleTableConstraintDependecy = hasMultipleTableConstraintDependecy;
    }

    public boolean usesPropertyAccessForWeaving() {
        return this.weavingUsesPropertyAccess;
    }

    public void usePropertyAccessForWeaving() {
        this.weavingUsesPropertyAccess = true;
    }

    public List<VirtualAttributeMethodInfo> getVirtualAttributeMethods() {
        if (this.virtualAttributeMethods == null) {
            this.virtualAttributeMethods = new ArrayList<VirtualAttributeMethodInfo>();
        }
        return this.virtualAttributeMethods;
    }

    public void setVirtualAttributeMethods(List<VirtualAttributeMethodInfo> virtualAttributeMethods) {
        this.virtualAttributeMethods = virtualAttributeMethods;
    }

    public boolean hasTargetForeignKeyMapping(AbstractSession session) {
        for (DatabaseMapping mapping : this.getMappings()) {
            if (mapping.isCollectionMapping() || mapping.isObjectReferenceMapping() && !((ObjectReferenceMapping)mapping).isForeignKeyRelationship() || mapping.isAbstractCompositeDirectCollectionMapping()) {
                return true;
            }
            if (!mapping.isAggregateObjectMapping()) continue;
            ClassDescriptor referenceDescriptor = ((AggregateObjectMapping)mapping).getReferenceDescriptor();
            if (referenceDescriptor == null) {
                referenceDescriptor = session.getDescriptor(((AggregateObjectMapping)mapping).getReferenceClass());
            }
            if (!referenceDescriptor.hasTargetForeignKeyMapping(session)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AttributeGroup getAttributeGroup(String name) {
        return (AttributeGroup)super.getAttributeGroup(name);
    }

    @Override
    public Map<String, AttributeGroup> getAttributeGroups() {
        return super.getAttributeGroups();
    }
}

