/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.concurrent;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;
import org.eclipse.persistence.testing.tests.performance.concurrent.IsolatedConcurrentTest;

public class UpdateAnyObjectIsolatedConcurrentTest
extends IsolatedConcurrentTest {
    protected int index;
    protected List allObjects;

    public UpdateAnyObjectIsolatedConcurrentTest() {
        this.setDescription("This tests the concurrency of updates.");
    }

    @Override
    public void setup() {
        super.setup();
        this.allObjects = new ArrayList(this.getServerSession().acquireClientSession().readAllObjects(Employee.class));
        this.index = 0;
    }

    public synchronized int incrementIndex() {
        ++this.index;
        if (this.index >= this.allObjects.size()) {
            this.index = 0;
        }
        return this.index;
    }

    public void runTask() throws Exception {
        int currentIndex = this.incrementIndex();
        Employee employee = (Employee)this.allObjects.get(currentIndex);
        ClientSession client = this.getServerSession().acquireClientSession();
        UnitOfWork uow = client.acquireUnitOfWork();
        employee = (Employee)uow.readObject((Object)employee);
        employee.setSalary(employee.getSalary() + 1);
        try {
            uow.commit();
        }
        catch (OptimisticLockException exception) {
            System.out.println((Object)exception);
        }
        client.release();
    }
}

