/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.report.ReportQueryTestCase;

public class Scenario5_3a
extends ReportQueryTestCase {
    public Scenario5_3a() {
        this.setDescription("Order By ASC, query key in items");
    }

    @Override
    protected void buildExpectedResults() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        query.addAscendingOrdering("lastName");
        query.addAscendingOrdering("firstName");
        Vector employees = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
        Enumeration e = employees.elements();
        while (e.hasMoreElements()) {
            Employee emp = (Employee)e.nextElement();
            Object[] result = new Object[]{emp.getFirstName(), emp.getLastName()};
            this.addResult(result, null);
        }
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        this.reportQuery = new ReportQuery(new ExpressionBuilder());
        this.reportQuery.setReferenceClass(Employee.class);
        this.reportQuery.addAttribute("firstName");
        this.reportQuery.addAttribute("lastName");
        this.reportQuery.addAscendingOrdering("lastName");
        this.reportQuery.addAscendingOrdering("firstName");
    }

    @Override
    protected void verify() {
        if (this.results.size() != this.expectedResults.size()) {
            throw new TestErrorException("ReportQuery test failed: The result size are different");
        }
        for (int index = 0; index < this.expectedResults.size(); ++index) {
            if (this.results.elementAt(index).equals(this.expectedResults.elementAt(index))) continue;
            throw new TestErrorException("ReportQuery test failed: The result are different or ordered differently");
        }
    }
}

