/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class SessionsXMLSchemaReloadTest
extends TestCase {
    DatabaseSession employeeSession;
    DatabaseSession employeeSession2;

    public SessionsXMLSchemaReloadTest() {
        this.setDescription("Test loading of a basic session xml against the XML Schema");
    }

    public void reset() {
        if (this.employeeSession != null && this.employeeSession.isConnected()) {
            this.employeeSession.logout();
            SessionManager.getManager().getSessions().remove(this.employeeSession);
            this.employeeSession = null;
        }
        if (this.employeeSession2 != null && this.employeeSession2.isConnected()) {
            this.employeeSession2.logout();
            SessionManager.getManager().getSessions().remove(this.employeeSession2);
            this.employeeSession2 = null;
        }
    }

    public void test() {
        SessionManager.getManager().getSessions().remove("EmployeeSession");
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader("org/eclipse/persistence/testing/models/sessionsxml/XMLSchemaSession.xml");
        this.employeeSession = (DatabaseSession)SessionManager.getManager().getSession(loader, "EmployeeSession", ((Object)((Object)this)).getClass().getClassLoader());
        this.employeeSession2 = (DatabaseSession)SessionManager.getManager().getSession(loader, "EmployeeSession", (ClassLoader)new AlternateLoader());
    }

    protected void verify() {
        if (this.employeeSession == null) {
            throw new TestErrorException("Employee session is null");
        }
        if (this.employeeSession.getDescriptor(Employee.class) == null) {
            throw new TestErrorException("Missing a descriptor from the Employee project");
        }
        if (this.employeeSession == this.employeeSession2) {
            throw new TestErrorException("Failed to reset session when loading with different class loader");
        }
        if (this.employeeSession.isConnected()) {
            throw new TestErrorException("Employee session is connected");
        }
        if (!this.employeeSession2.isConnected()) {
            throw new TestErrorException("Employee session # 2 is not connected");
        }
    }

    public class AlternateLoader
    extends ClassLoader {
        public AlternateLoader() {
            super(ClassLoader.getSystemClassLoader());
        }
    }
}

